/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jpa.support;

import org.jspecify.annotations.Nullable;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

public class JpaParameter {
    private static final ExpressionParser PARSER = new SpelExpressionParser();
    private @Nullable String name;
    private @Nullable Object value;
    private @Nullable String expression;
    private @Nullable Expression spelExpression;
    private @Nullable Expression projectionExpression;

    public JpaParameter() {
    }

    public JpaParameter(String name, @Nullable Object value, @Nullable String expression) {
        Assert.hasText((String)name, (String)"'name' must not be empty.");
        this.name = name;
        this.value = value;
        this.setExpression(expression);
    }

    public JpaParameter(@Nullable Object value, @Nullable String expression) {
        this.value = value;
        this.setExpression(expression);
    }

    public @Nullable String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public @Nullable Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public @Nullable String getExpression() {
        return this.expression;
    }

    public @Nullable Expression getSpelExpression() {
        return this.spelExpression;
    }

    public @Nullable Expression getProjectionExpression() {
        return this.projectionExpression;
    }

    public final void setExpression(@Nullable String expression) {
        if (expression != null) {
            this.expression = expression;
            this.spelExpression = PARSER.parseExpression(expression);
            this.projectionExpression = PARSER.parseExpression("#root.![" + expression + "]");
        }
    }

    public String toString() {
        return "JpaParameter [name=" + this.name + ", value=" + String.valueOf(this.value) + ", expression=" + this.expression + "]";
    }
}

