/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jpa.support.parametersource;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.integration.jpa.support.parametersource.BeanPropertyParameterSource;
import org.springframework.integration.jpa.support.parametersource.ParameterSource;
import org.springframework.integration.jpa.support.parametersource.ParameterSourceFactory;

public class BeanPropertyParameterSourceFactory
implements ParameterSourceFactory {
    private volatile Map<String, Object> staticParameters = Collections.unmodifiableMap(new HashMap());

    public void setStaticParameters(Map<String, Object> staticParameters) {
        this.staticParameters = staticParameters;
    }

    @Override
    public ParameterSource createParameterSource(Object input) {
        StaticBeanPropertyParameterSource toReturn = new StaticBeanPropertyParameterSource(input, this.staticParameters);
        return toReturn;
    }

    private static final class StaticBeanPropertyParameterSource
    implements ParameterSource {
        private final BeanPropertyParameterSource input;
        private final Map<String, Object> staticParameters;

        StaticBeanPropertyParameterSource(Object input, Map<String, Object> staticParameters) {
            this.input = new BeanPropertyParameterSource(input);
            this.staticParameters = staticParameters;
        }

        @Override
        public Object getValue(String paramName) {
            return this.staticParameters.containsKey(paramName) ? this.staticParameters.get(paramName) : this.input.getValue(paramName);
        }

        @Override
        public boolean hasValue(String paramName) {
            return this.staticParameters.containsKey(paramName) || this.input.hasValue(paramName);
        }
    }
}

