/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jpa.config.xml;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractOutboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.jpa.config.xml.JpaParserUtils;
import org.springframework.integration.jpa.outbound.JpaOutboundGatewayFactoryBean;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class JpaOutboundChannelAdapterParser
extends AbstractOutboundChannelAdapterParser {
    protected boolean shouldGenerateId() {
        return false;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected AbstractBeanDefinition parseConsumer(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder jpaOutboundChannelAdapterBuilder = BeanDefinitionBuilder.genericBeanDefinition(JpaOutboundGatewayFactoryBean.class);
        BeanDefinitionBuilder jpaExecutorBuilder = JpaParserUtils.getJpaExecutorBuilder(element, parserContext);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)jpaExecutorBuilder, (Element)element, (String)"persist-mode");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)jpaExecutorBuilder, (Element)element, (String)"flush");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)jpaExecutorBuilder, (Element)element, (String)"flush-size");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)jpaExecutorBuilder, (Element)element, (String)"clear-on-flush");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)jpaExecutorBuilder, (Element)element, (String)"parameter-source-factory");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)jpaExecutorBuilder, (Element)element, (String)"use-payload-as-parameter-source");
        AbstractBeanDefinition jpaExecutorBuilderBeanDefinition = jpaExecutorBuilder.getBeanDefinition();
        String channelAdapterId = this.resolveId(element, jpaOutboundChannelAdapterBuilder.getRawBeanDefinition(), parserContext);
        String jpaExecutorBeanName = channelAdapterId + ".jpaExecutor";
        parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)jpaExecutorBuilderBeanDefinition, jpaExecutorBeanName));
        jpaOutboundChannelAdapterBuilder.addConstructorArgReference(jpaExecutorBeanName);
        jpaOutboundChannelAdapterBuilder.addPropertyValue("producesReply", (Object)Boolean.FALSE);
        Element transactionalElement = DomUtils.getChildElementByTagName((Element)element, (String)"transactional");
        if (transactionalElement != null) {
            BeanDefinition txAdviceDefinition = IntegrationNamespaceUtils.configureTransactionAttributes((Element)transactionalElement);
            ManagedList adviceChain = new ManagedList();
            adviceChain.add((Object)txAdviceDefinition);
            jpaOutboundChannelAdapterBuilder.addPropertyValue("txAdviceChain", (Object)adviceChain);
        }
        return jpaOutboundChannelAdapterBuilder.getBeanDefinition();
    }

    protected boolean isUsingReplyProducer() {
        return true;
    }
}

