/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.Topic;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.Expression;
import org.springframework.integration.JavaUtils;
import org.springframework.integration.MessageTimeoutException;
import org.springframework.integration.StaticMessageHeaderAccessor;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.handler.ExpressionEvaluatingMessageProcessor;
import org.springframework.integration.jms.DefaultJmsHeaderMapper;
import org.springframework.integration.jms.JmsHeaderMapper;
import org.springframework.integration.jms.JmsTimeoutException;
import org.springframework.integration.jms.util.JmsAdapterUtils;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.support.management.ManageableLifecycle;
import org.springframework.jms.connection.ConnectionFactoryUtils;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.SimpleMessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.jms.support.destination.DynamicDestinationResolver;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class JmsOutboundGateway
extends AbstractReplyProducingMessageHandler
implements ManageableLifecycle,
MessageListener {
    public static final long DEFAULT_RECEIVE_TIMEOUT = 5000L;
    private final Lock initializationMonitor = new ReentrantLock();
    private final AtomicLong correlationId = new AtomicLong();
    private final String gatewayCorrelation = UUID.randomUUID().toString();
    private final Map<String, LinkedBlockingQueue<Message>> replies = new ConcurrentHashMap<String, LinkedBlockingQueue<Message>>();
    private final ConcurrentHashMap<String, TimedReply> earlyOrLateReplies = new ConcurrentHashMap();
    private final Lock earlyOrLateRepliesMonitor = new ReentrantLock();
    private final Map<String, CompletableFuture<AbstractIntegrationMessageBuilder<?>>> futures = new ConcurrentHashMap();
    private final Lock lifeCycleMonitor = new ReentrantLock();
    private Destination requestDestination;
    private String requestDestinationName;
    private ExpressionEvaluatingMessageProcessor<?> requestDestinationExpressionProcessor;
    private Destination replyDestination;
    private String replyDestinationName;
    private ExpressionEvaluatingMessageProcessor<?> replyDestinationExpressionProcessor;
    private DestinationResolver destinationResolver = new DynamicDestinationResolver();
    private boolean requestPubSubDomain;
    private boolean replyPubSubDomain;
    private long receiveTimeout = 5000L;
    private int deliveryMode = 2;
    private long timeToLive = 0L;
    private int defaultPriority = 4;
    private boolean explicitQosEnabled;
    private ConnectionFactory connectionFactory;
    private MessageConverter messageConverter = new SimpleMessageConverter();
    private JmsHeaderMapper headerMapper = new DefaultJmsHeaderMapper();
    private String correlationKey;
    private boolean extractRequestPayload = true;
    private boolean extractReplyPayload = true;
    private GatewayReplyListenerContainer replyContainer;
    private ReplyContainerProperties replyContainerProperties;
    private boolean useReplyContainer;
    private boolean requiresReply;
    private long idleReplyContainerTimeout;
    private volatile boolean active;
    private volatile boolean initialized;
    private volatile ScheduledFuture<?> reaper;
    private volatile boolean wasStopped;
    private volatile ScheduledFuture<?> idleTask;
    private volatile long lastSend;

    public void setDeliveryPersistent(boolean deliveryPersistent) {
        this.deliveryMode = deliveryPersistent ? 2 : 1;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setRequestDestination(Destination requestDestination) {
        if (requestDestination instanceof Topic) {
            this.requestPubSubDomain = true;
        }
        this.requestDestination = requestDestination;
    }

    public void setRequestDestinationName(String requestDestinationName) {
        this.requestDestinationName = requestDestinationName;
    }

    public void setRequestDestinationExpression(Expression requestDestinationExpression) {
        Assert.notNull((Object)requestDestinationExpression, (String)"'requestDestinationExpression' must not be null");
        this.requestDestinationExpressionProcessor = new ExpressionEvaluatingMessageProcessor(requestDestinationExpression);
        this.setPrimaryExpression(requestDestinationExpression);
    }

    public void setReplyDestination(Destination replyDestination) {
        if (replyDestination instanceof Topic) {
            this.replyPubSubDomain = true;
        }
        this.replyDestination = replyDestination;
    }

    public void setReplyDestinationName(String replyDestinationName) {
        this.replyDestinationName = replyDestinationName;
    }

    public void setReplyDestinationExpression(Expression replyDestinationExpression) {
        Assert.notNull((Object)replyDestinationExpression, (String)"'replyDestinationExpression' must not be null");
        this.replyDestinationExpressionProcessor = new ExpressionEvaluatingMessageProcessor(replyDestinationExpression);
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        this.destinationResolver = destinationResolver;
    }

    public void setRequestPubSubDomain(boolean requestPubSubDomain) {
        this.requestPubSubDomain = requestPubSubDomain;
    }

    public void setReplyPubSubDomain(boolean replyPubSubDomain) {
        this.replyPubSubDomain = replyPubSubDomain;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public void setDefaultPriority(int priority) {
        this.defaultPriority = priority;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public void setExplicitQosEnabled(boolean explicitQosEnabled) {
        this.explicitQosEnabled = explicitQosEnabled;
    }

    public void setCorrelationKey(String correlationKey) {
        this.correlationKey = correlationKey;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"'messageConverter' must not be null");
        this.messageConverter = messageConverter;
    }

    public void setHeaderMapper(JmsHeaderMapper headerMapper) {
        this.headerMapper = headerMapper;
    }

    public void setExtractRequestPayload(boolean extractRequestPayload) {
        this.extractRequestPayload = extractRequestPayload;
    }

    public void setExtractReplyPayload(boolean extractReplyPayload) {
        this.extractReplyPayload = extractReplyPayload;
    }

    public void setReplyChannel(MessageChannel replyChannel) {
        this.setOutputChannel(replyChannel);
    }

    public void setReplyContainerProperties(ReplyContainerProperties replyContainerProperties) {
        this.replyContainerProperties = replyContainerProperties;
        this.useReplyContainer = true;
    }

    public String getComponentType() {
        return "jms:outbound-gateway";
    }

    public void setUseReplyContainer(boolean useReplyContainer) {
        this.useReplyContainer = useReplyContainer;
    }

    public void setRequiresReply(boolean requiresReply) {
        super.setRequiresReply(requiresReply);
        this.requiresReply = requiresReply;
    }

    public void setIdleReplyContainerTimeout(long idleReplyContainerTimeout) {
        this.setIdleReplyContainerTimeout(idleReplyContainerTimeout, TimeUnit.SECONDS);
    }

    public void setIdleReplyContainerTimeout(long idleReplyContainerTimeout, TimeUnit unit) {
        this.idleReplyContainerTimeout = unit.toMillis(idleReplyContainerTimeout);
    }

    private Destination determineRequestDestination(org.springframework.messaging.Message<?> message, Session session) throws JMSException {
        if (this.requestDestination != null) {
            return this.requestDestination;
        }
        if (this.requestDestinationName != null) {
            return this.resolveRequestDestination(this.requestDestinationName, session);
        }
        if (this.requestDestinationExpressionProcessor != null) {
            Object result = this.requestDestinationExpressionProcessor.processMessage(message);
            if (result instanceof Destination) {
                Destination destination = (Destination)result;
                return destination;
            }
            if (result instanceof String) {
                String destinationName = (String)result;
                return this.resolveRequestDestination(destinationName, session);
            }
            throw new MessageDeliveryException(message, "Evaluation of requestDestinationExpression failed to produce a Destination or destination name. Result was: " + String.valueOf(result));
        }
        throw new MessageDeliveryException(message, "No requestDestination, requestDestinationName, or requestDestinationExpression has been configured.");
    }

    private Destination resolveRequestDestination(String reqDestinationName, Session session) throws JMSException {
        Assert.notNull((Object)this.destinationResolver, (String)"DestinationResolver is required when relying upon the 'requestDestinationName' property.");
        return this.destinationResolver.resolveDestinationName(session, reqDestinationName, this.requestPubSubDomain);
    }

    private Destination determineReplyDestination(org.springframework.messaging.Message<?> message, Session session) throws JMSException {
        if (this.replyDestination != null) {
            return this.replyDestination;
        }
        if (this.replyDestinationName != null) {
            return this.resolveReplyDestination(this.replyDestinationName, session);
        }
        if (this.replyDestinationExpressionProcessor != null) {
            Object result = this.replyDestinationExpressionProcessor.processMessage(message);
            if (result instanceof Destination) {
                Destination destination = (Destination)result;
                return destination;
            }
            if (result instanceof String) {
                String destinationName = (String)result;
                return this.resolveReplyDestination(destinationName, session);
            }
            throw new MessageDeliveryException(message, "Evaluation of replyDestinationExpression failed to produce a Destination or destination name. Result was: " + String.valueOf(result));
        }
        return this.replyPubSubDomain ? session.createTemporaryTopic() : session.createTemporaryQueue();
    }

    private Destination resolveReplyDestination(String repDestinationName, Session session) throws JMSException {
        Assert.notNull((Object)this.destinationResolver, (String)"DestinationResolver is required when relying upon the 'replyDestinationName' property.");
        return this.destinationResolver.resolveDestinationName(session, repDestinationName, this.replyPubSubDomain);
    }

    protected void doInit() {
        this.initializationMonitor.lock();
        try {
            if (this.initialized) {
                return;
            }
            Assert.notNull((Object)this.connectionFactory, (String)"connectionFactory must not be null");
            Assert.isTrue((boolean)(this.requestDestination != null ^ this.requestDestinationName != null ^ this.requestDestinationExpressionProcessor != null), (String)"Exactly one of 'requestDestination', 'requestDestinationName', or 'requestDestinationExpression' is required.");
            ConversionService conversionService = this.getConversionService();
            BeanFactory beanFactory = this.getBeanFactory();
            if (this.requestDestinationExpressionProcessor != null) {
                this.requestDestinationExpressionProcessor.setBeanFactory(beanFactory);
                if (conversionService != null) {
                    this.requestDestinationExpressionProcessor.setConversionService(conversionService);
                }
            }
            if (this.replyDestinationExpressionProcessor != null) {
                this.replyDestinationExpressionProcessor.setBeanFactory(beanFactory);
                if (conversionService != null) {
                    this.replyDestinationExpressionProcessor.setConversionService(conversionService);
                }
            }
            this.initializeReplyContainer();
            this.initialized = true;
        }
        finally {
            this.initializationMonitor.unlock();
        }
    }

    private void initializeReplyContainer() {
        boolean hasAReplyDest;
        boolean bl = hasAReplyDest = this.replyDestination != null || this.replyDestinationName != null || this.replyDestinationExpressionProcessor != null;
        if (this.useReplyContainer && this.correlationKey == null && hasAReplyDest) {
            this.logger.warn((CharSequence)"The gateway cannot use a reply listener container with a specified destination(Name/Expression) without a 'correlation-key'; a container will NOT be used; to avoid this problem, set the 'correlation-key' attribute; some consumers, including the Spring Integration <jms:inbound-gateway/>, support the use of the value 'JMSCorrelationID' for this purpose. Alternatively, do not specify a reply destination and a temporary queue will be used for replies.");
            this.useReplyContainer = false;
        }
        if (this.useReplyContainer) {
            Assert.state((!"JMSCorrelationID*".equals(this.correlationKey) ? 1 : 0) != 0, (String)"Using an existing 'JMSCorrelationID' mapped from the 'requestMessage' ('JMSCorrelationID*') can't be used when using a 'reply-container'");
            GatewayReplyListenerContainer container = new GatewayReplyListenerContainer();
            this.setContainerProperties(container);
            container.afterPropertiesSet();
            this.replyContainer = container;
            if (this.isAsync() && this.correlationKey == null) {
                this.logger.warn((CharSequence)"'async=true' requires a correlationKey; ignored");
                this.setAsync(false);
            }
        } else if (this.isAsync()) {
            this.logger.warn((CharSequence)"'async=true' is ignored when a reply container is not being used");
            this.setAsync(false);
        }
    }

    private void setContainerProperties(GatewayReplyListenerContainer container) {
        container.setConnectionFactory(this.connectionFactory);
        if (this.replyDestination != null) {
            container.setDestination(this.replyDestination);
        } else if (StringUtils.hasText((String)this.replyDestinationName)) {
            container.setDestinationName(this.replyDestinationName);
        } else {
            container.setDestinationName("");
        }
        if (this.destinationResolver != null) {
            container.setDestinationResolver(this.destinationResolver);
        }
        container.setPubSubDomain(this.replyPubSubDomain);
        if (this.correlationKey != null) {
            String messageSelector = this.correlationKey + " LIKE '" + this.gatewayCorrelation + "%'";
            container.setMessageSelector(messageSelector);
        }
        container.setMessageListener((Object)this);
        this.applyReplyContainerProperties(container);
    }

    private void applyReplyContainerProperties(GatewayReplyListenerContainer container) {
        if (this.replyContainerProperties != null) {
            JavaUtils.INSTANCE.acceptIfNotNull((Object)this.replyContainerProperties.isSessionTransacted(), arg_0 -> ((GatewayReplyListenerContainer)container).setSessionTransacted(arg_0)).acceptIfNotNull((Object)this.replyContainerProperties.getCacheLevel(), arg_0 -> ((GatewayReplyListenerContainer)container).setCacheLevel(arg_0)).acceptIfNotNull((Object)this.replyContainerProperties.getConcurrentConsumers(), arg_0 -> ((GatewayReplyListenerContainer)container).setConcurrentConsumers(arg_0)).acceptIfNotNull((Object)this.replyContainerProperties.getIdleConsumerLimit(), arg_0 -> ((GatewayReplyListenerContainer)container).setIdleConsumerLimit(arg_0)).acceptIfNotNull((Object)this.replyContainerProperties.getIdleTaskExecutionLimit(), arg_0 -> ((GatewayReplyListenerContainer)container).setIdleTaskExecutionLimit(arg_0)).acceptIfNotNull((Object)this.replyContainerProperties.getMaxConcurrentConsumers(), arg_0 -> ((GatewayReplyListenerContainer)container).setMaxConcurrentConsumers(arg_0)).acceptIfNotNull((Object)this.replyContainerProperties.getMaxMessagesPerTask(), arg_0 -> ((GatewayReplyListenerContainer)container).setMaxMessagesPerTask(arg_0)).acceptIfNotNull((Object)this.replyContainerProperties.getReceiveTimeout(), arg_0 -> ((GatewayReplyListenerContainer)container).setReceiveTimeout(arg_0)).acceptIfNotNull((Object)this.replyContainerProperties.getRecoveryInterval(), arg_0 -> ((GatewayReplyListenerContainer)container).setRecoveryInterval(arg_0)).acceptIfHasText(this.replyContainerProperties.getSessionAcknowledgeModeName(), acknowledgeModeName -> {
                Integer acknowledgeMode = JmsAdapterUtils.parseAcknowledgeMode(this.replyContainerProperties.getSessionAcknowledgeModeName());
                if (acknowledgeMode != null) {
                    if (0 == acknowledgeMode) {
                        container.setSessionTransacted(true);
                    } else {
                        container.setSessionAcknowledgeMode(acknowledgeMode);
                    }
                }
            }).acceptIfNotNull((Object)this.replyContainerProperties.getSessionAcknowledgeMode(), acknowledgeMode -> {
                if (0 == acknowledgeMode) {
                    container.setSessionTransacted(true);
                } else {
                    container.setSessionAcknowledgeMode((int)acknowledgeMode);
                }
            }).acceptIfNotNull((Object)this.replyContainerProperties.getTaskExecutor(), arg_0 -> ((GatewayReplyListenerContainer)container).setTaskExecutor(arg_0));
            if (this.replyContainerProperties.getTaskExecutor() == null) {
                Object containerBeanName = this.getComponentName();
                containerBeanName = (String)(!StringUtils.hasText((String)containerBeanName) ? "JMS_OutboundGateway@" + ObjectUtils.getIdentityHexString((Object)((Object)this)) : containerBeanName) + ".replyListener";
                container.setBeanName((String)containerBeanName);
            }
        }
    }

    public void start() {
        this.lifeCycleMonitor.lock();
        try {
            if (!this.active) {
                if (this.replyContainer != null) {
                    TaskScheduler taskScheduler = this.getTaskScheduler();
                    if (this.idleReplyContainerTimeout <= 0L) {
                        if (this.wasStopped) {
                            this.replyContainer.initialize();
                            this.wasStopped = false;
                        }
                        this.replyContainer.start();
                    } else {
                        Assert.state((taskScheduler != null ? 1 : 0) != 0, (String)"'taskScheduler' is required.");
                    }
                    if (!this.isAsync() && this.receiveTimeout >= 0L) {
                        Assert.state((taskScheduler != null ? 1 : 0) != 0, (String)"'taskScheduler' is required.");
                        this.reaper = taskScheduler.schedule((Runnable)new LateReplyReaper(), Instant.now());
                    }
                }
                this.active = true;
            }
        }
        finally {
            this.lifeCycleMonitor.unlock();
        }
    }

    public void stop() {
        this.lifeCycleMonitor.lock();
        try {
            if (this.replyContainer != null) {
                this.replyContainer.shutdown();
                this.wasStopped = true;
                this.deleteDestinationIfTemporary(this.replyContainer.getDestination());
                if (this.reaper != null) {
                    this.reaper.cancel(false);
                }
            }
            if (this.idleTask != null) {
                this.idleTask.cancel(true);
                this.idleTask = null;
            }
            this.active = false;
        }
        finally {
            this.lifeCycleMonitor.unlock();
        }
    }

    public boolean isRunning() {
        return this.active;
    }

    protected Object handleRequestMessage(org.springframework.messaging.Message<?> requestMessage) {
        if (!this.initialized) {
            this.afterPropertiesSet();
        }
        try {
            Object reply;
            if (this.replyContainer == null) {
                reply = this.sendAndReceiveWithoutContainer(requestMessage);
            } else {
                if (this.idleReplyContainerTimeout > 0L) {
                    this.lifeCycleMonitor.lock();
                    try {
                        this.lastSend = System.currentTimeMillis();
                        if (!this.replyContainer.isRunning()) {
                            this.logger.debug(() -> this.getComponentName() + ": Starting reply container.");
                            this.replyContainer.start();
                            this.idleTask = this.getTaskScheduler().scheduleAtFixedRate((Runnable)new IdleContainerStopper(), Duration.ofMillis(this.idleReplyContainerTimeout / 2L));
                        }
                    }
                    finally {
                        this.lifeCycleMonitor.unlock();
                    }
                }
                reply = this.sendAndReceiveWithContainer(requestMessage);
            }
            if (reply == null) {
                if (this.requiresReply) {
                    throw new MessageTimeoutException(requestMessage, "failed to receive JMS response within timeout of: " + this.receiveTimeout + "ms");
                }
                return null;
            }
            if (reply instanceof Message) {
                Object jmsMessage = reply;
                return this.buildReply((Message)jmsMessage);
            }
            return reply;
        }
        catch (JMSException e) {
            throw new MessageHandlingException(requestMessage, "failed to handle a message in the [" + String.valueOf((Object)this) + "]", (Throwable)e);
        }
    }

    private AbstractIntegrationMessageBuilder<?> buildReply(Message jmsReply) throws JMSException {
        Object result;
        if (this.extractReplyPayload) {
            result = this.messageConverter.fromMessage(jmsReply);
            this.logger.debug(() -> "converted JMS Message [" + String.valueOf(jmsReply) + "] to integration Message payload [" + String.valueOf(result) + "]");
        } else {
            result = jmsReply;
        }
        Map jmsReplyHeaders = this.headerMapper.toHeaders(jmsReply);
        if (this.replyContainer != null && this.correlationKey != null) {
            jmsReplyHeaders.remove(this.correlationKey);
        }
        if (result instanceof org.springframework.messaging.Message) {
            org.springframework.messaging.Message message = (org.springframework.messaging.Message)result;
            return this.getMessageBuilderFactory().fromMessage(message).copyHeaders(jmsReplyHeaders);
        }
        return this.getMessageBuilderFactory().withPayload(result).copyHeaders(jmsReplyHeaders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object sendAndReceiveWithContainer(org.springframework.messaging.Message<?> requestMessage) throws JMSException {
        Connection connection = this.createConnection();
        Session session = null;
        Destination replyTo = this.replyContainer.getReplyDestination();
        try {
            Object reply;
            session = this.createSession(connection);
            Object objectToSend = requestMessage;
            if (this.extractRequestPayload) {
                objectToSend = requestMessage.getPayload();
            }
            Message jmsRequest = this.messageConverter.toMessage(objectToSend, session);
            this.headerMapper.fromHeaders(requestMessage.getHeaders(), jmsRequest);
            jmsRequest.setJMSReplyTo(replyTo);
            connection.start();
            this.logger.debug(() -> "ReplyTo: " + String.valueOf(replyTo));
            Integer priority = StaticMessageHeaderAccessor.getPriority(requestMessage);
            if (priority == null) {
                priority = this.defaultPriority;
            }
            Destination destination = this.determineRequestDestination(requestMessage, session);
            if (this.correlationKey == null) {
                jmsRequest.setJMSCorrelationID(null);
                reply = this.doSendAndReceiveAsyncDefaultCorrelation(destination, jmsRequest, session, priority);
            } else {
                reply = this.doSendAndReceiveAsync(destination, jmsRequest, session, priority);
            }
            if (reply instanceof Message) {
                Message jmsMessage = (Message)reply;
                jmsMessage.setJMSCorrelationID(null);
            }
            Object object = reply;
            return object;
        }
        finally {
            JmsUtils.closeSession((Session)session);
            ConnectionFactoryUtils.releaseConnection((Connection)connection, (ConnectionFactory)this.connectionFactory, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message sendAndReceiveWithoutContainer(org.springframework.messaging.Message<?> requestMessage) throws JMSException {
        Message message;
        Connection connection = this.createConnection();
        Session session = null;
        Destination replyTo = null;
        try {
            session = this.createSession(connection);
            Object objectToSend = requestMessage;
            if (this.extractRequestPayload) {
                objectToSend = requestMessage.getPayload();
            }
            Message jmsRequest = this.messageConverter.toMessage(objectToSend, session);
            this.headerMapper.fromHeaders(requestMessage.getHeaders(), jmsRequest);
            Destination theReplyTo = this.determineReplyDestination(requestMessage, session);
            jmsRequest.setJMSReplyTo(theReplyTo);
            connection.start();
            this.logger.debug(() -> "ReplyTo: " + String.valueOf(theReplyTo));
            replyTo = theReplyTo;
            Integer priority = StaticMessageHeaderAccessor.getPriority(requestMessage);
            if (priority == null) {
                priority = this.defaultPriority;
            }
            Destination destination = this.determineRequestDestination(requestMessage, session);
            Message replyMessage = this.correlationKey != null ? this.doSendAndReceiveWithGeneratedCorrelationId(destination, jmsRequest, replyTo, session, priority) : (replyTo instanceof TemporaryQueue || replyTo instanceof TemporaryTopic ? this.doSendAndReceiveWithTemporaryReplyToDestination(destination, jmsRequest, replyTo, session, priority) : this.doSendAndReceiveWithMessageIdCorrelation(destination, jmsRequest, replyTo, session, priority));
            message = replyMessage;
        }
        catch (Throwable throwable) {
            JmsUtils.closeSession((Session)session);
            this.deleteDestinationIfTemporary(replyTo);
            ConnectionFactoryUtils.releaseConnection((Connection)connection, (ConnectionFactory)this.connectionFactory, (boolean)true);
            throw throwable;
        }
        JmsUtils.closeSession((Session)session);
        this.deleteDestinationIfTemporary(replyTo);
        ConnectionFactoryUtils.releaseConnection((Connection)connection, (ConnectionFactory)this.connectionFactory, (boolean)true);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message doSendAndReceiveWithGeneratedCorrelationId(Destination reqDestination, Message jmsRequest, Destination replyTo, Session session, int priority) throws JMSException {
        MessageProducer messageProducer = null;
        try {
            String messageSelector;
            messageProducer = session.createProducer(reqDestination);
            Assert.state((this.correlationKey != null ? 1 : 0) != 0, (String)"correlationKey must not be null");
            if (!this.correlationKey.equals("JMSCorrelationID*") || jmsRequest.getJMSCorrelationID() == null) {
                String correlation = UUID.randomUUID().toString().replaceAll("'", "''");
                if (this.correlationKey.equals("JMSCorrelationID")) {
                    jmsRequest.setJMSCorrelationID(correlation);
                    messageSelector = "JMSCorrelationID = '" + correlation + "'";
                } else {
                    jmsRequest.setStringProperty(this.correlationKey, correlation);
                    jmsRequest.setJMSCorrelationID(null);
                    messageSelector = this.correlationKey + " = '" + correlation + "'";
                }
            } else {
                messageSelector = "JMSCorrelationID = '" + jmsRequest.getJMSCorrelationID() + "'";
            }
            this.sendRequestMessage(jmsRequest, messageProducer, priority);
            Message message = this.retryableReceiveReply(session, replyTo, messageSelector);
            return message;
        }
        finally {
            JmsUtils.closeMessageProducer((MessageProducer)messageProducer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message doSendAndReceiveWithTemporaryReplyToDestination(Destination reqDestination, Message jmsRequest, Destination replyTo, Session session, int priority) throws JMSException {
        Message message;
        MessageProducer messageProducer = null;
        MessageConsumer messageConsumer = null;
        try {
            messageProducer = session.createProducer(reqDestination);
            messageConsumer = session.createConsumer(replyTo);
            this.sendRequestMessage(jmsRequest, messageProducer, priority);
            message = this.receiveReplyMessage(messageConsumer);
        }
        catch (Throwable throwable) {
            JmsUtils.closeMessageProducer((MessageProducer)messageProducer);
            JmsUtils.closeMessageConsumer(messageConsumer);
            throw throwable;
        }
        JmsUtils.closeMessageProducer((MessageProducer)messageProducer);
        JmsUtils.closeMessageConsumer((MessageConsumer)messageConsumer);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message doSendAndReceiveWithMessageIdCorrelation(Destination reqDestination, Message jmsRequest, Destination replyTo, Session session, int priority) throws JMSException {
        if (replyTo instanceof Topic) {
            this.logger.warn((CharSequence)"Relying on the MessageID for correlation is not recommended when using a Topic as the replyTo Destination because that ID can only be provided to a MessageSelector after the request Message has been sent thereby creating a race condition where a fast response might be sent before the MessageConsumer has been created. Consider providing a value to the 'correlationKey' property of this gateway instead. Then the MessageConsumer will be created before the request Message is sent.");
        }
        MessageProducer messageProducer = null;
        try {
            messageProducer = session.createProducer(reqDestination);
            this.sendRequestMessage(jmsRequest, messageProducer, priority);
            String messageId = jmsRequest.getJMSMessageID().replaceAll("'", "''");
            String messageSelector = "JMSCorrelationID = '" + messageId + "'";
            Message message = this.retryableReceiveReply(session, replyTo, messageSelector);
            return message;
        }
        finally {
            JmsUtils.closeMessageProducer((MessageProducer)messageProducer);
        }
    }

    /*
     * Exception decompiling
     */
    private Message retryableReceiveReply(Session session, Destination replyTo, String messageSelector) throws JMSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK], 11[DOLOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doSendAndReceiveAsync(Destination reqDestination, Message jmsRequest, Session session, int priority) throws JMSException {
        String correlation = null;
        MessageProducer messageProducer = null;
        try {
            messageProducer = session.createProducer(reqDestination);
            correlation = this.gatewayCorrelation + "_" + this.correlationId.incrementAndGet();
            if (this.correlationKey.equals("JMSCorrelationID")) {
                jmsRequest.setJMSCorrelationID(correlation);
            } else {
                jmsRequest.setStringProperty(this.correlationKey, correlation);
                jmsRequest.setJMSCorrelationID(null);
            }
            LinkedBlockingQueue<Message> replyQueue = null;
            String correlationToLog = correlation;
            this.logger.debug(() -> this.getComponentName() + " Sending message with correlationId " + correlationToLog);
            CompletableFuture<AbstractIntegrationMessageBuilder<?>> future = null;
            boolean async = this.isAsync();
            if (!async) {
                replyQueue = new LinkedBlockingQueue<Message>(1);
                this.replies.put(correlation, replyQueue);
            } else {
                future = this.createFuture(correlation);
            }
            this.sendRequestMessage(jmsRequest, messageProducer, priority);
            if (async) {
                CompletableFuture<AbstractIntegrationMessageBuilder<?>> completableFuture = future;
                return completableFuture;
            }
            Message message = this.obtainReplyFromContainer(correlation, replyQueue);
            return message;
        }
        finally {
            JmsUtils.closeMessageProducer((MessageProducer)messageProducer);
            if (correlation != null && !this.isAsync()) {
                this.replies.remove(correlation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message doSendAndReceiveAsyncDefaultCorrelation(Destination reqDestination, Message jmsRequest, Session session, int priority) throws JMSException {
        Message message;
        String correlation = null;
        MessageProducer messageProducer = null;
        try {
            messageProducer = session.createProducer(reqDestination);
            LinkedBlockingQueue<Message> replyQueue = new LinkedBlockingQueue<Message>(1);
            this.sendRequestMessage(jmsRequest, messageProducer, priority);
            String correlationToLog = correlation = jmsRequest.getJMSMessageID();
            this.logger.debug(() -> this.getComponentName() + " Sent message with correlationId " + correlationToLog);
            this.replies.put(correlation, replyQueue);
            this.earlyOrLateRepliesMonitor.lock();
            try {
                TimedReply timedReply = this.earlyOrLateReplies.remove(correlation);
                if (timedReply != null) {
                    this.logger.debug(() -> "Found early reply with correlationId " + correlationToLog);
                    replyQueue.add(timedReply.getReply());
                }
            }
            finally {
                this.earlyOrLateRepliesMonitor.unlock();
            }
            message = this.obtainReplyFromContainer(correlation, replyQueue);
        }
        catch (Throwable throwable) {
            JmsUtils.closeMessageProducer((MessageProducer)messageProducer);
            if (correlation != null) {
                this.replies.remove(correlation);
            }
            throw throwable;
        }
        JmsUtils.closeMessageProducer((MessageProducer)messageProducer);
        if (correlation != null) {
            this.replies.remove(correlation);
        }
        return message;
    }

    private Message obtainReplyFromContainer(String correlationId, LinkedBlockingQueue<Message> replyQueue) {
        Message reply = null;
        if (this.receiveTimeout < 0L) {
            reply = replyQueue.poll();
        } else {
            try {
                reply = replyQueue.poll(this.receiveTimeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                this.logger.error((Throwable)ex, (CharSequence)"Interrupted while awaiting reply; treated as a timeout");
            }
        }
        Message replyToLog = reply;
        this.logger.debug(() -> {
            if (replyToLog == null) {
                return this.getComponentName() + " Timed out waiting for reply with CorrelationId " + correlationId;
            }
            return this.getComponentName() + " Obtained reply with CorrelationId " + correlationId;
        });
        return reply;
    }

    private CompletableFuture<AbstractIntegrationMessageBuilder<?>> createFuture(String correlationId) {
        CompletableFuture future = new CompletableFuture();
        this.futures.put(correlationId, future);
        if (this.receiveTimeout > 0L) {
            this.getTaskScheduler().schedule(() -> this.expire(correlationId), Instant.now().plusMillis(this.receiveTimeout));
        }
        return future;
    }

    private void expire(String correlationId) {
        CompletableFuture<AbstractIntegrationMessageBuilder<?>> future = this.futures.remove(correlationId);
        if (future != null) {
            try {
                if (this.getRequiresReply()) {
                    future.completeExceptionally((Throwable)((Object)new JmsTimeoutException("No reply in " + this.receiveTimeout + " ms")));
                } else {
                    this.logger.debug(() -> "Reply expired and reply not required for " + correlationId);
                }
            }
            catch (Exception ex) {
                this.logger.error((Throwable)ex, (CharSequence)"Exception while expiring future");
            }
        }
    }

    private void sendRequestMessage(Message jmsRequest, MessageProducer messageProducer, int priority) throws JMSException {
        if (this.explicitQosEnabled) {
            messageProducer.send(jmsRequest, this.deliveryMode, priority, this.timeToLive);
        } else {
            messageProducer.send(jmsRequest);
        }
    }

    private Message receiveReplyMessage(MessageConsumer messageConsumer) throws JMSException {
        return this.receiveTimeout >= 0L ? messageConsumer.receive(this.receiveTimeout) : messageConsumer.receive();
    }

    private void deleteDestinationIfTemporary(Destination destination) {
        try {
            if (destination instanceof TemporaryQueue) {
                TemporaryQueue temporaryQueue = (TemporaryQueue)destination;
                temporaryQueue.delete();
            } else if (destination instanceof TemporaryTopic) {
                TemporaryTopic temporaryTopic = (TemporaryTopic)destination;
                temporaryTopic.delete();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    protected Connection createConnection() throws JMSException {
        return this.connectionFactory.createConnection();
    }

    protected Session createSession(Connection connection) throws JMSException {
        return connection.createSession(false, 1);
    }

    public void onMessage(Message message) {
        String correlation = null;
        try {
            this.logger.trace(() -> this.getComponentName() + " Received " + String.valueOf(message));
            correlation = this.correlationKey == null || this.correlationKey.equals("JMSCorrelationID") || this.correlationKey.equals("JMSCorrelationID*") ? message.getJMSCorrelationID() : message.getStringProperty(this.correlationKey);
            Assert.state((correlation != null ? 1 : 0) != 0, (String)"Message with no correlationId received");
            if (this.isAsync()) {
                this.onMessageAsync(message, correlation);
            } else {
                this.onMessageSync(message, correlation);
            }
        }
        catch (Exception ex) {
            String correlationToLog = correlation;
            this.logger.warn((Throwable)ex, () -> "Failed to consume reply with correlationId " + correlationToLog);
        }
    }

    private void onMessageAsync(Message message, String correlationId) throws JMSException {
        CompletableFuture<AbstractIntegrationMessageBuilder<?>> future = this.futures.remove(correlationId);
        if (future != null) {
            message.setJMSCorrelationID(null);
            future.complete(this.buildReply(message));
        } else {
            this.logger.warn(() -> "Late reply for " + correlationId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMessageSync(Message message, String correlationId) {
        try {
            LinkedBlockingQueue<Message> queue = this.replies.get(correlationId);
            if (queue == null) {
                if (this.correlationKey != null) {
                    Log debugLogger = LogFactory.getLog((String)"si.jmsgateway.debug");
                    if (debugLogger.isDebugEnabled()) {
                        Object siMessage = this.messageConverter.fromMessage(message);
                        debugLogger.debug((Object)("No pending reply for " + String.valueOf(siMessage) + " with correlationId: " + correlationId + " pending replies: " + String.valueOf(this.replies.keySet())));
                    }
                    throw new IllegalStateException("No sender waiting for reply");
                }
                this.earlyOrLateRepliesMonitor.lock();
                try {
                    queue = this.replies.get(correlationId);
                    if (queue == null) {
                        this.logger.debug(() -> "Reply for correlationId " + correlationId + " received early or late");
                        this.earlyOrLateReplies.put(correlationId, new TimedReply(message));
                    }
                }
                finally {
                    this.earlyOrLateRepliesMonitor.unlock();
                }
            }
            if (queue != null) {
                this.logger.debug(() -> "Received reply with correlationId " + correlationId);
                queue.add(message);
            }
        }
        catch (Exception ex) {
            this.logger.warn((Throwable)ex, () -> "Failed to consume reply with correlationId " + correlationId);
        }
    }

    private static /* synthetic */ CharSequence lambda$retryableReceiveReply$7(JMSException ee) {
        return "Could not reconnect, retrying: " + ee.getMessage();
    }

    private static /* synthetic */ CharSequence lambda$retryableReceiveReply$6(JMSException e) {
        return "Connection lost waiting for reply, retrying: " + e.getMessage();
    }

    public static class ReplyContainerProperties {
        private Boolean sessionTransacted;
        private Integer sessionAcknowledgeMode;
        private String sessionAcknowledgeModeName;
        private Long receiveTimeout;
        private Long recoveryInterval;
        private Integer cacheLevel;
        private Integer concurrentConsumers;
        private Integer maxConcurrentConsumers;
        private Integer maxMessagesPerTask;
        private Integer idleConsumerLimit;
        private Integer idleTaskExecutionLimit;
        private Executor taskExecutor;

        public String getSessionAcknowledgeModeName() {
            return this.sessionAcknowledgeModeName;
        }

        public void setSessionAcknowledgeModeName(String sessionAcknowledgeModeName) {
            this.sessionAcknowledgeModeName = sessionAcknowledgeModeName;
        }

        public Boolean isSessionTransacted() {
            return this.sessionTransacted;
        }

        public void setSessionTransacted(Boolean sessionTransacted) {
            this.sessionTransacted = sessionTransacted;
        }

        public Integer getSessionAcknowledgeMode() {
            return this.sessionAcknowledgeMode;
        }

        public void setSessionAcknowledgeMode(Integer sessionAcknowledgeMode) {
            this.sessionAcknowledgeMode = sessionAcknowledgeMode;
        }

        public Long getReceiveTimeout() {
            return this.receiveTimeout;
        }

        public void setReceiveTimeout(Long receiveTimeout) {
            this.receiveTimeout = receiveTimeout;
        }

        public Long getRecoveryInterval() {
            return this.recoveryInterval;
        }

        public void setRecoveryInterval(Long recoveryInterval) {
            this.recoveryInterval = recoveryInterval;
        }

        public Integer getCacheLevel() {
            return this.cacheLevel;
        }

        public void setCacheLevel(Integer cacheLevel) {
            this.cacheLevel = cacheLevel;
        }

        public Integer getConcurrentConsumers() {
            return this.concurrentConsumers;
        }

        public void setConcurrentConsumers(Integer concurrentConsumers) {
            this.concurrentConsumers = concurrentConsumers;
        }

        public Integer getMaxConcurrentConsumers() {
            return this.maxConcurrentConsumers;
        }

        public void setMaxConcurrentConsumers(Integer maxConcurrentConsumers) {
            this.maxConcurrentConsumers = maxConcurrentConsumers;
        }

        public Integer getMaxMessagesPerTask() {
            return this.maxMessagesPerTask;
        }

        public void setMaxMessagesPerTask(Integer maxMessagesPerTask) {
            this.maxMessagesPerTask = maxMessagesPerTask;
        }

        public Integer getIdleConsumerLimit() {
            return this.idleConsumerLimit;
        }

        public void setIdleConsumerLimit(Integer idleConsumerLimit) {
            this.idleConsumerLimit = idleConsumerLimit;
        }

        public Integer getIdleTaskExecutionLimit() {
            return this.idleTaskExecutionLimit;
        }

        public void setIdleTaskExecutionLimit(Integer idleTaskExecutionLimit) {
            this.idleTaskExecutionLimit = idleTaskExecutionLimit;
        }

        public void setTaskExecutor(Executor taskExecutor) {
            this.taskExecutor = taskExecutor;
        }

        public Executor getTaskExecutor() {
            return this.taskExecutor;
        }
    }

    private static class GatewayReplyListenerContainer
    extends DefaultMessageListenerContainer {
        private volatile Destination replyDestination;

        GatewayReplyListenerContainer() {
        }

        protected Destination resolveDestinationName(Session session, String destinationName) throws JMSException {
            this.replyDestination = !StringUtils.hasText((String)destinationName) ? (this.isPubSubDomain() ? session.createTemporaryTopic() : session.createTemporaryQueue()) : super.resolveDestinationName(session, destinationName);
            return this.replyDestination;
        }

        protected void validateConfiguration() {
            if (this.isSubscriptionDurable() && !this.isPubSubDomain()) {
                throw new IllegalArgumentException("A durable subscription requires a topic (pub-sub domain)");
            }
            this.lifecycleLock.lock();
            try {
                if (this.isSubscriptionDurable() && this.getConcurrentConsumers() != 1) {
                    throw new IllegalArgumentException("Only 1 concurrent consumer supported for durable subscription");
                }
            }
            finally {
                this.lifecycleLock.unlock();
            }
        }

        public Destination getReplyDestination() {
            Destination replyDest = this.getDestination();
            if (replyDest == null) {
                replyDest = this.replyDestination;
            }
            if (replyDest != null) {
                return replyDest;
            }
            int n = 0;
            while (this.replyDestination == null && n++ < 100) {
                this.logger.debug((Object)"Waiting for container to create destination");
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException("Container did not establish a destination", e);
                }
            }
            if (this.replyDestination == null) {
                throw new IllegalStateException("Container did not establish a destination");
            }
            return this.replyDestination;
        }

        protected String getDestinationDescription() {
            if (this.replyDestination instanceof TemporaryQueue) {
                return "Temporary queue: " + this.replyDestination.toString();
            }
            if (super.getDestination() != null) {
                try {
                    return super.getDestinationDescription();
                }
                catch (Exception e) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn((Object)("Unexpected error obtaining destination description: " + e.getMessage()));
                    }
                    return "";
                }
            }
            return "";
        }

        protected void recoverAfterListenerSetupFailure() {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("recoverAfterListenerSetupFailure for dest: " + String.valueOf(this.replyDestination)));
            }
            this.replyDestination = null;
            super.recoverAfterListenerSetupFailure();
        }
    }

    private class LateReplyReaper
    implements Runnable {
        LateReplyReaper() {
        }

        @Override
        public void run() {
            JmsOutboundGateway.this.logger.trace((CharSequence)"Running late reply reaper");
            Iterator<Map.Entry<String, TimedReply>> lateReplyIterator = JmsOutboundGateway.this.earlyOrLateReplies.entrySet().iterator();
            long now = System.currentTimeMillis();
            long expired = now - JmsOutboundGateway.this.receiveTimeout * 2L;
            while (lateReplyIterator.hasNext()) {
                Map.Entry<String, TimedReply> entry = lateReplyIterator.next();
                if (entry.getValue().getTimeStamp() >= expired) continue;
                JmsOutboundGateway.this.logger.debug(() -> "Removing late reply for correlationId " + (String)entry.getKey());
                lateReplyIterator.remove();
            }
            if (JmsOutboundGateway.this.receiveTimeout >= 0L) {
                JmsOutboundGateway.this.reaper = JmsOutboundGateway.this.getTaskScheduler().schedule((Runnable)this, Instant.ofEpochMilli(now).plusMillis(JmsOutboundGateway.this.receiveTimeout));
            }
        }
    }

    private class IdleContainerStopper
    implements Runnable {
        IdleContainerStopper() {
        }

        @Override
        public void run() {
            JmsOutboundGateway.this.lifeCycleMonitor.lock();
            try {
                if (System.currentTimeMillis() - JmsOutboundGateway.this.lastSend > JmsOutboundGateway.this.idleReplyContainerTimeout && JmsOutboundGateway.this.replies.size() == 0 && JmsOutboundGateway.this.replyContainer.isRunning()) {
                    JmsOutboundGateway.this.logger.debug(() -> JmsOutboundGateway.this.getComponentName() + ": Stopping idle reply container.");
                    JmsOutboundGateway.this.replyContainer.stop();
                    JmsOutboundGateway.this.idleTask.cancel(false);
                    JmsOutboundGateway.this.idleTask = null;
                }
            }
            finally {
                JmsOutboundGateway.this.lifeCycleMonitor.unlock();
            }
        }
    }

    private static final class TimedReply {
        private final long timeStamp = System.currentTimeMillis();
        private final Message reply;

        TimedReply(Message reply) {
            this.reply = reply;
        }

        private long getTimeStamp() {
            return this.timeStamp;
        }

        private Message getReply() {
            return this.reply;
        }
    }
}

