/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractChannelParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.jms.config.JmsChannelFactoryBean;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class JmsChannelParser
extends AbstractChannelParser {
    private static final String CONTAINER_TYPE_ATTRIBUTE = "container-type";
    private static final String CONTAINER_CLASS_ATTRIBUTE = "container-class";
    private static final String ACKNOWLEDGE_ATTRIBUTE = "acknowledge";

    protected BeanDefinitionBuilder buildBeanDefinition(Element element, ParserContext parserContext) {
        Integer acknowledgeMode;
        String connectionFactory;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(JmsChannelFactoryBean.class);
        String messageDriven = element.getAttribute("message-driven");
        if (StringUtils.hasText((String)messageDriven)) {
            builder.addConstructorArgValue((Object)messageDriven);
        }
        if (!StringUtils.hasText((String)(connectionFactory = element.getAttribute("connection-factory")))) {
            connectionFactory = "connectionFactory";
        }
        builder.addPropertyReference("connectionFactory", connectionFactory);
        if ("channel".equals(element.getLocalName())) {
            this.parseDestination(element, parserContext, builder, "queue");
        } else if ("publish-subscribe-channel".equals(element.getLocalName())) {
            this.parseDestination(element, parserContext, builder, "topic");
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"max-subscribers");
        String containerType = element.getAttribute(CONTAINER_TYPE_ATTRIBUTE);
        String containerClass = element.getAttribute(CONTAINER_CLASS_ATTRIBUTE);
        if (!StringUtils.hasText((String)containerClass) && StringUtils.hasText((String)containerType)) {
            if ("default".equals(containerType)) {
                containerClass = "org.springframework.jms.listener.DefaultMessageListenerContainer";
            } else if ("simple".equals(containerType)) {
                containerClass = "org.springframework.jms.listener.SimpleMessageListenerContainer";
            }
        }
        if (StringUtils.hasText((String)containerClass)) {
            builder.addPropertyValue("containerType", (Object)containerClass);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"receive-timeout");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"task-executor");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"transaction-manager");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"message-converter");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"error-handler");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"selector", (String)"messageSelector");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"phase");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"auto-startup");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"delivery-persistent");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"time-to-live");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"priority");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"explicit-qos-enabled");
        String cache = element.getAttribute("cache");
        if (StringUtils.hasText((String)cache)) {
            if (containerType.startsWith("simple")) {
                if (!"auto".equals(cache) && !"consumer".equals(cache)) {
                    parserContext.getReaderContext().warning("'cache' attribute not actively supported for listener container of type \"simple\". Effective runtime behavior will be equivalent to \"consumer\" / \"auto\".", (Object)element);
                }
            } else {
                builder.addPropertyValue("cacheLevelName", (Object)("CACHE_" + cache.toUpperCase()));
            }
        }
        if ((acknowledgeMode = this.parseAcknowledgeMode(element, parserContext)) != null) {
            if (acknowledgeMode == 0) {
                builder.addPropertyValue("sessionTransacted", (Object)Boolean.TRUE);
            } else {
                builder.addPropertyValue("sessionAcknowledgeMode", (Object)acknowledgeMode);
            }
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"concurrency");
        String prefetch = element.getAttribute("prefetch");
        if (StringUtils.hasText((String)prefetch) && containerType.startsWith("default")) {
            builder.addPropertyValue("maxMessagesPerTask", (Object)new Integer(prefetch));
        }
        return builder;
    }

    private void parseDestination(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, String type) {
        boolean isName;
        boolean isPubSub = "topic".equals(type);
        String ref = element.getAttribute(type);
        String name = element.getAttribute(type + "-name");
        boolean isReference = StringUtils.hasText((String)ref);
        if (!(isReference ^ (isName = StringUtils.hasText((String)name)))) {
            parserContext.getReaderContext().error("Exactly one of the '" + type + "' or '" + type + "-name' attributes is required.", (Object)element);
        }
        if (isReference) {
            builder.addPropertyReference("destination", ref);
        } else if (isName) {
            builder.addPropertyValue("destinationName", (Object)name);
            builder.addPropertyValue("pubSubDomain", (Object)isPubSub);
            String destinationResolver = element.getAttribute("destination-resolver");
            if (StringUtils.hasText((String)destinationResolver)) {
                builder.addPropertyReference("destinationResolver", destinationResolver);
            }
        }
        if (isPubSub) {
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"durable", (String)"subscriptionDurable");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"subscription", (String)"durableSubscriptionName");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"client-id");
        }
    }

    private Integer parseAcknowledgeMode(Element ele, ParserContext parserContext) {
        String acknowledge = ele.getAttribute(ACKNOWLEDGE_ATTRIBUTE);
        if (StringUtils.hasText((String)acknowledge)) {
            int acknowledgeMode = 1;
            if ("transacted".equals(acknowledge)) {
                acknowledgeMode = 0;
            } else if ("dups-ok".equals(acknowledge)) {
                acknowledgeMode = 3;
            } else if ("client".equals(acknowledge)) {
                acknowledgeMode = 2;
            } else if (!"auto".equals(acknowledge)) {
                parserContext.getReaderContext().error("Invalid JMS Channel 'acknowledge' setting [" + acknowledge + "]: only \"auto\", \"client\", \"dups-ok\" and \"transacted\" supported.", (Object)ele);
            }
            return acknowledgeMode;
        }
        return null;
    }
}

