/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import java.util.ArrayDeque;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.jms.AbstractJmsChannel;
import org.springframework.integration.jms.DynamicJmsTemplateProperties;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.PollableChannel;

public class PollableJmsChannel
extends AbstractJmsChannel
implements PollableChannel {
    private volatile String messageSelector;

    public PollableJmsChannel(JmsTemplate jmsTemplate) {
        super(jmsTemplate);
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public Message<?> receive() {
        AbstractMessageChannel.ChannelInterceptorList interceptorList = this.getInterceptors();
        ArrayDeque interceptorStack = null;
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("preReceive on channel '" + (Object)((Object)this) + "'"));
            }
            if (interceptorList.getInterceptors().size() > 0 && !interceptorList.preReceive((MessageChannel)this, interceptorStack = new ArrayDeque())) {
                return null;
            }
            Object object = this.messageSelector == null ? this.getJmsTemplate().receiveAndConvert() : this.getJmsTemplate().receiveSelectedAndConvert(this.messageSelector);
            if (object == null) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("postReceive on channel '" + (Object)((Object)this) + "', message is null"));
                }
                return null;
            }
            Message message = null;
            message = object instanceof Message ? (Message)object : this.getMessageBuilderFactory().withPayload(object).build();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("postReceive on channel '" + (Object)((Object)this) + "', message: " + message));
            }
            if (interceptorStack != null) {
                message = interceptorList.postReceive(message, (MessageChannel)this);
                interceptorList.afterReceiveCompletion(message, (MessageChannel)this, null, interceptorStack);
            }
            return message;
        }
        catch (RuntimeException e) {
            if (interceptorStack != null) {
                interceptorList.afterReceiveCompletion(null, (MessageChannel)this, (Exception)e, interceptorStack);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message<?> receive(long timeout) {
        try {
            DynamicJmsTemplateProperties.setReceiveTimeout(timeout);
            Message<?> message = this.receive();
            return message;
        }
        finally {
            DynamicJmsTemplateProperties.clearReceiveTimeout();
        }
    }
}

