/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import org.springframework.expression.Expression;
import org.springframework.integration.IntegrationMessageHeaderAccessor;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.handler.ExpressionEvaluatingMessageProcessor;
import org.springframework.integration.jms.DefaultJmsHeaderMapper;
import org.springframework.integration.jms.DynamicJmsTemplateProperties;
import org.springframework.integration.jms.JmsHeaderMapper;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessagePostProcessor;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.util.Assert;

public class JmsSendingMessageHandler
extends AbstractMessageHandler {
    private final JmsTemplate jmsTemplate;
    private volatile Destination destination;
    private volatile String destinationName;
    private volatile JmsHeaderMapper headerMapper = new DefaultJmsHeaderMapper();
    private volatile boolean extractPayload = true;
    private volatile ExpressionEvaluatingMessageProcessor<?> destinationExpressionProcessor;

    public JmsSendingMessageHandler(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public void setDestination(Destination destination) {
        Assert.isTrue((this.destinationName == null && this.destinationExpressionProcessor == null ? 1 : 0) != 0, (String)"The 'destination', 'destinationName', and 'destinationExpression' properties are mutually exclusive.");
        this.destination = destination;
    }

    public void setDestinationName(String destinationName) {
        Assert.isTrue((this.destination == null && this.destinationExpressionProcessor == null ? 1 : 0) != 0, (String)"The 'destination', 'destinationName', and 'destinationExpression' properties are mutually exclusive.");
        this.destinationName = destinationName;
    }

    public void setDestinationExpression(Expression destinationExpression) {
        Assert.isTrue((this.destination == null && this.destinationName == null ? 1 : 0) != 0, (String)"The 'destination', 'destinationName', and 'destinationExpression' properties are mutually exclusive.");
        this.destinationExpressionProcessor = new ExpressionEvaluatingMessageProcessor(destinationExpression);
    }

    public void setHeaderMapper(JmsHeaderMapper headerMapper) {
        this.headerMapper = headerMapper;
    }

    public void setExtractPayload(boolean extractPayload) {
        this.extractPayload = extractPayload;
    }

    public String getComponentType() {
        return "jms:outbound-channel-adapter";
    }

    protected void onInit() {
        if (this.destinationExpressionProcessor != null) {
            this.destinationExpressionProcessor.setBeanFactory(this.getBeanFactory());
            this.destinationExpressionProcessor.setConversionService(this.getConversionService());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMessageInternal(Message<?> message) throws Exception {
        if (message == null) {
            throw new IllegalArgumentException("message must not be null");
        }
        Object destination = this.determineDestination(message);
        Object objectToSend = this.extractPayload ? message.getPayload() : message;
        HeaderMappingMessagePostProcessor messagePostProcessor = new HeaderMappingMessagePostProcessor(message, this.headerMapper);
        try {
            DynamicJmsTemplateProperties.setPriority(new IntegrationMessageHeaderAccessor(message).getPriority());
            this.send(destination, objectToSend, messagePostProcessor);
        }
        finally {
            DynamicJmsTemplateProperties.clearPriority();
        }
    }

    private Object determineDestination(Message<?> message) {
        if (this.destination != null) {
            return this.destination;
        }
        if (this.destinationName != null) {
            return this.destinationName;
        }
        if (this.destinationExpressionProcessor != null) {
            Object result = this.destinationExpressionProcessor.processMessage(message);
            if (!(result instanceof Destination) && !(result instanceof String)) {
                throw new MessageDeliveryException(message, "Evaluation of destinationExpression failed to produce a Destination or destination name. Result was: " + result);
            }
            return result;
        }
        return null;
    }

    private void send(Object destination, Object objectToSend, MessagePostProcessor messagePostProcessor) {
        if (destination instanceof Destination) {
            this.jmsTemplate.convertAndSend((Destination)destination, objectToSend, messagePostProcessor);
        } else if (destination instanceof String) {
            this.jmsTemplate.convertAndSend((String)destination, objectToSend, messagePostProcessor);
        } else {
            this.jmsTemplate.convertAndSend(objectToSend, messagePostProcessor);
        }
    }

    private static class HeaderMappingMessagePostProcessor
    implements MessagePostProcessor {
        private final Message<?> integrationMessage;
        private final JmsHeaderMapper headerMapper;

        private HeaderMappingMessagePostProcessor(Message<?> integrationMessage, JmsHeaderMapper headerMapper) {
            this.integrationMessage = integrationMessage;
            this.headerMapper = headerMapper;
        }

        public javax.jms.Message postProcessMessage(javax.jms.Message jmsMessage) throws JMSException {
            this.headerMapper.fromHeaders(this.integrationMessage.getHeaders(), jmsMessage);
            return jmsMessage;
        }
    }
}

