/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.SmartLifecycle;
import org.springframework.expression.Expression;
import org.springframework.integration.IntegrationMessageHeaderAccessor;
import org.springframework.integration.MessageTimeoutException;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.handler.ExpressionEvaluatingMessageProcessor;
import org.springframework.integration.jms.DefaultJmsHeaderMapper;
import org.springframework.integration.jms.JmsHeaderMapper;
import org.springframework.jms.connection.ConnectionFactoryUtils;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.SimpleMessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.jms.support.destination.DynamicDestinationResolver;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class JmsOutboundGateway
extends AbstractReplyProducingMessageHandler
implements SmartLifecycle,
MessageListener {
    private volatile Destination requestDestination;
    private volatile String requestDestinationName;
    private volatile ExpressionEvaluatingMessageProcessor<?> requestDestinationExpressionProcessor;
    private volatile Destination replyDestination;
    private volatile String replyDestinationName;
    private volatile ExpressionEvaluatingMessageProcessor<?> replyDestinationExpressionProcessor;
    private volatile DestinationResolver destinationResolver = new DynamicDestinationResolver();
    private volatile boolean requestPubSubDomain;
    private volatile boolean replyPubSubDomain;
    private volatile long receiveTimeout = 5000L;
    private volatile int deliveryMode = 2;
    private volatile long timeToLive = 0L;
    private volatile int priority = 4;
    private volatile boolean explicitQosEnabled;
    private ConnectionFactory connectionFactory;
    private volatile MessageConverter messageConverter = new SimpleMessageConverter();
    private volatile JmsHeaderMapper headerMapper = new DefaultJmsHeaderMapper();
    private volatile String correlationKey;
    private volatile boolean extractRequestPayload = true;
    private volatile boolean extractReplyPayload = true;
    private volatile boolean initialized;
    private volatile GatewayReplyListenerContainer replyContainer;
    private volatile ReplyContainerProperties replyContainerProperties;
    private volatile boolean useReplyContainer;
    private final Object initializationMonitor = new Object();
    private volatile boolean autoStartup;
    private volatile boolean active;
    private final AtomicLong correlationId = new AtomicLong();
    private final String gatewayCorrelation = UUID.randomUUID().toString();
    private final Map<String, LinkedBlockingQueue<Message>> replies = new ConcurrentHashMap<String, LinkedBlockingQueue<Message>>();
    private final ConcurrentHashMap<String, TimedReply> earlyOrLateReplies = new ConcurrentHashMap();
    private volatile ScheduledFuture<?> reaper;
    private final Object lifeCycleMonitor = new Object();
    private volatile boolean requiresReply;

    public void setDeliveryPersistent(boolean deliveryPersistent) {
        this.deliveryMode = deliveryPersistent ? 2 : 1;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setRequestDestination(Destination requestDestination) {
        if (requestDestination instanceof Topic) {
            this.requestPubSubDomain = true;
        }
        this.requestDestination = requestDestination;
    }

    public void setRequestDestinationName(String requestDestinationName) {
        this.requestDestinationName = requestDestinationName;
    }

    public void setRequestDestinationExpression(Expression requestDestinationExpression) {
        Assert.notNull((Object)requestDestinationExpression, (String)"'requestDestinationExpression' must not be null");
        this.requestDestinationExpressionProcessor = new ExpressionEvaluatingMessageProcessor(requestDestinationExpression);
    }

    public void setReplyDestination(Destination replyDestination) {
        if (replyDestination instanceof Topic) {
            this.replyPubSubDomain = true;
        }
        this.replyDestination = replyDestination;
    }

    public void setReplyDestinationName(String replyDestinationName) {
        this.replyDestinationName = replyDestinationName;
    }

    public void setReplyDestinationExpression(Expression replyDestinationExpression) {
        Assert.notNull((Object)replyDestinationExpression, (String)"'replyDestinationExpression' must not be null");
        this.replyDestinationExpressionProcessor = new ExpressionEvaluatingMessageProcessor(replyDestinationExpression);
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        this.destinationResolver = destinationResolver;
    }

    public void setRequestPubSubDomain(boolean requestPubSubDomain) {
        this.requestPubSubDomain = requestPubSubDomain;
    }

    public void setReplyPubSubDomain(boolean replyPubSubDomain) {
        this.replyPubSubDomain = replyPubSubDomain;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public void setExplicitQosEnabled(boolean explicitQosEnabled) {
        this.explicitQosEnabled = explicitQosEnabled;
    }

    public void setCorrelationKey(String correlationKey) {
        this.correlationKey = correlationKey;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"'messageConverter' must not be null");
        this.messageConverter = messageConverter;
    }

    public void setHeaderMapper(JmsHeaderMapper headerMapper) {
        this.headerMapper = headerMapper;
    }

    public void setExtractRequestPayload(boolean extractRequestPayload) {
        this.extractRequestPayload = extractRequestPayload;
    }

    public void setExtractReplyPayload(boolean extractReplyPayload) {
        this.extractReplyPayload = extractReplyPayload;
    }

    public void setReplyChannel(MessageChannel replyChannel) {
        this.setOutputChannel(replyChannel);
    }

    public void setReplyContainerProperties(ReplyContainerProperties replyContainerProperties) {
        this.replyContainerProperties = replyContainerProperties;
        this.useReplyContainer = true;
    }

    public String getComponentType() {
        return "jms:outbound-gateway";
    }

    public void setUseReplyContainer(boolean useReplyContainer) {
        this.useReplyContainer = useReplyContainer;
    }

    public void setRequiresReply(boolean requiresReply) {
        super.setRequiresReply(requiresReply);
        this.requiresReply = requiresReply;
    }

    private Destination determineRequestDestination(org.springframework.messaging.Message<?> message, Session session) throws JMSException {
        if (this.requestDestination != null) {
            return this.requestDestination;
        }
        if (this.requestDestinationName != null) {
            return this.resolveRequestDestination(this.requestDestinationName, session);
        }
        if (this.requestDestinationExpressionProcessor != null) {
            Object result = this.requestDestinationExpressionProcessor.processMessage(message);
            if (result instanceof Destination) {
                return (Destination)result;
            }
            if (result instanceof String) {
                return this.resolveRequestDestination((String)result, session);
            }
            throw new MessageDeliveryException(message, "Evaluation of requestDestinationExpression failed to produce a Destination or destination name. Result was: " + result);
        }
        throw new MessageDeliveryException(message, "No requestDestination, requestDestinationName, or requestDestinationExpression has been configured.");
    }

    private Destination resolveRequestDestination(String requestDestinationName, Session session) throws JMSException {
        Assert.notNull((Object)this.destinationResolver, (String)"DestinationResolver is required when relying upon the 'requestDestinationName' property.");
        return this.destinationResolver.resolveDestinationName(session, requestDestinationName, this.requestPubSubDomain);
    }

    private Destination determineReplyDestination(org.springframework.messaging.Message<?> message, Session session) throws JMSException {
        if (this.replyDestination != null) {
            return this.replyDestination;
        }
        if (this.replyDestinationName != null) {
            return this.resolveReplyDestination(this.replyDestinationName, session);
        }
        if (this.replyDestinationExpressionProcessor != null) {
            Object result = this.replyDestinationExpressionProcessor.processMessage(message);
            if (result instanceof Destination) {
                return (Destination)result;
            }
            if (result instanceof String) {
                return this.resolveReplyDestination((String)result, session);
            }
            throw new MessageDeliveryException(message, "Evaluation of replyDestinationExpression failed to produce a Destination or destination name. Result was: " + result);
        }
        return session.createTemporaryQueue();
    }

    private Destination resolveReplyDestination(String replyDestinationName, Session session) throws JMSException {
        Assert.notNull((Object)this.destinationResolver, (String)"DestinationResolver is required when relying upon the 'replyDestinationName' property.");
        return this.destinationResolver.resolveDestinationName(session, replyDestinationName, this.replyPubSubDomain);
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInit() {
        Object object = this.initializationMonitor;
        synchronized (object) {
            if (this.initialized) {
                return;
            }
            Assert.notNull((Object)this.connectionFactory, (String)"connectionFactory must not be null");
            Assert.isTrue((boolean)(this.requestDestination != null ^ this.requestDestinationName != null ^ this.requestDestinationExpressionProcessor != null), (String)"Exactly one of 'requestDestination', 'requestDestinationName', or 'requestDestinationExpression' is required.");
            if (this.requestDestinationExpressionProcessor != null) {
                this.requestDestinationExpressionProcessor.setBeanFactory(this.getBeanFactory());
                this.requestDestinationExpressionProcessor.setConversionService(this.getConversionService());
            }
            if (this.replyDestinationExpressionProcessor != null) {
                this.replyDestinationExpressionProcessor.setBeanFactory(this.getBeanFactory());
                this.replyDestinationExpressionProcessor.setConversionService(this.getConversionService());
            }
            if (this.useReplyContainer && (this.correlationKey == null && (this.replyDestination != null || this.replyDestinationName != null) || this.replyDestinationExpressionProcessor != null)) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)"The gateway cannot use a reply listener container with a specified destination(Name/Expression) without a 'correlation-key'; a container will NOT be used; to avoid this problem, set the 'correlation-key' attribute; some consumers, including the Spring Integration <jms:inbound-gateway/>, support the use of the value 'JMSCorrelationID' for this purpose. Alternatively, do not specify a reply destination and a temporary queue will be used for replies.");
                }
                this.useReplyContainer = false;
            }
            if (this.useReplyContainer) {
                Assert.state((!"JMSCorrelationID*".equals(this.correlationKey) ? 1 : 0) != 0, (String)"Using an existing 'JMSCorrelationID' mapped from the 'requestMessage' ('JMSCorrelationID*') can't be used when using a 'reply-container'");
                GatewayReplyListenerContainer container = new GatewayReplyListenerContainer();
                this.setContainerProperties(container);
                container.afterPropertiesSet();
                this.replyContainer = container;
            }
            this.initialized = true;
        }
    }

    private void setContainerProperties(GatewayReplyListenerContainer container) {
        container.setConnectionFactory(this.connectionFactory);
        if (this.replyDestination != null) {
            container.setDestination(this.replyDestination);
        }
        if (StringUtils.hasText((String)this.replyDestinationName)) {
            container.setDestinationName(this.replyDestinationName);
        }
        if (this.destinationResolver != null) {
            container.setDestinationResolver(this.destinationResolver);
        }
        container.setPubSubDomain(this.replyPubSubDomain);
        if (this.correlationKey != null) {
            String messageSelector = this.correlationKey + " LIKE '" + this.gatewayCorrelation + "%'";
            container.setMessageSelector(messageSelector);
        }
        container.setMessageListener((Object)this);
        if (this.replyContainerProperties != null) {
            if (this.replyContainerProperties.isSessionTransacted() != null) {
                container.setSessionTransacted(this.replyContainerProperties.isSessionTransacted());
            }
            if (this.replyContainerProperties.getCacheLevel() != null) {
                container.setCacheLevel(this.replyContainerProperties.getCacheLevel());
            }
            if (this.replyContainerProperties.getConcurrentConsumers() != null) {
                container.setConcurrentConsumers(this.replyContainerProperties.getConcurrentConsumers());
            }
            if (this.replyContainerProperties.getIdleConsumerLimit() != null) {
                container.setIdleConsumerLimit(this.replyContainerProperties.getIdleConsumerLimit());
            }
            if (this.replyContainerProperties.getIdleTaskExecutionLimit() != null) {
                container.setIdleTaskExecutionLimit(this.replyContainerProperties.getIdleTaskExecutionLimit());
            }
            if (this.replyContainerProperties.getMaxConcurrentConsumers() != null) {
                container.setMaxConcurrentConsumers(this.replyContainerProperties.getMaxConcurrentConsumers());
            }
            if (this.replyContainerProperties.getMaxMessagesPerTask() != null) {
                container.setMaxMessagesPerTask(this.replyContainerProperties.getMaxMessagesPerTask());
            }
            if (this.replyContainerProperties.getReceiveTimeout() != null) {
                container.setReceiveTimeout(this.replyContainerProperties.getReceiveTimeout());
            }
            if (this.replyContainerProperties.getRecoveryInterval() != null) {
                container.setRecoveryInterval(this.replyContainerProperties.getRecoveryInterval());
            }
            if (this.replyContainerProperties.getSessionAcknowledgeMode() != null) {
                container.setSessionAcknowledgeMode(this.replyContainerProperties.getSessionAcknowledgeMode());
            }
            if (this.replyContainerProperties.getTaskExecutor() != null) {
                container.setTaskExecutor(this.replyContainerProperties.getTaskExecutor());
            } else {
                String containerBeanName = this.getComponentName();
                containerBeanName = (!StringUtils.hasText((String)containerBeanName) ? "JMS_OutboundGateway@" + ObjectUtils.getIdentityHexString((Object)((Object)this)) : containerBeanName) + ".replyListener";
                container.setBeanName(containerBeanName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lifeCycleMonitor;
        synchronized (object) {
            if (!this.active) {
                if (this.replyContainer != null) {
                    this.replyContainer.start();
                    if (this.receiveTimeout >= 0L) {
                        this.reaper = this.getTaskScheduler().schedule((Runnable)new LateReplyReaper(), new Date());
                    }
                }
                this.active = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifeCycleMonitor;
        synchronized (object) {
            if (this.replyContainer != null) {
                this.replyContainer.stop();
                this.deleteDestinationIfTemporary(this.replyContainer.getDestination());
                this.reaper.cancel(false);
            }
            this.active = false;
        }
    }

    public boolean isRunning() {
        return this.active;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    protected Object handleRequestMessage(org.springframework.messaging.Message<?> message) {
        if (!this.initialized) {
            this.afterPropertiesSet();
        }
        org.springframework.messaging.Message requestMessage = this.getMessageBuilderFactory().fromMessage(message).build();
        try {
            Message jmsReply = this.replyContainer == null ? this.sendAndReceiveWithoutContainer(requestMessage) : this.sendAndReceiveWithContainer(requestMessage);
            if (jmsReply == null) {
                if (this.requiresReply) {
                    throw new MessageTimeoutException(message, "failed to receive JMS response within timeout of: " + this.receiveTimeout + "ms");
                }
                return null;
            }
            Object result = jmsReply;
            if (this.extractReplyPayload) {
                result = this.messageConverter.fromMessage(jmsReply);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("converted JMS Message [" + jmsReply + "] to integration Message payload [" + result + "]"));
                }
            }
            Map jmsReplyHeaders = this.headerMapper.toHeaders(jmsReply);
            if (this.replyContainer != null && this.correlationKey != null) {
                jmsReplyHeaders.remove(this.correlationKey);
            }
            org.springframework.messaging.Message replyMessage = null;
            replyMessage = result instanceof org.springframework.messaging.Message ? this.getMessageBuilderFactory().fromMessage((org.springframework.messaging.Message)result).copyHeaders(jmsReplyHeaders).build() : this.getMessageBuilderFactory().withPayload(result).copyHeaders(jmsReplyHeaders).build();
            return replyMessage;
        }
        catch (JMSException e) {
            throw new MessageHandlingException(requestMessage, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message sendAndReceiveWithContainer(org.springframework.messaging.Message<?> requestMessage) throws JMSException {
        Connection connection = this.createConnection();
        Session session = null;
        Destination replyTo = this.replyContainer.getReplyDestination();
        try {
            session = this.createSession(connection);
            Object objectToSend = requestMessage;
            if (this.extractRequestPayload) {
                objectToSend = requestMessage.getPayload();
            }
            Message jmsRequest = this.messageConverter.toMessage(objectToSend, session);
            this.headerMapper.fromHeaders(requestMessage.getHeaders(), jmsRequest);
            jmsRequest.setJMSReplyTo(replyTo);
            connection.start();
            Integer priority = new IntegrationMessageHeaderAccessor(requestMessage).getPriority();
            if (priority == null) {
                priority = this.priority;
            }
            Destination requestDestination = this.determineRequestDestination(requestMessage, session);
            Message reply = null;
            if (this.correlationKey == null) {
                jmsRequest.setJMSCorrelationID(null);
                reply = this.doSendAndReceiveAsyncDefaultCorrelation(requestDestination, jmsRequest, session, priority);
            } else {
                reply = this.doSendAndReceiveAsync(requestDestination, jmsRequest, session, priority);
            }
            if (reply != null) {
                reply.setJMSCorrelationID(null);
            }
            Message message = reply;
            return message;
        }
        finally {
            JmsUtils.closeSession((Session)session);
            ConnectionFactoryUtils.releaseConnection((Connection)connection, (ConnectionFactory)this.connectionFactory, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message sendAndReceiveWithoutContainer(org.springframework.messaging.Message<?> requestMessage) throws JMSException {
        Message message;
        Connection connection = this.createConnection();
        Session session = null;
        Destination replyTo = null;
        try {
            session = this.createSession(connection);
            Object objectToSend = requestMessage;
            if (this.extractRequestPayload) {
                objectToSend = requestMessage.getPayload();
            }
            Message jmsRequest = this.messageConverter.toMessage(objectToSend, session);
            this.headerMapper.fromHeaders(requestMessage.getHeaders(), jmsRequest);
            replyTo = this.determineReplyDestination(requestMessage, session);
            jmsRequest.setJMSReplyTo(replyTo);
            connection.start();
            Integer priority = new IntegrationMessageHeaderAccessor(requestMessage).getPriority();
            if (priority == null) {
                priority = this.priority;
            }
            Message replyMessage = null;
            Destination requestDestination = this.determineRequestDestination(requestMessage, session);
            replyMessage = this.correlationKey != null ? this.doSendAndReceiveWithGeneratedCorrelationId(requestDestination, jmsRequest, replyTo, session, priority) : (replyTo instanceof TemporaryQueue || replyTo instanceof TemporaryTopic ? this.doSendAndReceiveWithTemporaryReplyToDestination(requestDestination, jmsRequest, replyTo, session, priority) : this.doSendAndReceiveWithMessageIdCorrelation(requestDestination, jmsRequest, replyTo, session, priority));
            message = replyMessage;
        }
        catch (Throwable throwable) {
            JmsUtils.closeSession((Session)session);
            this.deleteDestinationIfTemporary(replyTo);
            ConnectionFactoryUtils.releaseConnection((Connection)connection, (ConnectionFactory)this.connectionFactory, (boolean)true);
            throw throwable;
        }
        JmsUtils.closeSession((Session)session);
        this.deleteDestinationIfTemporary(replyTo);
        ConnectionFactoryUtils.releaseConnection((Connection)connection, (ConnectionFactory)this.connectionFactory, (boolean)true);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message doSendAndReceiveWithGeneratedCorrelationId(Destination requestDestination, Message jmsRequest, Destination replyTo, Session session, int priority) throws JMSException {
        Message message;
        MessageProducer messageProducer = null;
        MessageConsumer messageConsumer = null;
        try {
            messageProducer = session.createProducer(requestDestination);
            Assert.state((this.correlationKey != null ? 1 : 0) != 0, (String)"correlationKey must not be null");
            String messageSelector = null;
            if (!this.correlationKey.equals("JMSCorrelationID*") || jmsRequest.getJMSCorrelationID() == null) {
                String correlationId = UUID.randomUUID().toString().replaceAll("'", "''");
                if (this.correlationKey.equals("JMSCorrelationID")) {
                    jmsRequest.setJMSCorrelationID(correlationId);
                    messageSelector = "JMSCorrelationID = '" + correlationId + "'";
                } else {
                    jmsRequest.setStringProperty(this.correlationKey, correlationId);
                    jmsRequest.setJMSCorrelationID(null);
                    messageSelector = this.correlationKey + " = '" + correlationId + "'";
                }
            } else {
                messageSelector = "JMSCorrelationID = '" + jmsRequest.getJMSCorrelationID() + "'";
            }
            messageConsumer = session.createConsumer(replyTo, messageSelector);
            this.sendRequestMessage(jmsRequest, messageProducer, priority);
            message = this.receiveReplyMessage(messageConsumer);
        }
        catch (Throwable throwable) {
            JmsUtils.closeMessageProducer((MessageProducer)messageProducer);
            JmsUtils.closeMessageConsumer(messageConsumer);
            throw throwable;
        }
        JmsUtils.closeMessageProducer((MessageProducer)messageProducer);
        JmsUtils.closeMessageConsumer((MessageConsumer)messageConsumer);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message doSendAndReceiveWithTemporaryReplyToDestination(Destination requestDestination, Message jmsRequest, Destination replyTo, Session session, int priority) throws JMSException {
        Message message;
        MessageProducer messageProducer = null;
        MessageConsumer messageConsumer = null;
        try {
            messageProducer = session.createProducer(requestDestination);
            messageConsumer = session.createConsumer(replyTo);
            this.sendRequestMessage(jmsRequest, messageProducer, priority);
            message = this.receiveReplyMessage(messageConsumer);
        }
        catch (Throwable throwable) {
            JmsUtils.closeMessageProducer((MessageProducer)messageProducer);
            JmsUtils.closeMessageConsumer(messageConsumer);
            throw throwable;
        }
        JmsUtils.closeMessageProducer((MessageProducer)messageProducer);
        JmsUtils.closeMessageConsumer((MessageConsumer)messageConsumer);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message doSendAndReceiveWithMessageIdCorrelation(Destination requestDestination, Message jmsRequest, Destination replyTo, Session session, int priority) throws JMSException {
        Message message;
        if (replyTo instanceof Topic && this.logger.isWarnEnabled()) {
            this.logger.warn((Object)"Relying on the MessageID for correlation is not recommended when using a Topic as the replyTo Destination because that ID can only be provided to a MessageSelector after the request Message has been sent thereby creating a race condition where a fast response might be sent before the MessageConsumer has been created. Consider providing a value to the 'correlationKey' property of this gateway instead. Then the MessageConsumer will be created before the request Message is sent.");
        }
        MessageProducer messageProducer = null;
        MessageConsumer messageConsumer = null;
        try {
            messageProducer = session.createProducer(requestDestination);
            this.sendRequestMessage(jmsRequest, messageProducer, priority);
            String messageId = jmsRequest.getJMSMessageID().replaceAll("'", "''");
            String messageSelector = "JMSCorrelationID = '" + messageId + "'";
            messageConsumer = session.createConsumer(replyTo, messageSelector);
            message = this.receiveReplyMessage(messageConsumer);
        }
        catch (Throwable throwable) {
            JmsUtils.closeMessageProducer((MessageProducer)messageProducer);
            JmsUtils.closeMessageConsumer(messageConsumer);
            throw throwable;
        }
        JmsUtils.closeMessageProducer((MessageProducer)messageProducer);
        JmsUtils.closeMessageConsumer((MessageConsumer)messageConsumer);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message doSendAndReceiveAsync(Destination requestDestination, Message jmsRequest, Session session, int priority) throws JMSException {
        Message message;
        String correlationId = null;
        MessageProducer messageProducer = null;
        try {
            messageProducer = session.createProducer(requestDestination);
            correlationId = this.gatewayCorrelation + "_" + Long.toString(this.correlationId.incrementAndGet());
            if (this.correlationKey.equals("JMSCorrelationID")) {
                jmsRequest.setJMSCorrelationID(correlationId);
            } else {
                jmsRequest.setStringProperty(this.correlationKey, correlationId);
                jmsRequest.setJMSCorrelationID(null);
            }
            LinkedBlockingQueue<Message> replyQueue = new LinkedBlockingQueue<Message>(1);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(this.getComponentName() + " Sending message with correlationId " + correlationId));
            }
            this.replies.put(correlationId, replyQueue);
            this.sendRequestMessage(jmsRequest, messageProducer, priority);
            message = this.obtainReplyFromContainer(correlationId, replyQueue);
        }
        catch (Throwable throwable) {
            JmsUtils.closeMessageProducer((MessageProducer)messageProducer);
            this.replies.remove(correlationId);
            throw throwable;
        }
        JmsUtils.closeMessageProducer((MessageProducer)messageProducer);
        this.replies.remove(correlationId);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message doSendAndReceiveAsyncDefaultCorrelation(Destination requestDestination, Message jmsRequest, Session session, int priority) throws JMSException {
        Message message;
        String correlationId = null;
        MessageProducer messageProducer = null;
        try {
            messageProducer = session.createProducer(requestDestination);
            LinkedBlockingQueue<Message> replyQueue = new LinkedBlockingQueue<Message>(1);
            this.sendRequestMessage(jmsRequest, messageProducer, priority);
            correlationId = jmsRequest.getJMSMessageID();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(this.getComponentName() + " Sent message with correlationId " + correlationId));
            }
            this.replies.put(correlationId, replyQueue);
            message = this.earlyOrLateReplies;
            synchronized (message) {
                TimedReply timedReply = this.earlyOrLateReplies.remove(correlationId);
                if (timedReply != null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Found early reply with correlationId " + correlationId));
                    }
                    replyQueue.add(timedReply.getReply());
                }
            }
            message = this.obtainReplyFromContainer(correlationId, replyQueue);
        }
        catch (Throwable throwable) {
            JmsUtils.closeMessageProducer((MessageProducer)messageProducer);
            this.replies.remove(correlationId);
            throw throwable;
        }
        JmsUtils.closeMessageProducer((MessageProducer)messageProducer);
        this.replies.remove(correlationId);
        return message;
    }

    private Message obtainReplyFromContainer(String correlationId, LinkedBlockingQueue<Message> replyQueue) {
        Message reply = null;
        if (this.receiveTimeout < 0L) {
            reply = replyQueue.poll();
        } else {
            try {
                reply = replyQueue.poll(this.receiveTimeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                this.logger.error((Object)"Interrupted while awaiting reply; treated as a timeout", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        if (this.logger.isDebugEnabled()) {
            if (reply == null) {
                this.logger.debug((Object)(this.getComponentName() + " Timed out waiting for reply with CorrelationId " + correlationId));
            } else {
                this.logger.debug((Object)(this.getComponentName() + " Obtained reply with CorrelationId " + correlationId));
            }
        }
        return reply;
    }

    private void sendRequestMessage(Message jmsRequest, MessageProducer messageProducer, int priority) throws JMSException {
        if (this.explicitQosEnabled) {
            messageProducer.send(jmsRequest, this.deliveryMode, priority, this.timeToLive);
        } else {
            messageProducer.send(jmsRequest);
        }
    }

    private Message receiveReplyMessage(MessageConsumer messageConsumer) throws JMSException {
        return this.receiveTimeout >= 0L ? messageConsumer.receive(this.receiveTimeout) : messageConsumer.receive();
    }

    private void deleteDestinationIfTemporary(Destination destination) {
        try {
            if (destination instanceof TemporaryQueue) {
                ((TemporaryQueue)destination).delete();
            } else if (destination instanceof TemporaryTopic) {
                ((TemporaryTopic)destination).delete();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    protected Connection createConnection() throws JMSException {
        return this.connectionFactory.createConnection();
    }

    protected Session createSession(Connection connection) throws JMSException {
        return connection.createSession(false, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        block13: {
            String correlationId = null;
            try {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)(this.getComponentName() + " Received " + message));
                }
                correlationId = this.correlationKey == null || this.correlationKey.equals("JMSCorrelationID") || this.correlationKey.equals("JMSCorrelationID*") ? message.getJMSCorrelationID() : message.getStringProperty(this.correlationKey);
                Assert.state((correlationId != null ? 1 : 0) != 0, (String)"Message with no correlationId received");
                LinkedBlockingQueue<Message> queue = this.replies.get(correlationId);
                if (queue == null) {
                    if (this.correlationKey != null) {
                        Log debugLogger = LogFactory.getLog((String)"si.jmsgateway.debug");
                        if (debugLogger.isDebugEnabled()) {
                            Object siMessage = this.messageConverter.fromMessage(message);
                            debugLogger.debug((Object)("No pending reply for " + siMessage + " with correlationId: " + correlationId + " pending replies: " + this.replies.keySet()));
                        }
                        throw new RuntimeException("No sender waiting for reply");
                    }
                    ConcurrentHashMap<String, TimedReply> concurrentHashMap = this.earlyOrLateReplies;
                    synchronized (concurrentHashMap) {
                        queue = this.replies.get(correlationId);
                        if (queue == null) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)("Reply for correlationId " + correlationId + " received early or late"));
                            }
                            this.earlyOrLateReplies.put(correlationId, new TimedReply(message));
                        }
                    }
                }
                if (queue != null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Received reply with correlationId " + correlationId));
                    }
                    queue.add(message);
                }
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled()) break block13;
                this.logger.warn((Object)("Failed to consume reply with correlationId " + correlationId), (Throwable)e);
            }
        }
    }

    public static class ReplyContainerProperties {
        private volatile Boolean sessionTransacted;
        private volatile Integer sessionAcknowledgeMode;
        private volatile Long receiveTimeout;
        private volatile Long recoveryInterval;
        private volatile Integer cacheLevel;
        private volatile Integer concurrentConsumers;
        private volatile Integer maxConcurrentConsumers;
        private volatile Integer maxMessagesPerTask;
        private volatile Integer idleConsumerLimit;
        private volatile Integer idleTaskExecutionLimit;
        private volatile Executor taskExecutor;

        public Boolean isSessionTransacted() {
            return this.sessionTransacted;
        }

        public void setSessionTransacted(Boolean sessionTransacted) {
            this.sessionTransacted = sessionTransacted;
        }

        public Integer getSessionAcknowledgeMode() {
            return this.sessionAcknowledgeMode;
        }

        public void setSessionAcknowledgeMode(Integer sessionAcknowledgeMode) {
            this.sessionAcknowledgeMode = sessionAcknowledgeMode;
        }

        public Long getReceiveTimeout() {
            return this.receiveTimeout;
        }

        public void setReceiveTimeout(Long receiveTimeout) {
            this.receiveTimeout = receiveTimeout;
        }

        public Long getRecoveryInterval() {
            return this.recoveryInterval;
        }

        public void setRecoveryInterval(Long recoveryInterval) {
            this.recoveryInterval = recoveryInterval;
        }

        public Integer getCacheLevel() {
            return this.cacheLevel;
        }

        public void setCacheLevel(Integer cacheLevel) {
            this.cacheLevel = cacheLevel;
        }

        public Integer getConcurrentConsumers() {
            return this.concurrentConsumers;
        }

        public void setConcurrentConsumers(Integer concurrentConsumers) {
            this.concurrentConsumers = concurrentConsumers;
        }

        public Integer getMaxConcurrentConsumers() {
            return this.maxConcurrentConsumers;
        }

        public void setMaxConcurrentConsumers(Integer maxConcurrentConsumers) {
            this.maxConcurrentConsumers = maxConcurrentConsumers;
        }

        public Integer getMaxMessagesPerTask() {
            return this.maxMessagesPerTask;
        }

        public void setMaxMessagesPerTask(Integer maxMessagesPerTask) {
            this.maxMessagesPerTask = maxMessagesPerTask;
        }

        public Integer getIdleConsumerLimit() {
            return this.idleConsumerLimit;
        }

        public void setIdleConsumerLimit(Integer idleConsumerLimit) {
            this.idleConsumerLimit = idleConsumerLimit;
        }

        public Integer getIdleTaskExecutionLimit() {
            return this.idleTaskExecutionLimit;
        }

        public void setIdleTaskExecutionLimit(Integer idleTaskExecutionLimit) {
            this.idleTaskExecutionLimit = idleTaskExecutionLimit;
        }

        public void setTaskExecutor(Executor taskExecutor) {
            this.taskExecutor = taskExecutor;
        }

        public Executor getTaskExecutor() {
            return this.taskExecutor;
        }
    }

    private class LateReplyReaper
    implements Runnable {
        private LateReplyReaper() {
        }

        @Override
        public void run() {
            if (JmsOutboundGateway.this.logger.isTraceEnabled()) {
                JmsOutboundGateway.this.logger.trace((Object)"Running late reply reaper");
            }
            Iterator lateReplyIterator = JmsOutboundGateway.this.earlyOrLateReplies.entrySet().iterator();
            long now = System.currentTimeMillis();
            long expired = now - JmsOutboundGateway.this.receiveTimeout * 2L;
            while (lateReplyIterator.hasNext()) {
                Map.Entry entry = lateReplyIterator.next();
                if (((TimedReply)entry.getValue()).getTimeStamp() >= expired) continue;
                if (JmsOutboundGateway.this.logger.isDebugEnabled()) {
                    JmsOutboundGateway.this.logger.debug((Object)("Removing late reply for correlationId " + (String)entry.getKey()));
                }
                lateReplyIterator.remove();
            }
            if (JmsOutboundGateway.this.receiveTimeout >= 0L) {
                JmsOutboundGateway.this.reaper = JmsOutboundGateway.this.getTaskScheduler().schedule((Runnable)this, new Date(now + JmsOutboundGateway.this.receiveTimeout));
            }
        }
    }

    private class TimedReply {
        private final long timeStamp = System.currentTimeMillis();
        private final Message reply;

        public TimedReply(Message reply) {
            this.reply = reply;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public Message getReply() {
            return this.reply;
        }
    }

    private class GatewayReplyListenerContainer
    extends DefaultMessageListenerContainer {
        private volatile Destination replyDestination;

        private GatewayReplyListenerContainer() {
        }

        protected Destination resolveDestinationName(Session session, String destinationName) throws JMSException {
            this.replyDestination = !StringUtils.hasText((String)destinationName) ? session.createTemporaryQueue() : super.resolveDestinationName(session, destinationName);
            return this.replyDestination;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void validateConfiguration() {
            if (this.isSubscriptionDurable() && !this.isPubSubDomain()) {
                throw new IllegalArgumentException("A durable subscription requires a topic (pub-sub domain)");
            }
            Object object = this.lifecycleMonitor;
            synchronized (object) {
                if (this.isSubscriptionDurable() && this.getConcurrentConsumers() != 1) {
                    throw new IllegalArgumentException("Only 1 concurrent consumer supported for durable subscription");
                }
            }
        }

        public Destination getReplyDestination() {
            Destination replyDest = this.getDestination();
            if (replyDest == null) {
                replyDest = this.replyDestination;
            }
            if (replyDest != null) {
                return replyDest;
            }
            int n = 0;
            while (this.replyDestination == null && n++ < 10) {
                this.logger.debug((Object)"Waiting for container to create destination");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException("Container did not establish a destination");
                }
            }
            if (this.replyDestination == null) {
                throw new IllegalStateException("Container did not establish a destination");
            }
            return this.replyDestination;
        }

        protected String getDestinationDescription() {
            if (this.replyDestination instanceof TemporaryQueue) {
                return "Temporary queue:" + this.replyDestination.toString();
            }
            if (super.getDestination() != null) {
                try {
                    return super.getDestinationDescription();
                }
                catch (Exception e) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn((Object)("Unexpected error obtaining destination description: " + e.getMessage()));
                    }
                    return null;
                }
            }
            return null;
        }

        protected void recoverAfterListenerSetupFailure() {
            this.replyDestination = null;
            super.recoverAfterListenerSetupFailure();
        }
    }
}

