/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms.config;

import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractOutboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.jms.config.JmsAdapterParserUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class JmsOutboundChannelAdapterParser
extends AbstractOutboundChannelAdapterParser {
    protected AbstractBeanDefinition parseConsumer(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.jms.JmsSendingMessageHandler");
        String jmsTemplate = element.getAttribute("jms-template");
        String destination = element.getAttribute("destination");
        String destinationName = element.getAttribute("destination-name");
        String headerMapper = element.getAttribute("header-mapper");
        if (StringUtils.hasText((String)jmsTemplate)) {
            if (element.hasAttribute("connection-factory") || element.hasAttribute("destination") || element.hasAttribute("destination-name")) {
                throw new BeanCreationException("When providing a 'jms-template' reference, none of 'connection-factory', 'destination', or 'destination-name' should be provided.");
            }
            builder.addPropertyReference("jmsTemplate", jmsTemplate);
        } else if (StringUtils.hasText((String)destination) ^ StringUtils.hasText((String)destinationName)) {
            builder.addPropertyReference("connectionFactory", JmsAdapterParserUtils.determineConnectionFactoryBeanName(element, parserContext));
            if (StringUtils.hasText((String)destination)) {
                builder.addPropertyReference("destination", destination);
            } else {
                builder.addPropertyValue("destinationName", (Object)destinationName);
            }
        } else {
            throw new BeanCreationException("Either a 'jms-template' reference or one of 'destination' or 'destination-name' must be provided.");
        }
        if (StringUtils.hasText((String)headerMapper)) {
            builder.addPropertyReference("headerMapper", headerMapper);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"extract-payload");
        return builder.getBeanDefinition();
    }
}

