/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc.store;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.integration.jdbc.store.channel.MessageRowMapper;
import org.springframework.integration.store.AbstractMessageGroupStore;
import org.springframework.integration.store.MessageGroup;
import org.springframework.integration.store.MessageGroupMetadata;
import org.springframework.integration.store.MessageGroupStore;
import org.springframework.integration.store.MessageMetadata;
import org.springframework.integration.store.MessageStore;
import org.springframework.integration.store.SimpleMessageGroup;
import org.springframework.integration.support.converter.AllowListDeserializingConverter;
import org.springframework.integration.util.FunctionIterator;
import org.springframework.integration.util.UUIDConverter;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JdbcMessageStore
extends AbstractMessageGroupStore
implements MessageStore,
BeanClassLoaderAware,
SmartLifecycle {
    public static final String DEFAULT_TABLE_PREFIX = "INT_";
    private final JdbcOperations jdbcTemplate;
    private final Map<Query, String> queryCache = new ConcurrentHashMap<Query, String>();
    private final AtomicBoolean started = new AtomicBoolean();
    private String region = "DEFAULT";
    private String tablePrefix = "INT_";
    private AllowListDeserializingConverter deserializer = new AllowListDeserializingConverter(JdbcMessageStore.class.getClassLoader());
    private boolean deserializerExplicitlySet;
    private MessageRowMapper mapper = new MessageRowMapper(this.deserializer);
    private SerializingConverter serializer;
    private boolean checkDatabaseOnStart = true;

    public JdbcMessageStore(DataSource dataSource) {
        this((JdbcOperations)new JdbcTemplate(dataSource));
    }

    public JdbcMessageStore(JdbcOperations jdbcOperations) {
        Assert.notNull((Object)jdbcOperations, (String)"'dataSource' must not be null");
        this.jdbcTemplate = jdbcOperations;
        this.serializer = new SerializingConverter();
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        if (!this.deserializerExplicitlySet) {
            this.deserializer = new AllowListDeserializingConverter(classLoader);
        }
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public void setRegion(String region) {
        Assert.hasText((String)region, (String)"Region must not be null or empty.");
        this.region = region;
    }

    public void setSerializer(Serializer<? super Message<?>> serializer) {
        this.serializer = new SerializingConverter(serializer);
    }

    public void setDeserializer(Deserializer<? extends Message<?>> deserializer) {
        this.deserializer = new AllowListDeserializingConverter(deserializer);
        this.deserializerExplicitlySet = true;
        this.mapper = new MessageRowMapper(this.deserializer);
    }

    public void addAllowedPatterns(String ... patterns) {
        this.deserializer.addAllowedPatterns(patterns);
    }

    public void setCheckDatabaseOnStart(boolean checkDatabaseOnStart) {
        this.checkDatabaseOnStart = checkDatabaseOnStart;
        if (!checkDatabaseOnStart) {
            this.logger.info((Object)"The 'JdbcMessageStore' won't be started automatically and required table is not going be checked.");
        }
    }

    public boolean isAutoStartup() {
        return this.checkDatabaseOnStart;
    }

    public void start() {
        if (this.started.compareAndSet(false, true) && this.checkDatabaseOnStart) {
            this.getMessageGroupCount();
        }
    }

    public void stop() {
        this.started.set(false);
    }

    public boolean isRunning() {
        return this.started.get();
    }

    public @Nullable Message<?> removeMessage(UUID id) {
        Message<?> message = this.getMessage(id);
        if (message == null) {
            return null;
        }
        String key = this.getKey(id);
        int updated = this.jdbcTemplate.update(this.getQuery(Query.DELETE_MESSAGE), new Object[]{key, this.region, key, this.region});
        if (updated != 0) {
            return message;
        }
        return null;
    }

    @ManagedAttribute
    public long getMessageCount() {
        Long result = (Long)this.jdbcTemplate.queryForObject(this.getQuery(Query.GET_MESSAGE_COUNT), Long.class, new Object[]{this.region});
        return Objects.requireNonNull(result);
    }

    public @Nullable Message<?> getMessage(UUID id) {
        List list = this.jdbcTemplate.query(this.getQuery(Query.GET_MESSAGE), (RowMapper)this.mapper, new Object[]{this.getKey(id), this.region});
        if (list.isEmpty()) {
            return null;
        }
        return (Message)list.get(0);
    }

    public @Nullable MessageMetadata getMessageMetadata(UUID id) {
        List list = this.jdbcTemplate.query(this.getQuery(Query.GET_MESSAGE), (rs, rn) -> {
            MessageMetadata messageMetadata = new MessageMetadata(UUID.fromString(rs.getString("MESSAGE_ID")));
            messageMetadata.setTimestamp(rs.getTimestamp("CREATED_DATE").getTime());
            return messageMetadata;
        }, new Object[]{this.getKey(id), this.region});
        if (list.isEmpty()) {
            return null;
        }
        return (MessageMetadata)list.get(0);
    }

    public <T> Message<T> addMessage(Message<T> message) {
        UUID id = message.getHeaders().getId();
        Assert.notNull((Object)id, (String)"Cannot store messages without an ID header");
        String messageId = this.getKey(id);
        byte[] messageBytes = this.serializer.convert(message);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Inserting message with id key=" + messageId));
        }
        try {
            this.jdbcTemplate.update(this.getQuery(Query.CREATE_MESSAGE), ps -> {
                ps.setString(1, messageId);
                ps.setString(2, this.region);
                ps.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                ps.setBytes(4, messageBytes);
            });
        }
        catch (DataIntegrityViolationException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("The Message with id [" + String.valueOf(id) + "] already exists.\nIgnoring INSERT and SELECT existing..."));
            }
            return Objects.requireNonNull(this.getMessage(id));
        }
        return message;
    }

    protected void doAddMessagesToGroup(Object groupId, Message<?> ... messages) {
        String groupKey = this.getKey(groupId);
        MessageGroupMetadata groupMetadata = this.getGroupMetadata(groupKey);
        Timestamp createdDate = groupMetadata == null ? new Timestamp(System.currentTimeMillis()) : new Timestamp(groupMetadata.getTimestamp());
        for (Message<?> message : messages) {
            this.addMessage(message);
        }
        this.jdbcTemplate.batchUpdate(this.getQuery(Query.CREATE_GROUP_TO_MESSAGE), Arrays.asList(messages), 100, (ps, messageToAdd) -> {
            Objects.requireNonNull(messageToAdd);
            String messageId = this.getKey(Objects.requireNonNull(messageToAdd.getHeaders().getId()));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Inserting message with id key=" + messageId + " and created date=" + String.valueOf(createdDate)));
            }
            ps.setString(1, groupKey);
            ps.setString(2, messageId);
            ps.setString(3, this.region);
        });
        if (groupMetadata == null) {
            try {
                this.doCreateMessageGroup(groupKey, createdDate);
            }
            catch (DataIntegrityViolationException ex) {
                this.logger.warn((Object)"Lost race to create group; attempting update instead", (Throwable)ex);
                this.updateMessageGroup(groupKey);
            }
        } else {
            this.updateMessageGroup(groupKey);
        }
    }

    @ManagedAttribute
    public int getMessageGroupCount() {
        Integer result = (Integer)this.jdbcTemplate.queryForObject(this.getQuery(Query.COUNT_ALL_GROUPS), Integer.class, new Object[]{this.region});
        return Objects.requireNonNull(result);
    }

    @ManagedAttribute
    public int getMessageCountForAllMessageGroups() {
        Integer result = (Integer)this.jdbcTemplate.queryForObject(this.getQuery(Query.COUNT_ALL_MESSAGES_IN_GROUPS), Integer.class, new Object[]{this.region});
        return Objects.requireNonNull(result);
    }

    @ManagedAttribute
    public int messageGroupSize(Object groupId) {
        String key = this.getKey(groupId);
        Integer result = (Integer)this.jdbcTemplate.queryForObject(this.getQuery(Query.COUNT_ALL_MESSAGES_IN_GROUP), Integer.class, new Object[]{key, this.region});
        return Objects.requireNonNull(result);
    }

    public MessageGroup getMessageGroup(Object groupId) {
        MessageGroupMetadata groupMetadata = this.getGroupMetadata(groupId);
        if (groupMetadata != null) {
            MessageGroup messageGroup = this.getMessageGroupFactory().create((MessageGroupStore)this, groupId, groupMetadata.getTimestamp(), groupMetadata.isComplete());
            messageGroup.setLastModified(groupMetadata.getLastModified());
            messageGroup.setLastReleasedMessageSequenceNumber(groupMetadata.getLastReleasedMessageSequenceNumber());
            messageGroup.setCondition(groupMetadata.getCondition());
            return messageGroup;
        }
        return new SimpleMessageGroup(groupId);
    }

    public @Nullable MessageGroupMetadata getGroupMetadata(Object groupId) {
        String key = this.getKey(groupId);
        try {
            return (MessageGroupMetadata)this.jdbcTemplate.queryForObject(this.getQuery(Query.GET_GROUP_INFO), (rs, rowNum) -> {
                MessageGroupMetadata groupMetadata = new MessageGroupMetadata();
                if (rs.getInt("COMPLETE") > 0) {
                    groupMetadata.complete();
                }
                groupMetadata.setTimestamp(rs.getTimestamp("CREATED_DATE").getTime());
                groupMetadata.setLastModified(rs.getTimestamp("UPDATED_DATE").getTime());
                groupMetadata.setLastReleasedMessageSequenceNumber(rs.getInt("LAST_RELEASED_SEQUENCE"));
                groupMetadata.setCondition(rs.getString("GROUP_CONDITION"));
                return groupMetadata;
            }, new Object[]{key, this.region});
        }
        catch (IncorrectResultSizeDataAccessException ex) {
            return null;
        }
    }

    protected void doRemoveMessagesFromGroup(Object groupId, Collection<Message<?>> messages) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        Assert.notNull(messages, (String)"'messages' must not be null");
        String groupKey = this.getKey(groupId);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Removing messages from group with group key=" + groupKey));
        }
        this.jdbcTemplate.batchUpdate(this.getQuery(Query.REMOVE_MESSAGE_FROM_GROUP), messages, this.getRemoveBatchSize(), (ps, messageToRemove) -> {
            Objects.requireNonNull(messageToRemove);
            ps.setString(1, groupKey);
            ps.setString(2, this.getKey(Objects.requireNonNull(messageToRemove.getHeaders().getId())));
            ps.setString(3, this.region);
        });
        this.jdbcTemplate.batchUpdate(this.getQuery(Query.DELETE_MESSAGE), messages, this.getRemoveBatchSize(), (ps, messageToRemove) -> {
            Objects.requireNonNull(messageToRemove);
            String key = this.getKey(Objects.requireNonNull(messageToRemove.getHeaders().getId()));
            ps.setString(1, key);
            ps.setString(2, this.region);
            ps.setString(3, key);
            ps.setString(4, this.region);
        });
        this.updateMessageGroup(groupKey);
    }

    public @Nullable Message<?> getMessageFromGroup(Object groupId, UUID messageId) {
        List list = this.jdbcTemplate.query(this.getQuery(Query.GET_MESSAGE_FROM_GROUP), (RowMapper)this.mapper, new Object[]{this.getKey(messageId), this.getKey(groupId), this.region});
        if (list.isEmpty()) {
            return null;
        }
        return (Message)list.get(0);
    }

    protected boolean doRemoveMessageFromGroupById(Object groupId, UUID messageId) {
        String groupKey = this.getKey(groupId);
        String messageKey = this.getKey(messageId);
        int messageToGroupRemoved = this.jdbcTemplate.update(this.getQuery(Query.REMOVE_MESSAGE_FROM_GROUP), new Object[]{groupKey, messageKey, this.region});
        if (messageToGroupRemoved > 0) {
            return this.jdbcTemplate.update(this.getQuery(Query.DELETE_MESSAGE), new Object[]{messageKey, this.region, messageKey, this.region}) > 0;
        }
        return false;
    }

    protected void doRemoveMessageGroup(Object groupId) {
        String groupKey = this.getKey(groupId);
        this.jdbcTemplate.update(this.getQuery(Query.DELETE_MESSAGES_FROM_GROUP), new Object[]{groupKey, this.region, groupKey, this.region, this.region});
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Removing relationships for the group with group key=" + groupKey));
        }
        this.jdbcTemplate.update(this.getQuery(Query.REMOVE_GROUP_TO_MESSAGE_JOIN), new Object[]{groupKey, this.region});
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Deleting messages with group key=" + groupKey));
        }
        this.jdbcTemplate.update(this.getQuery(Query.DELETE_MESSAGE_GROUP), new Object[]{groupKey, this.region});
    }

    protected void doCompleteGroup(Object groupId) {
        String groupKey = this.getKey(groupId);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Completing MessageGroup: " + groupKey));
        }
        this.jdbcTemplate.update(this.getQuery(Query.COMPLETE_GROUP), new Object[]{new Timestamp(System.currentTimeMillis()), groupKey, this.region});
    }

    protected void doSetGroupCondition(Object groupId, String condition) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        String groupKey = this.getKey(groupId);
        Timestamp updatedDate = new Timestamp(System.currentTimeMillis());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Updating message group with id key=" + groupKey + " and updated date=" + String.valueOf(updatedDate)));
        }
        this.jdbcTemplate.update(this.getQuery(Query.UPDATE_MESSAGE_GROUP), new Object[]{updatedDate, condition, groupKey, this.region});
    }

    protected void doSetLastReleasedSequenceNumberForGroup(Object groupId, int sequenceNumber) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        String groupKey = this.getKey(groupId);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Updating  the sequence number of the last released Message in the MessageGroup: " + groupKey));
        }
        this.jdbcTemplate.update(this.getQuery(Query.UPDATE_LAST_RELEASED_SEQUENCE), new Object[]{new Timestamp(System.currentTimeMillis()), sequenceNumber, groupKey, this.region});
    }

    protected @Nullable Message<?> doPollMessageFromGroup(Object groupId) {
        String key = this.getKey(groupId);
        Message<?> polledMessage = this.doPollForMessage(key);
        if (polledMessage != null) {
            this.removeMessagesFromGroup(groupId, new Message[]{polledMessage});
        }
        return polledMessage;
    }

    public @Nullable Message<?> getOneMessageFromGroup(Object groupId) {
        String key = this.getKey(groupId);
        return this.doPollForMessage(key);
    }

    public Collection<Message<?>> getMessagesForGroup(Object groupId) {
        return this.jdbcTemplate.query(this.getQuery(Query.LIST_MESSAGES_BY_GROUP_KEY), (RowMapper)this.mapper, new Object[]{this.getKey(groupId), this.region, this.region});
    }

    public Stream<Message<?>> streamMessagesForGroup(Object groupId) {
        return this.jdbcTemplate.queryForStream(this.getQuery(Query.LIST_MESSAGES_BY_GROUP_KEY), (RowMapper)this.mapper, new Object[]{this.getKey(groupId), this.region, this.region});
    }

    public Iterator<MessageGroup> iterator() {
        List groupIds = this.jdbcTemplate.query(this.getQuery(Query.LIST_GROUP_KEYS), (RowMapper)new SingleColumnRowMapper(), new Object[]{this.region});
        return new FunctionIterator((Iterable)groupIds, this::getMessageGroup);
    }

    protected String getQuery(Query base) {
        return this.queryCache.computeIfAbsent(base, query -> StringUtils.replace((String)query.getSql(), (String)"%PREFIX%", (String)this.tablePrefix));
    }

    protected JdbcOperations getJdbcOperations() {
        return this.jdbcTemplate;
    }

    protected @Nullable Message<?> doPollForMessage(String groupIdKey) {
        List messages = this.jdbcTemplate.query(this.getQuery(Query.POLL_FROM_GROUP), (RowMapper)this.mapper, new Object[]{groupIdKey, this.region, groupIdKey, this.region});
        Assert.state((messages.size() < 2 ? 1 : 0) != 0, () -> "The query must return zero or 1 row; got " + messages.size() + " rows");
        if (!messages.isEmpty()) {
            return (Message)messages.get(0);
        }
        return null;
    }

    private void doCreateMessageGroup(String groupKey, Timestamp createdDate) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating message group with id key=" + groupKey + " and created date=" + String.valueOf(createdDate)));
        }
        this.jdbcTemplate.update(this.getQuery(Query.CREATE_MESSAGE_GROUP), new Object[]{groupKey, this.region, createdDate, createdDate});
    }

    private void updateMessageGroup(String groupId) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Updating MessageGroup: " + groupId));
        }
        this.jdbcTemplate.update(this.getQuery(Query.UPDATE_GROUP), new Object[]{new Timestamp(System.currentTimeMillis()), groupId, this.region});
    }

    private String getKey(Object input) {
        return UUIDConverter.getUUID((Object)input).toString();
    }

    private static enum Query {
        CREATE_MESSAGE_GROUP("INSERT into %PREFIX%MESSAGE_GROUP(\n\tGROUP_KEY, REGION, COMPLETE, LAST_RELEASED_SEQUENCE, CREATED_DATE, UPDATED_DATE)\nvalues (?, ?, 0, 0, ?, ?)\n"),
        UPDATE_MESSAGE_GROUP("UPDATE %PREFIX%MESSAGE_GROUP\nset UPDATED_DATE=?, GROUP_CONDITION=?\nwhere GROUP_KEY=? and REGION=?\n"),
        REMOVE_MESSAGE_FROM_GROUP("DELETE from %PREFIX%GROUP_TO_MESSAGE\nwhere GROUP_KEY=? and MESSAGE_ID=? and REGION=?\n"),
        REMOVE_GROUP_TO_MESSAGE_JOIN("DELETE from %PREFIX%GROUP_TO_MESSAGE\nwhere GROUP_KEY=? and REGION=?\n"),
        COUNT_ALL_MESSAGES_IN_GROUPS("SELECT COUNT(MESSAGE_ID)\nfrom %PREFIX%GROUP_TO_MESSAGE\nwhere REGION=?\n"),
        COUNT_ALL_MESSAGES_IN_GROUP("SELECT COUNT(MESSAGE_ID)\nfrom %PREFIX%GROUP_TO_MESSAGE\nwhere GROUP_KEY=? and REGION=?\n"),
        LIST_MESSAGES_BY_GROUP_KEY("SELECT MESSAGE_ID, MESSAGE_CONTENT, CREATED_DATE\nfrom %PREFIX%MESSAGE\nwhere MESSAGE_ID in (SELECT MESSAGE_ID from %PREFIX%GROUP_TO_MESSAGE where GROUP_KEY = ? and REGION = ?)\n\tand REGION = ?\nORDER BY CREATED_DATE\n"),
        POLL_FROM_GROUP("SELECT %PREFIX%MESSAGE.MESSAGE_ID, %PREFIX%MESSAGE.MESSAGE_CONTENT\nfrom %PREFIX%MESSAGE\nwhere %PREFIX%MESSAGE.MESSAGE_ID = (\n\t\tSELECT min(m.MESSAGE_ID)\n\t\tfrom %PREFIX%MESSAGE m\n\t\tjoin %PREFIX%GROUP_TO_MESSAGE\n\t\ton m.MESSAGE_ID = %PREFIX%GROUP_TO_MESSAGE.MESSAGE_ID\n\t\twhere CREATED_DATE = (\n\t\t\t\tSELECT min(CREATED_DATE)\n\t\t\t\tfrom %PREFIX%MESSAGE, %PREFIX%GROUP_TO_MESSAGE\n\t\t\t\twhere %PREFIX%MESSAGE.MESSAGE_ID = %PREFIX%GROUP_TO_MESSAGE.MESSAGE_ID\n\t\t\t\tand %PREFIX%GROUP_TO_MESSAGE.GROUP_KEY = ? and %PREFIX%MESSAGE.REGION = ?)\n\t\tand %PREFIX%GROUP_TO_MESSAGE.GROUP_KEY = ? and m.REGION = ?)\n"),
        GET_GROUP_INFO("SELECT COMPLETE, LAST_RELEASED_SEQUENCE, CREATED_DATE, UPDATED_DATE, GROUP_CONDITION\nfrom %PREFIX%MESSAGE_GROUP\nwhere GROUP_KEY=? and REGION=?\n"),
        GET_MESSAGE("SELECT MESSAGE_ID, CREATED_DATE, MESSAGE_CONTENT\nfrom %PREFIX%MESSAGE\nwhere MESSAGE_ID=? and REGION=?\n"),
        GET_MESSAGE_FROM_GROUP("SELECT m.MESSAGE_ID, m.CREATED_DATE, m.MESSAGE_CONTENT\nfrom %PREFIX%MESSAGE m\ninner join %PREFIX%GROUP_TO_MESSAGE gm\n\ton m.MESSAGE_ID = gm.MESSAGE_ID\nwhere gm.MESSAGE_ID=? and gm.GROUP_KEY = ? and gm.REGION=?\n"),
        GET_MESSAGE_COUNT("SELECT COUNT(MESSAGE_ID)\nfrom %PREFIX%MESSAGE\nwhere REGION=?\n"),
        DELETE_MESSAGE("DELETE from %PREFIX%MESSAGE\nwhere MESSAGE_ID=? and REGION=?\n\tand MESSAGE_ID not in (\n\t\t\t\t\t\tSELECT MESSAGE_ID from %PREFIX%GROUP_TO_MESSAGE\n\t\t\t\t\t\t\t\t\twhere MESSAGE_ID=? and REGION = ?)\n"),
        CREATE_MESSAGE("INSERT into %PREFIX%MESSAGE(MESSAGE_ID, REGION, CREATED_DATE, MESSAGE_CONTENT)\nvalues (?, ?, ?, ?)\n"),
        COUNT_ALL_GROUPS("SELECT COUNT(GROUP_KEY)\nfrom %PREFIX%MESSAGE_GROUP\nwhere REGION=?\n"),
        COMPLETE_GROUP("UPDATE %PREFIX%MESSAGE_GROUP\nset UPDATED_DATE=?, COMPLETE=1\nwhere GROUP_KEY=? and REGION=?\n"),
        UPDATE_LAST_RELEASED_SEQUENCE("UPDATE %PREFIX%MESSAGE_GROUP\nset UPDATED_DATE=?, LAST_RELEASED_SEQUENCE=?\nwhere GROUP_KEY=? and REGION=?\n"),
        DELETE_MESSAGES_FROM_GROUP("DELETE from %PREFIX%MESSAGE\nwhere MESSAGE_ID in (\n\t\t\t\tSELECT MESSAGE_ID from %PREFIX%GROUP_TO_MESSAGE where GROUP_KEY = ? and REGION = ?\n\t\t\t\t\t\t\t\tand MESSAGE_ID not in (\n\t\t\t\t\t\t\t\t\t\t\t\tSELECT MESSAGE_ID from %PREFIX%GROUP_TO_MESSAGE\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\twhere GROUP_KEY != ? and REGION = ?)\n\t\t\t\t)\n\tand REGION = ?\n"),
        DELETE_MESSAGE_GROUP("DELETE from %PREFIX%MESSAGE_GROUP\nwhere GROUP_KEY=? and REGION=?\n"),
        CREATE_GROUP_TO_MESSAGE("INSERT into %PREFIX%GROUP_TO_MESSAGE (GROUP_KEY, MESSAGE_ID, REGION)\nvalues (?, ?, ?)\n"),
        UPDATE_GROUP("UPDATE %PREFIX%MESSAGE_GROUP\nset UPDATED_DATE=?\nwhere GROUP_KEY=? and REGION=?\n"),
        LIST_GROUP_KEYS("SELECT distinct GROUP_KEY as CREATED\nfrom %PREFIX%MESSAGE_GROUP\nwhere REGION=?\n");

        private final String sql;

        private Query(String sql) {
            this.sql = sql;
        }

        public String getSql() {
            return this.sql;
        }
    }
}

