/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.jpa;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.integration.dsl.core.ComponentsRegistration;
import org.springframework.integration.dsl.core.MessageHandlerSpec;
import org.springframework.integration.jpa.core.JpaExecutor;
import org.springframework.integration.jpa.outbound.JpaOutboundGateway;
import org.springframework.integration.jpa.outbound.JpaOutboundGatewayFactoryBean;
import org.springframework.integration.jpa.support.JpaParameter;
import org.springframework.integration.jpa.support.parametersource.ParameterSourceFactory;

public abstract class JpaBaseOutboundEndpointSpec<S extends JpaBaseOutboundEndpointSpec<S>>
extends MessageHandlerSpec<S, JpaOutboundGateway>
implements ComponentsRegistration {
    protected JpaOutboundGatewayFactoryBean jpaOutboundGatewayFactoryBean = new JpaOutboundGatewayFactoryBean();
    private final List<JpaParameter> jpaParameters = new LinkedList<JpaParameter>();
    protected final JpaExecutor jpaExecutor;

    protected JpaBaseOutboundEndpointSpec(JpaExecutor jpaExecutor) {
        this.jpaExecutor = jpaExecutor;
        this.jpaOutboundGatewayFactoryBean.setJpaExecutor(this.jpaExecutor);
    }

    public S entityClass(Class<?> entityClass) {
        this.jpaExecutor.setEntityClass(entityClass);
        return (S)((JpaBaseOutboundEndpointSpec)this._this());
    }

    public S jpaQuery(String jpaQuery) {
        this.jpaExecutor.setJpaQuery(jpaQuery);
        return (S)((JpaBaseOutboundEndpointSpec)this._this());
    }

    public S nativeQuery(String nativeQuery) {
        this.jpaExecutor.setNativeQuery(nativeQuery);
        return (S)((JpaBaseOutboundEndpointSpec)this._this());
    }

    public S namedQuery(String namedQuery) {
        this.jpaExecutor.setNamedQuery(namedQuery);
        return (S)((JpaBaseOutboundEndpointSpec)this._this());
    }

    public S parameterSourceFactory(ParameterSourceFactory parameterSourceFactory) {
        this.jpaExecutor.setParameterSourceFactory(parameterSourceFactory);
        return (S)((JpaBaseOutboundEndpointSpec)this._this());
    }

    public S parameter(Object value) {
        return this.parameter(new JpaParameter(value, null));
    }

    public S parameter(String name, Object value) {
        return this.parameter(new JpaParameter(name, value, null));
    }

    public S parameterExpression(String expression) {
        return this.parameter(new JpaParameter(null, expression));
    }

    public S parameterExpression(String name, String expression) {
        return this.parameter(new JpaParameter(name, null, expression));
    }

    public S parameter(JpaParameter jpaParameter) {
        this.jpaParameters.add(jpaParameter);
        return (S)((JpaBaseOutboundEndpointSpec)this._this());
    }

    public S usePayloadAsParameterSource(Boolean usePayloadAsParameterSource) {
        this.jpaExecutor.setUsePayloadAsParameterSource(usePayloadAsParameterSource);
        return (S)((JpaBaseOutboundEndpointSpec)this._this());
    }

    @Override
    public Collection<Object> getComponentsToRegister() {
        return Collections.singletonList(this.jpaExecutor);
    }

    @Override
    protected JpaOutboundGateway doGet() {
        if (!this.jpaParameters.isEmpty()) {
            this.jpaExecutor.setJpaParameters(this.jpaParameters);
        }
        this.jpaOutboundGatewayFactoryBean.setBeanFactory((BeanFactory)new DefaultListableBeanFactory());
        try {
            this.jpaOutboundGatewayFactoryBean.afterPropertiesSet();
            return (JpaOutboundGateway)this.jpaOutboundGatewayFactoryBean.getObject();
        }
        catch (Exception e) {
            throw new BeanCreationException("Cannot create the JpaOutboundGateway", (Throwable)e);
        }
    }
}

