/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.jms;

import java.util.concurrent.Executor;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.springframework.integration.dsl.core.IntegrationComponentSpec;
import org.springframework.integration.dsl.core.MessageHandlerSpec;
import org.springframework.integration.dsl.support.ComponentConfigurer;
import org.springframework.integration.jms.JmsHeaderMapper;
import org.springframework.integration.jms.JmsOutboundGateway;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.util.Assert;

public class JmsOutboundGatewaySpec
extends MessageHandlerSpec<JmsOutboundGatewaySpec, JmsOutboundGateway> {
    JmsOutboundGatewaySpec(ConnectionFactory connectionFactory) {
        this.target = new JmsOutboundGateway();
        ((JmsOutboundGateway)this.target).setConnectionFactory(connectionFactory);
    }

    public JmsOutboundGatewaySpec extractRequestPayload(boolean extractPayload) {
        ((JmsOutboundGateway)this.target).setExtractRequestPayload(extractPayload);
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec extractReplyPayload(boolean extractPayload) {
        ((JmsOutboundGateway)this.target).setExtractReplyPayload(extractPayload);
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec headerMapper(JmsHeaderMapper headerMapper) {
        ((JmsOutboundGateway)this.target).setHeaderMapper(headerMapper);
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec requestDestination(Destination destination) {
        ((JmsOutboundGateway)this.target).setRequestDestination(destination);
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec requestDestination(String destination) {
        ((JmsOutboundGateway)this.target).setRequestDestinationName(destination);
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec requestDestinationExpression(String destination) {
        ((JmsOutboundGateway)this.target).setRequestDestinationExpression(PARSER.parseExpression(destination));
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec replyDestination(Destination destination) {
        ((JmsOutboundGateway)this.target).setReplyDestination(destination);
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec replyDestination(String destination) {
        ((JmsOutboundGateway)this.target).setReplyDestinationName(destination);
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec replyDestinationExpression(String destination) {
        ((JmsOutboundGateway)this.target).setReplyDestinationExpression(PARSER.parseExpression(destination));
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec destinationResolver(DestinationResolver destinationResolver) {
        ((JmsOutboundGateway)this.target).setDestinationResolver(destinationResolver);
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec jmsMessageConverter(MessageConverter messageConverter) {
        ((JmsOutboundGateway)this.target).setMessageConverter(messageConverter);
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec correlationKey(String correlationKey) {
        ((JmsOutboundGateway)this.target).setCorrelationKey(correlationKey);
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec requestPubSubDomain(boolean pubSubDomain) {
        ((JmsOutboundGateway)this.target).setRequestPubSubDomain(pubSubDomain);
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec replyPubSubDomain(boolean pubSubDomain) {
        ((JmsOutboundGateway)this.target).setReplyPubSubDomain(pubSubDomain);
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec deliveryPersistent(boolean deliveryPersistent) {
        ((JmsOutboundGateway)this.target).setDeliveryPersistent(deliveryPersistent);
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec priority(int priority) {
        ((JmsOutboundGateway)this.target).setPriority(priority);
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec timeToLive(long timeToLive) {
        ((JmsOutboundGateway)this.target).setTimeToLive(timeToLive);
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec receiveTimeout(long receiveTimeout) {
        ((JmsOutboundGateway)this.target).setReceiveTimeout(receiveTimeout);
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec explicitQosEnabled(boolean explicitQosEnabled) {
        ((JmsOutboundGateway)this.target).setExplicitQosEnabled(explicitQosEnabled);
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec replyContainer() {
        ((JmsOutboundGateway)this.target).setReplyContainerProperties(new JmsOutboundGateway.ReplyContainerProperties());
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec replyContainer(ComponentConfigurer<ReplyContainerSpec> configurer) {
        Assert.notNull(configurer);
        ReplyContainerSpec spec = new ReplyContainerSpec();
        configurer.configure(spec);
        ((JmsOutboundGateway)this.target).setReplyContainerProperties((JmsOutboundGateway.ReplyContainerProperties)spec.get());
        return (JmsOutboundGatewaySpec)this._this();
    }

    @Override
    protected JmsOutboundGateway doGet() {
        throw new UnsupportedOperationException();
    }

    public class ReplyContainerSpec
    extends IntegrationComponentSpec<ReplyContainerSpec, JmsOutboundGateway.ReplyContainerProperties> {
        ReplyContainerSpec() {
            this.target = new JmsOutboundGateway.ReplyContainerProperties();
        }

        public ReplyContainerSpec sessionTransacted(Boolean sessionTransacted) {
            ((JmsOutboundGateway.ReplyContainerProperties)this.target).setSessionTransacted(sessionTransacted);
            return (ReplyContainerSpec)this._this();
        }

        public ReplyContainerSpec sessionAcknowledgeMode(Integer sessionAcknowledgeMode) {
            ((JmsOutboundGateway.ReplyContainerProperties)this.target).setSessionAcknowledgeMode(sessionAcknowledgeMode);
            return (ReplyContainerSpec)this._this();
        }

        public ReplyContainerSpec receiveTimeout(Long receiveTimeout) {
            ((JmsOutboundGateway.ReplyContainerProperties)this.target).setReceiveTimeout(receiveTimeout);
            return (ReplyContainerSpec)this._this();
        }

        public ReplyContainerSpec recoveryInterval(Long recoveryInterval) {
            ((JmsOutboundGateway.ReplyContainerProperties)this.target).setRecoveryInterval(recoveryInterval);
            return (ReplyContainerSpec)this._this();
        }

        public ReplyContainerSpec cacheLevel(Integer cacheLevel) {
            ((JmsOutboundGateway.ReplyContainerProperties)this.target).setCacheLevel(cacheLevel);
            return (ReplyContainerSpec)this._this();
        }

        public ReplyContainerSpec concurrentConsumers(Integer concurrentConsumers) {
            ((JmsOutboundGateway.ReplyContainerProperties)this.target).setConcurrentConsumers(concurrentConsumers);
            return (ReplyContainerSpec)this._this();
        }

        public ReplyContainerSpec maxConcurrentConsumers(Integer maxConcurrentConsumers) {
            ((JmsOutboundGateway.ReplyContainerProperties)this.target).setMaxConcurrentConsumers(maxConcurrentConsumers);
            return (ReplyContainerSpec)this._this();
        }

        public ReplyContainerSpec maxMessagesPerTask(Integer maxMessagesPerTask) {
            ((JmsOutboundGateway.ReplyContainerProperties)this.target).setMaxMessagesPerTask(maxMessagesPerTask);
            return (ReplyContainerSpec)this._this();
        }

        public ReplyContainerSpec idleConsumerLimit(Integer idleConsumerLimit) {
            ((JmsOutboundGateway.ReplyContainerProperties)this.target).setIdleConsumerLimit(idleConsumerLimit);
            return (ReplyContainerSpec)this._this();
        }

        public ReplyContainerSpec idleTaskExecutionLimit(Integer idleTaskExecutionLimit) {
            ((JmsOutboundGateway.ReplyContainerProperties)this.target).setIdleTaskExecutionLimit(idleTaskExecutionLimit);
            return (ReplyContainerSpec)this._this();
        }

        public ReplyContainerSpec taskExecutor(Executor taskExecutor) {
            ((JmsOutboundGateway.ReplyContainerProperties)this.target).setTaskExecutor(taskExecutor);
            return (ReplyContainerSpec)this._this();
        }

        @Override
        protected JmsOutboundGateway.ReplyContainerProperties doGet() {
            throw new UnsupportedOperationException();
        }
    }
}

