/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.file;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.springframework.integration.dsl.core.ComponentsRegistration;
import org.springframework.integration.dsl.core.MessageSourceSpec;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.synchronizer.AbstractInboundFileSynchronizer;
import org.springframework.integration.file.remote.synchronizer.AbstractInboundFileSynchronizingMessageSource;
import org.springframework.util.Assert;

public abstract class RemoteInboundChannelAdapterSpec<F, S extends RemoteInboundChannelAdapterSpec<F, S, MS>, MS extends AbstractInboundFileSynchronizingMessageSource<F>>
extends MessageSourceSpec<S, MS>
implements ComponentsRegistration {
    protected final AbstractInboundFileSynchronizer<F> synchronizer;
    private FileListFilter<F> filter;

    protected RemoteInboundChannelAdapterSpec(AbstractInboundFileSynchronizer<F> synchronizer) {
        this.synchronizer = synchronizer;
    }

    public S autoCreateLocalDirectory(boolean autoCreateLocalDirectory) {
        ((AbstractInboundFileSynchronizingMessageSource)this.target).setAutoCreateLocalDirectory(autoCreateLocalDirectory);
        return (S)((RemoteInboundChannelAdapterSpec)this._this());
    }

    public S localDirectory(File localDirectory) {
        ((AbstractInboundFileSynchronizingMessageSource)this.target).setLocalDirectory(localDirectory);
        return (S)((RemoteInboundChannelAdapterSpec)this._this());
    }

    public S localFilter(FileListFilter<File> localFileListFilter) {
        ((AbstractInboundFileSynchronizingMessageSource)this.target).setLocalFilter(localFileListFilter);
        return (S)((RemoteInboundChannelAdapterSpec)this._this());
    }

    public S remoteFileSeparator(String remoteFileSeparator) {
        this.synchronizer.setRemoteFileSeparator(remoteFileSeparator);
        return (S)((RemoteInboundChannelAdapterSpec)this._this());
    }

    public S localFilenameGeneratorExpression(String localFilenameGeneratorExpression) {
        this.synchronizer.setLocalFilenameGeneratorExpression(PARSER.parseExpression(localFilenameGeneratorExpression));
        return (S)((RemoteInboundChannelAdapterSpec)this._this());
    }

    public S temporaryFileSuffix(String temporaryFileSuffix) {
        this.synchronizer.setTemporaryFileSuffix(temporaryFileSuffix);
        return (S)((RemoteInboundChannelAdapterSpec)this._this());
    }

    public S remoteDirectory(String remoteDirectory) {
        this.synchronizer.setRemoteDirectory(remoteDirectory);
        return (S)((RemoteInboundChannelAdapterSpec)this._this());
    }

    public S filter(FileListFilter<F> filter) {
        Assert.isNull(this.filter, (String)("The 'filter' (" + this.filter + ") is already configured for the: " + this));
        this.filter = filter;
        this.synchronizer.setFilter(filter);
        return (S)((RemoteInboundChannelAdapterSpec)this._this());
    }

    public abstract S patternFilter(String var1);

    public abstract S regexFilter(String var1);

    public S deleteRemoteFiles(boolean deleteRemoteFiles) {
        this.synchronizer.setDeleteRemoteFiles(deleteRemoteFiles);
        return (S)((RemoteInboundChannelAdapterSpec)this._this());
    }

    public S preserveTimestamp(boolean preserveTimestamp) {
        this.synchronizer.setPreserveTimestamp(preserveTimestamp);
        return (S)((RemoteInboundChannelAdapterSpec)this._this());
    }

    @Override
    public Collection<Object> getComponentsToRegister() {
        return Collections.singletonList(this.synchronizer);
    }

    @Override
    protected MS doGet() {
        throw new UnsupportedOperationException();
    }
}

