/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.file;

import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.dsl.core.ComponentsRegistration;
import org.springframework.integration.dsl.core.MessageHandlerSpec;
import org.springframework.integration.file.DefaultFileNameGenerator;
import org.springframework.integration.file.FileNameGenerator;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.handler.FileTransferringMessageHandler;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.support.FileExistsMode;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class FileTransferringMessageHandlerSpec<F, S extends FileTransferringMessageHandlerSpec<F, S>>
extends MessageHandlerSpec<S, FileTransferringMessageHandler<F>>
implements ComponentsRegistration {
    private FileNameGenerator fileNameGenerator;
    private DefaultFileNameGenerator defaultFileNameGenerator;

    protected FileTransferringMessageHandlerSpec(SessionFactory<F> sessionFactory) {
        this.target = new FileTransferringMessageHandler(sessionFactory);
    }

    protected FileTransferringMessageHandlerSpec(RemoteFileTemplate<F> remoteFileTemplate) {
        this.target = new FileTransferringMessageHandler(remoteFileTemplate);
    }

    protected FileTransferringMessageHandlerSpec(RemoteFileTemplate<F> remoteFileTemplate, FileExistsMode fileExistsMode) {
        Constructor fileExistsModeConstructor = ClassUtils.getConstructorIfAvailable(FileTransferringMessageHandler.class, (Class[])new Class[]{RemoteFileTemplate.class, FileExistsMode.class});
        if (fileExistsModeConstructor == null) {
            this.logger.warn((Object)"The 'FileExistsMode' constructor argument for the 'FileTransferringMessageHandler' is available since Spring Integration 4.1. Will be ignored for previous versions.");
            this.target = new FileTransferringMessageHandler(remoteFileTemplate);
        } else {
            try {
                this.target = (FileTransferringMessageHandler)fileExistsModeConstructor.newInstance(remoteFileTemplate, fileExistsMode);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public S autoCreateDirectory(boolean autoCreateDirectory) {
        ((FileTransferringMessageHandler)this.target).setAutoCreateDirectory(autoCreateDirectory);
        return (S)((FileTransferringMessageHandlerSpec)this._this());
    }

    public S remoteFileSeparator(String remoteFileSeparator) {
        ((FileTransferringMessageHandler)this.target).setRemoteFileSeparator(remoteFileSeparator);
        return (S)((FileTransferringMessageHandlerSpec)this._this());
    }

    public S remoteDirectory(String remoteDirectory) {
        ((FileTransferringMessageHandler)this.target).setRemoteDirectoryExpression((Expression)new LiteralExpression(remoteDirectory));
        return (S)((FileTransferringMessageHandlerSpec)this._this());
    }

    public S remoteDirectoryExpression(String remoteDirectoryExpression) {
        ((FileTransferringMessageHandler)this.target).setRemoteDirectoryExpression(PARSER.parseExpression(remoteDirectoryExpression));
        return (S)((FileTransferringMessageHandlerSpec)this._this());
    }

    public S temporaryRemoteDirectory(String temporaryRemoteDirectory) {
        ((FileTransferringMessageHandler)this.target).setTemporaryRemoteDirectoryExpression((Expression)new LiteralExpression(temporaryRemoteDirectory));
        return (S)((FileTransferringMessageHandlerSpec)this._this());
    }

    public S temporaryRemoteDirectoryExpression(String temporaryRemoteDirectoryExpression) {
        ((FileTransferringMessageHandler)this.target).setTemporaryRemoteDirectoryExpression(PARSER.parseExpression(temporaryRemoteDirectoryExpression));
        return (S)((FileTransferringMessageHandlerSpec)this._this());
    }

    public S useTemporaryFileName(boolean useTemporaryFileName) {
        ((FileTransferringMessageHandler)this.target).setUseTemporaryFileName(useTemporaryFileName);
        return (S)((FileTransferringMessageHandlerSpec)this._this());
    }

    public S fileNameGenerator(FileNameGenerator fileNameGenerator) {
        ((FileTransferringMessageHandler)this.target).setFileNameGenerator(fileNameGenerator);
        return (S)((FileTransferringMessageHandlerSpec)this._this());
    }

    public S fileNameGeneratorExpression(String fileNameGeneratorExpression) {
        Assert.isNull((Object)this.fileNameGenerator, (String)"'fileNameGenerator' and 'fileNameGeneratorExpression' are mutually exclusive.");
        this.defaultFileNameGenerator = new DefaultFileNameGenerator();
        this.defaultFileNameGenerator.setExpression(fileNameGeneratorExpression);
        return this.fileNameGenerator((FileNameGenerator)this.defaultFileNameGenerator);
    }

    public S charset(String charset) {
        ((FileTransferringMessageHandler)this.target).setCharset(charset);
        return (S)((FileTransferringMessageHandlerSpec)this._this());
    }

    public S charset(Charset charset) {
        ((FileTransferringMessageHandler)this.target).setCharset(charset.name());
        return (S)((FileTransferringMessageHandlerSpec)this._this());
    }

    public S temporaryFileSuffix(String temporaryFileSuffix) {
        ((FileTransferringMessageHandler)this.target).setTemporaryFileSuffix(temporaryFileSuffix);
        return (S)((FileTransferringMessageHandlerSpec)this._this());
    }

    @Override
    public Collection<Object> getComponentsToRegister() {
        if (this.defaultFileNameGenerator != null) {
            return Collections.singletonList(this.defaultFileNameGenerator);
        }
        return null;
    }

    @Override
    protected FileTransferringMessageHandler<F> doGet() {
        throw new UnsupportedOperationException();
    }
}

