/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.amqp;

import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.integration.amqp.inbound.AmqpInboundChannelAdapter;
import org.springframework.integration.amqp.inbound.AmqpInboundGateway;
import org.springframework.integration.dsl.amqp.AmqpInboundChannelAdapterSpec;
import org.springframework.integration.dsl.amqp.AmqpInboundGatewaySpec;
import org.springframework.integration.dsl.amqp.AmqpMessageChannelSpec;
import org.springframework.integration.dsl.amqp.AmqpOutboundEndpointSpec;
import org.springframework.integration.dsl.amqp.AmqpPollableMessageChannelSpec;
import org.springframework.integration.dsl.amqp.AmqpPublishSubscribeMessageChannelSpec;
import org.springframework.integration.dsl.core.MessageProducerSpec;
import org.springframework.integration.dsl.core.MessagingGatewaySpec;

public abstract class Amqp {
    public static AmqpInboundGatewaySpec inboundGateway(ConnectionFactory connectionFactory, String ... queueNames) {
        SimpleMessageListenerContainer listenerContainer = new SimpleMessageListenerContainer(connectionFactory);
        listenerContainer.setQueueNames(queueNames);
        return (AmqpInboundGatewaySpec)Amqp.inboundGateway(listenerContainer);
    }

    public static AmqpInboundGatewaySpec inboundGateway(ConnectionFactory connectionFactory, Queue ... queues) {
        SimpleMessageListenerContainer listenerContainer = new SimpleMessageListenerContainer(connectionFactory);
        listenerContainer.setQueues(queues);
        return (AmqpInboundGatewaySpec)Amqp.inboundGateway(listenerContainer);
    }

    public static MessagingGatewaySpec<AmqpInboundGatewaySpec, AmqpInboundGateway> inboundGateway(SimpleMessageListenerContainer listenerContainer) {
        return new AmqpInboundGatewaySpec(listenerContainer);
    }

    public static AmqpInboundChannelAdapterSpec inboundAdapter(ConnectionFactory connectionFactory, String ... queueNames) {
        SimpleMessageListenerContainer listenerContainer = new SimpleMessageListenerContainer(connectionFactory);
        listenerContainer.setQueueNames(queueNames);
        return (AmqpInboundChannelAdapterSpec)Amqp.inboundAdapter(listenerContainer);
    }

    public static AmqpInboundChannelAdapterSpec inboundAdapter(ConnectionFactory connectionFactory, Queue ... queues) {
        SimpleMessageListenerContainer listenerContainer = new SimpleMessageListenerContainer(connectionFactory);
        listenerContainer.setQueues(queues);
        return (AmqpInboundChannelAdapterSpec)Amqp.inboundAdapter(listenerContainer);
    }

    public static MessageProducerSpec<AmqpInboundChannelAdapterSpec, AmqpInboundChannelAdapter> inboundAdapter(SimpleMessageListenerContainer listenerContainer) {
        return new AmqpInboundChannelAdapterSpec(listenerContainer);
    }

    public static AmqpOutboundEndpointSpec outboundAdapter(AmqpTemplate amqpTemplate) {
        return new AmqpOutboundEndpointSpec(amqpTemplate, false);
    }

    public static AmqpOutboundEndpointSpec outboundGateway(AmqpTemplate amqpTemplate) {
        return new AmqpOutboundEndpointSpec(amqpTemplate, true);
    }

    public static <S extends AmqpPollableMessageChannelSpec<S>> AmqpPollableMessageChannelSpec<S> pollableChannel(ConnectionFactory connectionFactory) {
        return Amqp.pollableChannel(null, connectionFactory);
    }

    public static <S extends AmqpPollableMessageChannelSpec<S>> AmqpPollableMessageChannelSpec<S> pollableChannel(String id, ConnectionFactory connectionFactory) {
        return new AmqpPollableMessageChannelSpec(connectionFactory).id(id);
    }

    public static <S extends AmqpMessageChannelSpec<S>> AmqpMessageChannelSpec<S> channel(ConnectionFactory connectionFactory) {
        return Amqp.channel(null, connectionFactory);
    }

    public static <S extends AmqpMessageChannelSpec<S>> AmqpMessageChannelSpec<S> channel(String id, ConnectionFactory connectionFactory) {
        return (AmqpMessageChannelSpec)new AmqpMessageChannelSpec(connectionFactory).id(id);
    }

    public static AmqpPublishSubscribeMessageChannelSpec publishSubscribeChannel(ConnectionFactory connectionFactory) {
        return Amqp.publishSubscribeChannel(null, connectionFactory);
    }

    public static AmqpPublishSubscribeMessageChannelSpec publishSubscribeChannel(String id, ConnectionFactory connectionFactory) {
        return (AmqpPublishSubscribeMessageChannelSpec)new AmqpPublishSubscribeMessageChannelSpec(connectionFactory).id(id);
    }
}

