/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import java.util.HashMap;
import java.util.Map;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.dsl.core.MessageHandlerSpec;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.transformer.ContentEnricher;
import org.springframework.integration.transformer.support.ExpressionEvaluatingHeaderValueMessageProcessor;
import org.springframework.integration.transformer.support.HeaderValueMessageProcessor;
import org.springframework.integration.transformer.support.StaticHeaderValueMessageProcessor;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;

public class EnricherSpec
extends MessageHandlerSpec<EnricherSpec, ContentEnricher> {
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    private final ContentEnricher enricher = new ContentEnricher();
    private final Map<String, Expression> propertyExpressions = new HashMap<String, Expression>();
    private final Map<String, HeaderValueMessageProcessor<?>> headerExpressions = new HashMap();

    EnricherSpec() {
    }

    public EnricherSpec requestChannel(MessageChannel requestChannel) {
        this.enricher.setRequestChannel(requestChannel);
        return (EnricherSpec)this._this();
    }

    public EnricherSpec requestChannel(String requestChannel) {
        this.enricher.setRequestChannelName(requestChannel);
        return (EnricherSpec)this._this();
    }

    public EnricherSpec replyChannel(MessageChannel replyChannel) {
        this.enricher.setReplyChannel(replyChannel);
        return (EnricherSpec)this._this();
    }

    public EnricherSpec replyChannel(String replyChannel) {
        this.enricher.setReplyChannelName(replyChannel);
        return (EnricherSpec)this._this();
    }

    public EnricherSpec requestTimeout(Long requestTimeout) {
        this.enricher.setRequestTimeout(requestTimeout);
        return (EnricherSpec)this._this();
    }

    public EnricherSpec replyTimeout(Long replyTimeout) {
        this.enricher.setReplyTimeout(replyTimeout);
        return (EnricherSpec)this._this();
    }

    public EnricherSpec requestPayloadExpression(String requestPayloadExpression) {
        this.enricher.setRequestPayloadExpression(PARSER.parseExpression(requestPayloadExpression));
        return (EnricherSpec)this._this();
    }

    public EnricherSpec shouldClonePayload(boolean shouldClonePayload) {
        this.enricher.setShouldClonePayload(shouldClonePayload);
        return (EnricherSpec)this._this();
    }

    public <V> EnricherSpec property(String key, V value) {
        this.propertyExpressions.put(key, (Expression)new ValueExpression(value));
        return (EnricherSpec)this._this();
    }

    public EnricherSpec propertyExpression(String key, String expression) {
        Assert.notNull((Object)key);
        this.propertyExpressions.put(key, PARSER.parseExpression(expression));
        return (EnricherSpec)this._this();
    }

    public <V> EnricherSpec header(String name, V value) {
        return this.header(name, value, null);
    }

    public <V> EnricherSpec header(String name, V value, Boolean overwrite) {
        StaticHeaderValueMessageProcessor headerValueMessageProcessor = new StaticHeaderValueMessageProcessor(value);
        headerValueMessageProcessor.setOverwrite(overwrite);
        return this.header(name, (HeaderValueMessageProcessor<V>)headerValueMessageProcessor);
    }

    public EnricherSpec headerExpression(String name, String expression) {
        return this.headerExpression(name, expression, null);
    }

    public EnricherSpec headerExpression(String name, String expression, Boolean overwrite) {
        ExpressionEvaluatingHeaderValueMessageProcessor headerValueMessageProcessor = new ExpressionEvaluatingHeaderValueMessageProcessor(expression, null);
        headerValueMessageProcessor.setOverwrite(overwrite);
        return this.header(name, (HeaderValueMessageProcessor)headerValueMessageProcessor);
    }

    public <V> EnricherSpec header(String name, HeaderValueMessageProcessor<V> headerValueMessageProcessor) {
        Assert.notNull((Object)name);
        this.headerExpressions.put(name, headerValueMessageProcessor);
        return (EnricherSpec)this._this();
    }

    @Override
    protected ContentEnricher doGet() {
        if (!this.propertyExpressions.isEmpty()) {
            this.enricher.setPropertyExpressions(this.propertyExpressions);
        }
        if (!this.headerExpressions.isEmpty()) {
            this.enricher.setHeaderExpressions(this.headerExpressions);
        }
        return this.enricher;
    }
}

