/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.integration.core.MessageSelector;
import org.springframework.integration.filter.ExpressionEvaluatingSelector;
import org.springframework.integration.router.RecipientListRouter;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.core.DestinationResolutionException;
import org.springframework.util.StringUtils;

class DslRecipientListRouter
extends RecipientListRouter {
    private final Map<String, String> expressionRecipientMap = new HashMap<String, String>();
    private final Map<String, MessageSelector> selectorRecipientMap = new HashMap<String, MessageSelector>();

    DslRecipientListRouter() {
    }

    void add(String channelName, String expression) {
        this.expressionRecipientMap.put(channelName, expression);
    }

    void add(String channelName, MessageSelector selector) {
        this.selectorRecipientMap.put(channelName, selector);
    }

    Map<String, Object> get() {
        HashMap<String, Object> recipients = new HashMap<String, Object>(this.expressionRecipientMap.size() + this.selectorRecipientMap.size());
        recipients.putAll(this.expressionRecipientMap);
        recipients.putAll(this.selectorRecipientMap);
        return recipients;
    }

    public void onInit() throws Exception {
        for (Map.Entry<String, String> recipient : this.expressionRecipientMap.entrySet()) {
            ExpressionEvaluatingSelector selector = null;
            String expression = recipient.getValue();
            if (StringUtils.hasText((String)expression)) {
                selector = new ExpressionEvaluatingSelector(expression);
                selector.setBeanFactory(this.getBeanFactory());
            }
            this.selectorRecipientMap.put(recipient.getKey(), (MessageSelector)selector);
        }
        ArrayList<RecipientListRouter.Recipient> recipients = new ArrayList<RecipientListRouter.Recipient>(this.selectorRecipientMap.size());
        for (Map.Entry<String, MessageSelector> entry : this.selectorRecipientMap.entrySet()) {
            recipients.add(new RecipientListRouter.Recipient(this.resolveChannelName(entry.getKey()), entry.getValue()));
        }
        this.setRecipients(recipients);
        super.onInit();
    }

    private MessageChannel resolveChannelName(String channelName) {
        try {
            return (MessageChannel)this.getBeanFactory().getBean(channelName, MessageChannel.class);
        }
        catch (BeansException e) {
            throw new DestinationResolutionException("Failed to look up MessageChannel with name '" + channelName + "' in the BeanFactory.");
        }
    }
}

