/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.io.IOException;
import javax.net.ssl.SSLSession;
import org.jspecify.annotations.Nullable;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.integration.ip.tcp.connection.SocketInfo;
import org.springframework.integration.ip.tcp.connection.TcpListener;
import org.springframework.messaging.Message;

public interface TcpConnection
extends Runnable {
    public void close();

    public boolean isOpen();

    public void send(Message<?> var1);

    public @Nullable Object getPayload();

    public String getHostName();

    public String getHostAddress();

    public int getPort();

    public String getConnectionId();

    public boolean isServer();

    public Deserializer<?> getDeserializer();

    public Serializer<?> getSerializer();

    public @Nullable TcpListener getListener();

    public long incrementAndGetConnectionSequence();

    public @Nullable Object getDeserializerStateKey();

    public @Nullable SSLSession getSslSession();

    public @Nullable SocketInfo getSocketInfo();

    default public void shutdownInput() throws IOException {
        throw new UnsupportedOperationException("This connection does not support shutDownInput()");
    }

    default public void shutdownOutput() throws IOException {
        throw new UnsupportedOperationException("This connection does not support shutDownOutput()");
    }
}

