/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.config;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractOutboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.ip.config.IpAdapterParserUtils;
import org.springframework.integration.ip.udp.outbound.MulticastSendingMessageHandler;
import org.springframework.integration.ip.udp.outbound.UnicastSendingMessageHandler;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class UdpOutboundChannelAdapterParser
extends AbstractOutboundChannelAdapterParser {
    protected AbstractBeanDefinition parseConsumer(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = this.parseUdp(element, parserContext);
        IpAdapterParserUtils.addCommonSocketOptions(builder, element);
        return builder.getBeanDefinition();
    }

    private BeanDefinitionBuilder parseUdp(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder;
        String multicast = IpAdapterParserUtils.getMulticast(element);
        if (multicast.equals("true")) {
            builder = BeanDefinitionBuilder.genericBeanDefinition(MulticastSendingMessageHandler.class);
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"min-acks-for-success", (String)"minAcksForSuccess");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"time-to-live", (String)"timeToLive");
        } else {
            builder = BeanDefinitionBuilder.genericBeanDefinition(UnicastSendingMessageHandler.class);
        }
        IpAdapterParserUtils.addDestinationConfigToConstructor(element, builder, parserContext);
        IpAdapterParserUtils.addConstructorValueIfAttributeDefined(builder, element, "check-length");
        IpAdapterParserUtils.addConstructorValueIfAttributeDefined(builder, element, "acknowledge");
        IpAdapterParserUtils.addConstructorValueIfAttributeDefined(builder, element, "ack-host");
        IpAdapterParserUtils.addConstructorValueIfAttributeDefined(builder, element, "ack-port");
        IpAdapterParserUtils.addConstructorValueIfAttributeDefined(builder, element, "ack-timeout");
        String ack = element.getAttribute("acknowledge");
        if (!(!ack.equals("true") || StringUtils.hasText((String)element.getAttribute("ack-host")) && StringUtils.hasText((String)element.getAttribute("ack-port")) && StringUtils.hasText((String)element.getAttribute("ack-timeout")))) {
            parserContext.getReaderContext().error("When acknowledge is true, ack-host, ack-port, and ack-timeout must be supplied", (Object)element);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"receive-buffer-size");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"task-executor");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"socket-expression", (String)"socketExpressionString");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"socket-customizer");
        return builder;
    }
}

