/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLSession;
import org.jspecify.annotations.Nullable;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.integration.ip.tcp.connection.NoListenerException;
import org.springframework.integration.ip.tcp.connection.SocketInfo;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.ip.tcp.connection.TcpConnectionInterceptor;
import org.springframework.integration.ip.tcp.connection.TcpConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpListener;
import org.springframework.integration.ip.tcp.connection.TcpMessageMapper;
import org.springframework.integration.ip.tcp.connection.TcpSender;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.ErrorMessage;

public abstract class TcpConnectionInterceptorSupport
extends TcpConnectionSupport
implements TcpConnectionInterceptor {
    private final Lock lock = new ReentrantLock();
    private TcpConnectionSupport theConnection;
    private @Nullable TcpListener tcpListener;
    private boolean realSender;
    private @Nullable List<TcpSender> interceptedSenders;
    private boolean removed;

    public TcpConnectionInterceptorSupport() {
    }

    public TcpConnectionInterceptorSupport(ApplicationEventPublisher applicationEventPublisher) {
        super(applicationEventPublisher);
    }

    @Override
    public void close() {
        this.theConnection.close();
    }

    @Override
    public boolean isOpen() {
        return this.theConnection.isOpen();
    }

    @Override
    public @Nullable Object getPayload() {
        return this.theConnection.getPayload();
    }

    @Override
    public String getHostName() {
        return this.theConnection.getHostName();
    }

    @Override
    public String getHostAddress() {
        return this.theConnection.getHostAddress();
    }

    @Override
    public int getPort() {
        return this.theConnection.getPort();
    }

    @Override
    public @Nullable Object getDeserializerStateKey() {
        return this.theConnection.getDeserializerStateKey();
    }

    @Override
    public void registerListener(@Nullable TcpListener listener) {
        this.tcpListener = listener;
        this.theConnection.registerListener(this);
    }

    @Override
    public void registerSender(@Nullable TcpSender sender) {
        this.theConnection.registerSender(this);
    }

    @Override
    public void registerSenders(List<TcpSender> sendersToRegister) {
        this.interceptedSenders = sendersToRegister;
        if (!sendersToRegister.isEmpty()) {
            TcpSender tcpSender = sendersToRegister.get(0);
            if (!(tcpSender instanceof TcpConnectionInterceptorSupport)) {
                this.realSender = true;
            } else {
                TcpConnectionInterceptorSupport interceptorToUse = (TcpConnectionInterceptorSupport)tcpSender;
                this.realSender = interceptorToUse.hasRealSender();
            }
        }
        if (this.theConnection instanceof TcpConnectionInterceptorSupport) {
            this.theConnection.registerSenders(Collections.singletonList(this));
        } else {
            super.registerSender(this);
        }
    }

    @Override
    public String getConnectionId() {
        return this.theConnection.getConnectionId();
    }

    @Override
    public @Nullable SocketInfo getSocketInfo() {
        return this.theConnection.getSocketInfo();
    }

    @Override
    public String getConnectionFactoryName() {
        return this.theConnection.getConnectionFactoryName();
    }

    @Override
    public void run() {
        this.theConnection.run();
    }

    @Override
    public void setMapper(TcpMessageMapper mapper) {
        this.theConnection.setMapper(mapper);
    }

    @Override
    public Deserializer<?> getDeserializer() {
        return this.theConnection.getDeserializer();
    }

    @Override
    public void setDeserializer(Deserializer<?> deserializer) {
        this.theConnection.setDeserializer(deserializer);
    }

    @Override
    public Serializer<?> getSerializer() {
        return this.theConnection.getSerializer();
    }

    @Override
    public void setSerializer(Serializer<?> serializer) {
        this.theConnection.setSerializer(serializer);
    }

    @Override
    public boolean isServer() {
        return this.theConnection.isServer();
    }

    @Override
    public @Nullable SSLSession getSslSession() {
        return this.theConnection.getSslSession();
    }

    @Override
    public void onMessage(Message<?> message) {
        if (this.tcpListener == null) {
            if (!(message instanceof ErrorMessage)) {
                throw new NoListenerException("No listener registered for message reception");
            }
            return;
        }
        this.tcpListener.onMessage(message);
    }

    @Override
    public void send(Message<?> message) {
        this.theConnection.send(message);
    }

    public TcpConnectionSupport getTheConnection() {
        return this.theConnection;
    }

    public void setTheConnection(TcpConnectionSupport theConnection) {
        this.theConnection = theConnection;
    }

    @Override
    public @Nullable TcpListener getListener() {
        return this.tcpListener;
    }

    @Override
    public void addNewConnection(TcpConnection connection) {
        if (this.interceptedSenders != null) {
            this.interceptedSenders.forEach(sender -> sender.addNewConnection(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDeadConnection(TcpConnection connection) {
        this.lock.lock();
        try {
            TcpSender sender;
            if (this.removed) {
                return;
            }
            this.removed = true;
            TcpConnectionSupport tcpConnectionSupport = this.theConnection;
            if (tcpConnectionSupport instanceof TcpConnectionInterceptorSupport) {
                TcpConnectionInterceptorSupport tcpConnectionInterceptorSupport = (TcpConnectionInterceptorSupport)tcpConnectionSupport;
                if (!this.theConnection.equals(this)) {
                    tcpConnectionInterceptorSupport.removeDeadConnection(this);
                }
            }
            if ((sender = this.getSender()) != null && this.interceptedSenders != null && !(sender instanceof TcpConnectionInterceptorSupport)) {
                this.interceptedSenders.forEach(intercepted -> intercepted.removeDeadConnection(connection));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long incrementAndGetConnectionSequence() {
        return this.theConnection.incrementAndGetConnectionSequence();
    }

    @Override
    public @Nullable TcpSender getSender() {
        return this.interceptedSenders != null && !this.interceptedSenders.isEmpty() ? this.interceptedSenders.get(0) : null;
    }

    @Override
    public List<TcpSender> getSenders() {
        return this.interceptedSenders == null ? super.getSenders() : Collections.unmodifiableList(this.interceptedSenders);
    }

    protected boolean hasRealSender() {
        return this.realSender;
    }
}

