/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.util;

import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.integration.ip.AbstractInternetProtocolReceivingChannelAdapter;
import org.springframework.integration.ip.tcp.connection.AbstractConnectionFactory;
import org.springframework.integration.ip.tcp.connection.AbstractServerConnectionFactory;

public final class TestingUtilities {
    private TestingUtilities() {
        throw new AssertionError((Object)"Class Instantiation not allowed.");
    }

    public static void waitListening(AbstractServerConnectionFactory serverConnectionFactory, @Nullable Long delay) throws IllegalStateException {
        TestingUtilities.waitListeningInternal(serverConnectionFactory::isListening, delay);
    }

    public static void waitListening(AbstractInternetProtocolReceivingChannelAdapter adapter, @Nullable Long delay) throws IllegalStateException {
        TestingUtilities.waitListeningInternal(adapter::isListening, delay);
    }

    private static void waitListeningInternal(Supplier<Boolean> isListeningSupplier, @Nullable Long delayArg) throws IllegalStateException {
        Long delay = delayArg;
        delay = delay == null ? Long.valueOf(100L) : Long.valueOf(delay / 100L);
        int n = 0;
        while (!isListeningSupplier.get().booleanValue()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e1);
            }
            if ((long)n++ <= delay) continue;
            throw new IllegalStateException("Server didn't start listening.");
        }
    }

    public static void waitStopListening(AbstractServerConnectionFactory serverConnectionFactory, @Nullable Long delayArg) throws IllegalStateException {
        Long delay = delayArg;
        delay = delay == null ? Long.valueOf(100L) : Long.valueOf(delay / 100L);
        int n = 0;
        while (serverConnectionFactory.isListening()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
            if ((long)n++ <= delay) continue;
            throw new IllegalStateException("Server didn't stop listening.");
        }
    }

    public static void waitUntilFactoryHasThisNumberOfConnections(AbstractConnectionFactory factory, int n) throws InterruptedException {
        for (int timer = 0; timer < 10000; timer += 100) {
            if (factory.getOpenConnectionIds().size() == n) {
                return;
            }
            Thread.sleep(100L);
        }
        throw new IllegalStateException("Connections=" + factory.getOpenConnectionIds().size() + "wanted=" + n);
    }
}

