/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp;

import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jspecify.annotations.Nullable;
import org.springframework.context.ApplicationEvent;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.ip.tcp.connection.AbstractClientConnectionFactory;
import org.springframework.integration.ip.tcp.connection.AbstractConnectionFactory;
import org.springframework.integration.ip.tcp.connection.ClientModeCapable;
import org.springframework.integration.ip.tcp.connection.ClientModeConnectionManager;
import org.springframework.integration.ip.tcp.connection.ConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.ip.tcp.connection.TcpConnectionFailedCorrelationEvent;
import org.springframework.integration.ip.tcp.connection.TcpSender;
import org.springframework.integration.support.management.ManageableLifecycle;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;

public class TcpSendingMessageHandler
extends AbstractMessageHandler
implements TcpSender,
ManageableLifecycle,
ClientModeCapable {
    public static final long DEFAULT_RETRY_INTERVAL = 60000L;
    protected final Lock lifecycleMonitor = new ReentrantLock();
    private final Map<String, TcpConnection> connections = new ConcurrentHashMap<String, TcpConnection>();
    private @Nullable AbstractConnectionFactory clientConnectionFactory;
    private @Nullable AbstractConnectionFactory serverConnectionFactory;
    private boolean isClientMode;
    private boolean isSingleUse;
    private long retryInterval = 60000L;
    private volatile @Nullable ScheduledFuture<?> scheduledFuture;
    private volatile @Nullable ClientModeConnectionManager clientModeConnectionManager;
    private volatile boolean active;

    protected TcpConnection obtainConnection(Message<?> message) {
        TcpConnection connection;
        Assert.notNull((Object)this.clientConnectionFactory, (String)"'clientConnectionFactory' cannot be null");
        try {
            connection = this.clientConnectionFactory.getConnection();
        }
        catch (Exception ex) {
            throw new MessageHandlingException(message, "Failed to obtain a connection in the [" + String.valueOf(this) + "]", (Throwable)ex);
        }
        return connection;
    }

    public void handleMessageInternal(Message<?> message) {
        if (this.serverConnectionFactory != null) {
            this.handleMessageAsServer(message);
        } else {
            this.handleMessageAsClient(message);
        }
    }

    private void handleMessageAsServer(Message<?> message) {
        String connectionId = (String)message.getHeaders().get((Object)"ip_connectionId", String.class);
        TcpConnection connection = null;
        if (connectionId != null) {
            connection = this.connections.get(connectionId);
        }
        if (connection != null) {
            try {
                connection.send(message);
            }
            catch (Exception ex) {
                connection.close();
                throw IntegrationUtils.wrapInHandlingExceptionIfNecessary(message, () -> "Error sending message in the [" + String.valueOf(this) + "]", (Throwable)ex);
            }
            finally {
                if (this.isSingleUse) {
                    connection.close();
                }
            }
        } else {
            MessageHandlingException messageHandlingException = new MessageHandlingException(message, "Unable to find outbound socket in the [" + String.valueOf(this) + "]");
            this.publishNoConnectionEvent(messageHandlingException, connectionId);
            throw messageHandlingException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessageAsClient(Message<?> message) {
        block7: {
            TcpConnection connection = null;
            try {
                connection = this.doWrite(message);
            }
            catch (MessageHandlingException ex) {
                if (ex.getCause() instanceof IOException) {
                    this.logger.debug((Throwable)ex, (CharSequence)"Fail on first write attempt");
                    connection = this.doWrite(message);
                    break block7;
                }
                throw ex;
            }
            finally {
                if (connection != null && this.isSingleUse && this.clientConnectionFactory != null && this.clientConnectionFactory.getListener() == null) {
                    connection.close();
                }
            }
        }
    }

    protected TcpConnection doWrite(Message<?> message) {
        TcpConnection connection = null;
        try {
            TcpConnection connectionToLog = connection = this.obtainConnection(message);
            this.logger.debug(() -> "Got Connection " + connectionToLog.getConnectionId());
            connection.send(message);
        }
        catch (Exception ex) {
            String connectionId = connection != null ? connection.getConnectionId() : null;
            throw IntegrationUtils.wrapInHandlingExceptionIfNecessary(message, () -> "Failed to handle message in the [" + String.valueOf(this) + "] using " + connectionId, (Throwable)ex);
        }
        return connection;
    }

    private void publishNoConnectionEvent(MessageHandlingException messageHandlingException, @Nullable String connectionId) {
        AbstractConnectionFactory cf = this.serverConnectionFactory != null ? this.serverConnectionFactory : this.clientConnectionFactory;
        cf.getApplicationEventPublisher().publishEvent((ApplicationEvent)new TcpConnectionFailedCorrelationEvent(this, connectionId, (MessagingException)messageHandlingException));
    }

    public void setConnectionFactory(AbstractConnectionFactory connectionFactory) {
        if (connectionFactory instanceof AbstractClientConnectionFactory) {
            this.clientConnectionFactory = connectionFactory;
        } else {
            this.serverConnectionFactory = connectionFactory;
            connectionFactory.registerSender(this);
        }
        this.isSingleUse = connectionFactory.isSingleUse();
    }

    @Override
    public void addNewConnection(TcpConnection connection) {
        this.connections.put(connection.getConnectionId(), connection);
    }

    @Override
    public void removeDeadConnection(TcpConnection connection) {
        this.connections.remove(connection.getConnectionId());
    }

    public String getComponentType() {
        return "ip:tcp-outbound-channel-adapter";
    }

    protected void onInit() {
        super.onInit();
        if (this.isClientMode) {
            Assert.notNull((Object)this.clientConnectionFactory, (String)"For client-mode, connection factory must be type='client'");
            Assert.isTrue((!this.clientConnectionFactory.isSingleUse() ? 1 : 0) != 0, (String)"For client-mode, connection factory must have single-use='false'");
        }
    }

    public void start() {
        this.lifecycleMonitor.lock();
        try {
            if (!this.active) {
                this.active = true;
                if (this.clientConnectionFactory != null) {
                    this.clientConnectionFactory.start();
                }
                if (this.serverConnectionFactory != null) {
                    this.serverConnectionFactory.start();
                }
                if (this.isClientMode) {
                    ClientModeConnectionManager manager;
                    Assert.notNull((Object)this.clientConnectionFactory, (String)"For client-mode, connection factory must be type='client'");
                    this.clientModeConnectionManager = manager = new ClientModeConnectionManager(this.clientConnectionFactory);
                    this.scheduledFuture = this.getTaskScheduler().scheduleAtFixedRate((Runnable)manager, Duration.ofMillis(this.retryInterval));
                }
            }
        }
        finally {
            this.lifecycleMonitor.unlock();
        }
    }

    public void stop() {
        this.lifecycleMonitor.lock();
        try {
            if (this.active) {
                this.active = false;
                ScheduledFuture<?> scheduledFutureToCancel = this.scheduledFuture;
                if (scheduledFutureToCancel != null) {
                    scheduledFutureToCancel.cancel(true);
                }
                this.clientModeConnectionManager = null;
                if (this.clientConnectionFactory != null) {
                    this.clientConnectionFactory.stop();
                }
                if (this.serverConnectionFactory != null) {
                    this.serverConnectionFactory.stop();
                }
            }
        }
        finally {
            this.lifecycleMonitor.unlock();
        }
    }

    public boolean isRunning() {
        return this.active;
    }

    protected @Nullable ConnectionFactory getClientConnectionFactory() {
        return this.clientConnectionFactory;
    }

    protected @Nullable ConnectionFactory getServerConnectionFactory() {
        return this.serverConnectionFactory;
    }

    protected Map<String, TcpConnection> getConnections() {
        return this.connections;
    }

    @Override
    public boolean isClientMode() {
        return this.isClientMode;
    }

    public void setClientMode(boolean isClientMode) {
        this.isClientMode = isClientMode;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
    }

    @Override
    public boolean isClientModeConnected() {
        ClientModeConnectionManager clientModeConnectionManagerToCheck = this.clientModeConnectionManager;
        if (this.isClientMode && clientModeConnectionManagerToCheck != null) {
            return clientModeConnectionManagerToCheck.isConnected();
        }
        return false;
    }

    @Override
    public void retryConnection() {
        ClientModeConnectionManager clientModeConnectionManagerToRun = this.clientModeConnectionManager;
        if (this.active && this.isClientMode && clientModeConnectionManagerToRun != null) {
            clientModeConnectionManagerToRun.run();
        }
    }
}

