/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.time.Instant;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.integration.context.OrderlyShutdownCapable;
import org.springframework.integration.ip.tcp.connection.AbstractConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.ip.tcp.connection.TcpConnectionServerExceptionEvent;
import org.springframework.integration.ip.tcp.connection.TcpConnectionServerListeningEvent;
import org.springframework.integration.ip.tcp.connection.TcpConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpListener;
import org.springframework.integration.ip.tcp.connection.TcpServerConnectionFactory;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.SchedulingAwareRunnable;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;

public abstract class AbstractServerConnectionFactory
extends AbstractConnectionFactory
implements TcpServerConnectionFactory,
SchedulingAwareRunnable,
OrderlyShutdownCapable {
    private static final int DEFAULT_BACKLOG = 5;
    private int backlog = 5;
    private String localAddress;
    private volatile boolean listening;
    private volatile boolean shuttingDown;

    public AbstractServerConnectionFactory(int port) {
        super(port);
    }

    public boolean isLongLived() {
        return true;
    }

    @Override
    @Nullable
    public SocketAddress getServerSocketAddress() {
        return null;
    }

    @Override
    public void start() {
        this.lifecycleMonitor.lock();
        try {
            if (!this.isActive()) {
                this.setActive(true);
                this.shuttingDown = false;
                this.getTaskExecutor().execute((Runnable)((Object)this));
            }
        }
        finally {
            this.lifecycleMonitor.unlock();
        }
        super.start();
    }

    @Override
    public TcpConnection getConnection() {
        throw new UnsupportedOperationException("Getting a connection from a server factory is not supported");
    }

    protected void setListening(boolean listening) {
        this.listening = listening;
    }

    public boolean isListening() {
        return this.listening;
    }

    protected boolean isShuttingDown() {
        return this.shuttingDown;
    }

    protected void initializeConnection(TcpConnectionSupport connection, Socket socket) {
        TcpListener listener = this.getListener();
        if (listener != null) {
            connection.registerListener(listener);
        }
        connection.registerSenders(this.getSenders());
        connection.setMapper(this.getMapper());
        connection.setDeserializer(this.getDeserializer());
        connection.setSerializer(this.getSerializer());
        if (this.isSingleUse() && this.getSoTimeout() < 0) {
            try {
                socket.setSoTimeout(10000);
            }
            catch (SocketException ex) {
                this.logger.error((Throwable)ex, (CharSequence)"Error setting default reply timeout");
            }
        }
    }

    protected void postProcessServerSocket(ServerSocket serverSocket) {
        this.getTcpSocketSupport().postProcessServerSocket(serverSocket);
    }

    @Nullable
    public String getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        Assert.isTrue((backlog >= 0 ? 1 : 0) != 0, (String)"You cannot set backlog negative");
        this.backlog = backlog;
    }

    public int beforeShutdown() {
        this.shuttingDown = true;
        return 0;
    }

    public int afterShutdown() {
        this.stop();
        return 0;
    }

    protected void publishServerExceptionEvent(Exception ex) {
        ApplicationEventPublisher applicationEventPublisher = this.getApplicationEventPublisher();
        if (applicationEventPublisher != null) {
            applicationEventPublisher.publishEvent((ApplicationEvent)new TcpConnectionServerExceptionEvent(this, ex));
        }
    }

    protected void publishServerListeningEvent(int port) {
        ApplicationEventPublisher eventPublisher = this.getApplicationEventPublisher();
        if (eventPublisher != null) {
            TcpConnectionServerListeningEvent event = new TcpConnectionServerListeningEvent(this, port);
            TaskScheduler taskScheduler = this.getTaskScheduler();
            if (taskScheduler != null) {
                try {
                    taskScheduler.schedule(() -> eventPublisher.publishEvent((ApplicationEvent)event), Instant.now());
                }
                catch (TaskRejectedException e) {
                    eventPublisher.publishEvent((ApplicationEvent)event);
                }
            } else {
                eventPublisher.publishEvent((ApplicationEvent)event);
            }
        }
    }
}

