/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import javax.net.ServerSocketFactory;
import org.springframework.integration.ip.tcp.connection.AbstractServerConnectionFactory;
import org.springframework.integration.ip.tcp.connection.DefaultTcpNetConnectionSupport;
import org.springframework.integration.ip.tcp.connection.DefaultTcpNetSocketFactorySupport;
import org.springframework.integration.ip.tcp.connection.TcpConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpNetConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpSocketFactorySupport;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class TcpNetServerConnectionFactory
extends AbstractServerConnectionFactory {
    private TcpSocketFactorySupport tcpSocketFactorySupport = new DefaultTcpNetSocketFactorySupport();
    private TcpNetConnectionSupport tcpNetConnectionSupport = new DefaultTcpNetConnectionSupport();
    private volatile ServerSocket serverSocket;

    public TcpNetServerConnectionFactory(int port) {
        super(port);
    }

    public String getComponentType() {
        return "tcp-net-server-connection-factory";
    }

    @Override
    public int getPort() {
        int port = super.getPort();
        ServerSocket socket = this.serverSocket;
        if (port == 0 && socket != null) {
            port = socket.getLocalPort();
        }
        return port;
    }

    @Override
    @Nullable
    public SocketAddress getServerSocketAddress() {
        if (this.serverSocket != null) {
            return this.serverSocket.getLocalSocketAddress();
        }
        return null;
    }

    public void setTcpSocketFactorySupport(TcpSocketFactorySupport tcpSocketFactorySupport) {
        Assert.notNull((Object)tcpSocketFactorySupport, (String)"TcpSocketFactorySupport may not be null");
        this.tcpSocketFactorySupport = tcpSocketFactorySupport;
    }

    public void setTcpNetConnectionSupport(TcpNetConnectionSupport connectionSupport) {
        Assert.notNull((Object)connectionSupport, (String)"'connectionSupport' cannot be null");
        this.tcpNetConnectionSupport = connectionSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.getListener() == null) {
            this.logger.info(() -> this + " No listener bound to server connection factory; will not read; exiting...");
            return;
        }
        try {
            try {
                this.setupServerSocket();
                while (true) {
                    Socket socket;
                    try {
                        if (this.serverSocket == null) {
                            this.logger.debug(() -> this + " stopped before accept");
                            throw new IOException(this + " stopped before accept");
                        }
                        socket = this.serverSocket.accept();
                    }
                    catch (SocketTimeoutException ste) {
                        this.logger.debug((CharSequence)"Timed out on accept; continuing");
                        continue;
                    }
                    if (this.isShuttingDown()) {
                        this.logger.info(() -> "New connection from " + socket.getInetAddress().getHostAddress() + ":" + socket.getPort() + " rejected; the server is in the process of shutting down.");
                        socket.close();
                        continue;
                    }
                    this.logger.debug(() -> "Accepted connection from " + socket.getInetAddress().getHostAddress() + ":" + socket.getPort());
                    try {
                        this.setSocketAttributes(socket);
                        TcpConnectionSupport connection = this.tcpNetConnectionSupport.createNewConnection(socket, true, this.isLookupHost(), this.getApplicationEventPublisher(), this.getComponentName());
                        connection = this.wrapConnection(connection);
                        this.initializeConnection(connection, socket);
                        this.getTaskExecutor().execute(connection);
                        this.harvestClosedConnections();
                        connection.publishConnectionOpenEvent();
                    }
                    catch (RuntimeException ex) {
                        this.logger.error((Throwable)ex, () -> "Failed to create and configure a TcpConnection for the new socket: " + socket.getInetAddress().getHostAddress() + ":" + socket.getPort());
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (IOException ex) {
                if (ex instanceof SocketException && this.serverSocket != null) {
                    this.logger.info((CharSequence)"Server Socket closed");
                } else if (this.isActive()) {
                    this.logger.error((Throwable)ex, (CharSequence)("Error on ServerSocket; port = " + this.getPort()));
                    this.publishServerExceptionEvent(ex);
                    this.stop();
                }
                this.setListening(false);
                this.setActive(false);
            }
        }
        catch (Throwable throwable) {
            this.setListening(false);
            this.setActive(false);
            throw throwable;
        }
    }

    private void setupServerSocket() throws IOException {
        ServerSocket theServerSocket;
        if (this.getLocalAddress() == null) {
            theServerSocket = this.createServerSocket(super.getPort(), this.getBacklog(), null);
        } else {
            InetAddress whichNic = InetAddress.getByName(this.getLocalAddress());
            theServerSocket = this.createServerSocket(super.getPort(), this.getBacklog(), whichNic);
        }
        this.getTcpSocketSupport().postProcessServerSocket(theServerSocket);
        this.serverSocket = theServerSocket;
        this.setListening(true);
        this.logger.info(() -> this + " Listening");
        this.publishServerListeningEvent(this.getPort());
    }

    protected ServerSocket createServerSocket(int port, int backlog, @Nullable InetAddress whichNic) throws IOException {
        ServerSocketFactory serverSocketFactory = this.tcpSocketFactorySupport.getServerSocketFactory();
        if (whichNic == null) {
            return serverSocketFactory.createServerSocket(port, Math.abs(backlog));
        }
        return serverSocketFactory.createServerSocket(port, Math.abs(backlog), whichNic);
    }

    @Override
    public void stop() {
        if (this.serverSocket == null) {
            return;
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.serverSocket = null;
        super.stop();
    }

    protected ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    protected TcpSocketFactorySupport getTcpSocketFactorySupport() {
        return this.tcpSocketFactorySupport;
    }
}

