/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.springframework.integration.ip.tcp.connection.AbstractClientConnectionFactory;
import org.springframework.integration.ip.tcp.connection.DefaultTcpNioConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpNioConnection;
import org.springframework.integration.ip.tcp.connection.TcpNioConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpNioSSLConnection;
import org.springframework.scheduling.SchedulingAwareRunnable;
import org.springframework.util.Assert;

public class TcpNioClientConnectionFactory
extends AbstractClientConnectionFactory
implements SchedulingAwareRunnable {
    private volatile boolean usingDirectBuffers;
    private volatile Selector selector;
    private final Map<SocketChannel, TcpNioConnection> channelMap = new ConcurrentHashMap<SocketChannel, TcpNioConnection>();
    private final BlockingQueue<SocketChannel> newChannels = new LinkedBlockingQueue<SocketChannel>();
    private volatile TcpNioConnectionSupport tcpNioConnectionSupport = new DefaultTcpNioConnectionSupport();

    public TcpNioClientConnectionFactory(String host, int port) {
        super(host, port);
    }

    @Override
    protected void checkActive() throws IOException {
        super.checkActive();
        int n = 0;
        while (this.selector == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (n++ <= 600) continue;
            throw new IOException("Factory failed to start");
        }
    }

    @Override
    protected TcpConnectionSupport buildNewConnection() throws Exception {
        SocketChannel socketChannel = SocketChannel.open(new InetSocketAddress(this.getHost(), this.getPort()));
        this.setSocketAttributes(socketChannel.socket());
        TcpNioConnection connection = this.tcpNioConnectionSupport.createNewConnection(socketChannel, false, this.isLookupHost(), this.getApplicationEventPublisher(), this.getComponentName());
        connection.setUsingDirectBuffers(this.usingDirectBuffers);
        connection.setTaskExecutor(this.getTaskExecutor());
        if (this.getSslHandshakeTimeout() != null && connection instanceof TcpNioSSLConnection) {
            ((TcpNioSSLConnection)connection).setHandshakeTimeout(this.getSslHandshakeTimeout());
        }
        TcpConnectionSupport wrappedConnection = this.wrapConnection(connection);
        this.initializeConnection(wrappedConnection, socketChannel.socket());
        socketChannel.configureBlocking(false);
        if (this.getSoTimeout() > 0) {
            connection.setLastRead(System.currentTimeMillis());
        }
        this.channelMap.put(socketChannel, connection);
        this.newChannels.add(socketChannel);
        this.selector.wakeup();
        return wrappedConnection;
    }

    public void setUsingDirectBuffers(boolean usingDirectBuffers) {
        this.usingDirectBuffers = usingDirectBuffers;
    }

    public void setTcpNioConnectionSupport(TcpNioConnectionSupport tcpNioSupport) {
        Assert.notNull((Object)tcpNioSupport, (String)"TcpNioSupport must not be null");
        this.tcpNioConnectionSupport = tcpNioSupport;
    }

    public boolean isLongLived() {
        return true;
    }

    @Override
    public void stop() {
        if (this.selector != null) {
            try {
                this.selector.close();
            }
            catch (Exception e) {
                this.logger.error((Object)"Error closing selector", (Throwable)e);
            }
        }
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (!this.isActive()) {
                this.setActive(true);
                this.getTaskExecutor().execute((Runnable)((Object)this));
            }
        }
        super.start();
    }

    public void run() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Read selector running for connections to " + this.getHost() + ":" + this.getPort()));
        }
        try {
            this.selector = Selector.open();
            while (this.isActive()) {
                SocketChannel newChannel;
                int selectionCount;
                block13: {
                    int soTimeout = this.getSoTimeout();
                    selectionCount = 0;
                    try {
                        long timeout;
                        long l = timeout = soTimeout < 0 ? 0L : (long)soTimeout;
                        if (this.getDelayedReads().size() > 0 && (timeout == 0L || this.getReadDelay() < timeout)) {
                            timeout = this.getReadDelay();
                        }
                        selectionCount = this.selector.select(timeout);
                    }
                    catch (CancelledKeyException cke) {
                        if (!this.logger.isDebugEnabled()) break block13;
                        this.logger.debug((Object)"CancelledKeyException during Selector.select()");
                    }
                }
                while ((newChannel = (SocketChannel)this.newChannels.poll()) != null) {
                    try {
                        newChannel.register(this.selector, 1, this.channelMap.get(newChannel));
                    }
                    catch (ClosedChannelException cce) {
                        if (!this.logger.isDebugEnabled()) continue;
                        this.logger.debug((Object)"Channel closed before registering with selector for reading");
                    }
                }
                this.processNioSelections(selectionCount, this.selector, null, this.channelMap);
            }
        }
        catch (ClosedSelectorException cse) {
            if (this.isActive()) {
                this.logger.error((Object)"Selector closed", (Throwable)cse);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Exception in read selector thread", (Throwable)e);
            this.setActive(false);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Read selector exiting for connections to " + this.getHost() + ":" + this.getPort()));
        }
    }

    protected boolean isUsingDirectBuffers() {
        return this.usingDirectBuffers;
    }

    protected Map<SocketChannel, TcpNioConnection> getConnections() {
        return this.channelMap;
    }

    protected BlockingQueue<SocketChannel> getNewChannels() {
        return this.newChannels;
    }
}

