/*
 * Copyright 2002-2010 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.integration.ip.tcp.serializer;

import java.io.IOException;

/**
 * Used to communicate that a stream has closed, but between logical
 * messages.
 *
 * @author Gary Russell
 * @since 2.0
 *
 */
public class SoftEndOfStreamException extends IOException {

	private static final long serialVersionUID = 7309907445617226978L;

	public SoftEndOfStreamException() {
		super();
	}

	public SoftEndOfStreamException(String message) {
		super(message);
	}

}
