/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLSession;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.integration.ip.tcp.connection.AbstractClientConnectionFactory;
import org.springframework.integration.ip.tcp.connection.CachingClientConnectionFactory;
import org.springframework.integration.ip.tcp.connection.SocketInfo;
import org.springframework.integration.ip.tcp.connection.TcpConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpListener;
import org.springframework.integration.ip.tcp.connection.TcpMessageMapper;
import org.springframework.integration.ip.tcp.connection.TcpSender;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class FailoverClientConnectionFactory
extends AbstractClientConnectionFactory {
    private static final long DEFAULT_REFRESH_SHARED_INTERVAL = 0L;
    private final List<AbstractClientConnectionFactory> factories;
    private final boolean cachingDelegates;
    private long refreshSharedInterval = 0L;
    private boolean closeOnRefresh;
    private boolean failBack = true;
    private volatile long creationTime;

    public FailoverClientConnectionFactory(List<AbstractClientConnectionFactory> factories) {
        super("", 0);
        Assert.notEmpty(factories, (String)"At least one factory is required");
        this.factories = new ArrayList<AbstractClientConnectionFactory>(factories);
        this.cachingDelegates = factories.stream().anyMatch(factory -> factory instanceof CachingClientConnectionFactory);
    }

    public void setRefreshSharedInterval(long refreshSharedInterval) {
        Assert.isTrue((!this.cachingDelegates ? 1 : 0) != 0, (String)"'refreshSharedInterval' cannot be changed when using 'CachingClientConnectionFactory` delegates");
        this.refreshSharedInterval = refreshSharedInterval;
        this.failBack = refreshSharedInterval != Long.MAX_VALUE;
    }

    public void setCloseOnRefresh(boolean closeOnRefresh) {
        Assert.isTrue((!this.cachingDelegates ? 1 : 0) != 0, (String)"'closeOnRefresh' cannot be changed when using 'CachingClientConnectionFactory` delegates");
        this.closeOnRefresh = closeOnRefresh;
    }

    @Override
    protected void onInit() {
        super.onInit();
        for (AbstractClientConnectionFactory factory : this.factories) {
            Assert.state((!(this.isSingleUse() ^ factory.isSingleUse()) ? 1 : 0) != 0, (String)"Inconsistent singleUse - delegate factories must match this one");
            factory.enableManualListenerRegistration();
        }
    }

    @Override
    public void registerListener(TcpListener listener) {
        super.registerListener(listener);
    }

    @Override
    public void registerSender(TcpSender sender) {
        for (AbstractClientConnectionFactory factory : this.factories) {
            factory.registerSender(sender);
        }
    }

    @Override
    protected TcpConnectionSupport obtainConnection() throws Exception {
        boolean refreshShared;
        FailoverTcpConnection sharedConnection = (FailoverTcpConnection)this.getTheConnection();
        boolean shared = !this.isSingleUse() && !this.cachingDelegates;
        boolean bl = refreshShared = this.failBack && shared && sharedConnection != null && System.currentTimeMillis() > this.creationTime + this.refreshSharedInterval;
        if (sharedConnection != null && sharedConnection.isOpen() && !refreshShared) {
            sharedConnection.incrementEpoch();
            return sharedConnection;
        }
        FailoverTcpConnection failoverTcpConnection = new FailoverTcpConnection(this.factories);
        if (this.getListener() != null) {
            failoverTcpConnection.registerListener(this.getListener());
        }
        failoverTcpConnection.incrementEpoch();
        if (shared) {
            this.creationTime = System.currentTimeMillis();
            if (refreshShared && this.closeOnRefresh && !sharedConnection.delegate.equals(failoverTcpConnection.delegate) && sharedConnection.isOpen()) {
                sharedConnection.close();
            }
            this.setTheConnection(failoverTcpConnection);
        }
        return failoverTcpConnection;
    }

    @Override
    public void start() {
        for (AbstractClientConnectionFactory factory : this.factories) {
            factory.enableManualListenerRegistration();
            factory.start();
        }
        this.setActive(true);
        super.start();
    }

    @Override
    public void stop() {
        this.setActive(false);
        for (AbstractClientConnectionFactory factory : this.factories) {
            factory.stop();
        }
    }

    @Override
    public boolean isRunning() {
        boolean isRunning = true;
        for (AbstractClientConnectionFactory factory : this.factories) {
            isRunning = !isRunning ? false : factory.isRunning();
        }
        return isRunning;
    }

    private final class FailoverTcpConnection
    extends TcpConnectionSupport
    implements TcpListener {
        private final List<AbstractClientConnectionFactory> factories;
        private final String connectionId;
        private final AtomicLong epoch = new AtomicLong();
        private volatile Iterator<AbstractClientConnectionFactory> factoryIterator;
        private volatile AbstractClientConnectionFactory currentFactory;
        volatile TcpConnectionSupport delegate;
        private volatile boolean open = true;

        private FailoverTcpConnection(List<AbstractClientConnectionFactory> factories) throws Exception {
            this.factories = factories;
            this.factoryIterator = factories.iterator();
            this.findAConnection();
            this.connectionId = UUID.randomUUID().toString();
        }

        void incrementEpoch() {
            this.epoch.incrementAndGet();
        }

        private synchronized void findAConnection() throws Exception {
            boolean success = false;
            AbstractClientConnectionFactory lastFactoryToTry = this.currentFactory;
            AbstractClientConnectionFactory nextFactory = null;
            if (!this.factoryIterator.hasNext()) {
                this.factoryIterator = this.factories.iterator();
            }
            boolean retried = false;
            while (!success) {
                try {
                    nextFactory = this.factoryIterator.next();
                    this.delegate = nextFactory.getConnection();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Got " + this.delegate.getConnectionId() + " from " + nextFactory));
                    }
                    this.delegate.registerListener(this);
                    this.currentFactory = nextFactory;
                    success = this.delegate.isOpen();
                }
                catch (Exception e) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)(nextFactory + " failed with " + e.toString() + ", trying another"));
                    }
                    if (this.factoryIterator.hasNext()) continue;
                    if (retried && lastFactoryToTry == null || lastFactoryToTry == nextFactory) {
                        this.open = false;
                        throw e;
                    }
                    this.factoryIterator = this.factories.iterator();
                    retried = true;
                }
            }
        }

        @Override
        public void close() {
            this.delegate.close();
            this.open = false;
        }

        @Override
        public boolean isOpen() {
            return this.open;
        }

        @Override
        public synchronized void send(Message<?> message) throws Exception {
            boolean success = false;
            AbstractClientConnectionFactory lastFactoryToTry = this.currentFactory;
            AbstractClientConnectionFactory lastFactoryTried = null;
            boolean retried = false;
            while (!success) {
                try {
                    lastFactoryTried = this.currentFactory;
                    this.delegate.send(message);
                    success = true;
                }
                catch (Exception e) {
                    if (retried && lastFactoryTried == lastFactoryToTry) {
                        this.logger.error((Object)"All connection factories exhausted", (Throwable)e);
                        this.open = false;
                        throw e;
                    }
                    retried = true;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Send to " + this.delegate.getConnectionId() + " failed; attempting failover"), (Throwable)e);
                    }
                    this.delegate.close();
                    this.findAConnection();
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Failing over to " + this.delegate.getConnectionId()));
                }
            }
        }

        @Override
        public Object getPayload() throws Exception {
            return this.delegate.getPayload();
        }

        @Override
        public void run() {
            throw new UnsupportedOperationException("Not supported on FailoverTcpConnection");
        }

        @Override
        public String getHostName() {
            return this.delegate.getHostName();
        }

        @Override
        public String getHostAddress() {
            return this.delegate.getHostAddress();
        }

        @Override
        public int getPort() {
            return this.delegate.getPort();
        }

        @Override
        public Object getDeserializerStateKey() {
            return this.delegate.getDeserializerStateKey();
        }

        @Override
        public void registerSender(TcpSender sender) {
            this.delegate.registerSender(sender);
        }

        @Override
        public String getConnectionId() {
            return this.connectionId + ":" + this.epoch;
        }

        @Override
        public SocketInfo getSocketInfo() {
            return this.delegate.getSocketInfo();
        }

        @Override
        public boolean isServer() {
            return this.delegate.isServer();
        }

        @Override
        public void setMapper(TcpMessageMapper mapper) {
            this.delegate.setMapper(mapper);
        }

        @Override
        public Deserializer<?> getDeserializer() {
            return this.delegate.getDeserializer();
        }

        @Override
        public void setDeserializer(Deserializer<?> deserializer) {
            this.delegate.setDeserializer(deserializer);
        }

        @Override
        public Serializer<?> getSerializer() {
            return this.delegate.getSerializer();
        }

        @Override
        public void setSerializer(Serializer<?> serializer) {
            this.delegate.setSerializer(serializer);
        }

        @Override
        public SSLSession getSslSession() {
            return this.delegate.getSslSession();
        }

        @Override
        public boolean onMessage(Message<?> message) {
            if (this.delegate.getConnectionId().equals(message.getHeaders().get((Object)"ip_connectionId"))) {
                TcpListener listener;
                AbstractIntegrationMessageBuilder messageBuilder = FailoverClientConnectionFactory.this.getMessageBuilderFactory().fromMessage(message).setHeader("ip_connectionId", (Object)this.getConnectionId());
                if (message.getHeaders().get((Object)"ip_actualConnectionId") == null) {
                    messageBuilder.setHeader("ip_actualConnectionId", message.getHeaders().get((Object)"ip_connectionId"));
                }
                if ((listener = this.getListener()) == null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("No listener for " + message));
                    }
                    return false;
                }
                return listener.onMessage(messageBuilder.build());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Message from defunct connection ignored " + message));
            }
            return false;
        }
    }
}

