/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import org.springframework.integration.ip.tcp.connection.TcpSocketSupport;

public class DefaultTcpSocketSupport
implements TcpSocketSupport {
    private final boolean sslVerifyHost;

    public DefaultTcpSocketSupport() {
        this(false);
    }

    public DefaultTcpSocketSupport(boolean sslVerifyHost) {
        this.sslVerifyHost = sslVerifyHost;
    }

    @Override
    public void postProcessServerSocket(ServerSocket serverSocket) {
    }

    @Override
    public void postProcessSocket(Socket socket) {
        if (this.sslVerifyHost && socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            SSLParameters sslParameters = sslSocket.getSSLParameters();
            if (sslParameters == null) {
                sslParameters = new SSLParameters();
            }
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            sslSocket.setSSLParameters(sslParameters);
        }
    }
}

