/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.ip.tcp.connection.TcpMessageMapper;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.Assert;

public class MessageConvertingTcpMessageMapper
extends TcpMessageMapper {
    private final MessageConverter messageConverter;

    public MessageConvertingTcpMessageMapper(MessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"'messasgeConverter' must not be null");
        this.messageConverter = messageConverter;
    }

    @Override
    public Message<?> toMessage(TcpConnection connection) throws Exception {
        Object data = connection.getPayload();
        if (data != null) {
            Message message = this.messageConverter.toMessage(data, null);
            MessageBuilder messageBuilder = MessageBuilder.fromMessage((Message)message);
            this.addStandardHeaders(connection, messageBuilder);
            this.addCustomHeaders(connection, messageBuilder);
            return messageBuilder.build();
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("Null payload from connection " + connection.getConnectionId()));
        }
        return null;
    }

    @Override
    public Object fromMessage(Message<?> message) throws Exception {
        return this.messageConverter.fromMessage(message, Object.class);
    }
}

