/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.ip.tcp.connection.ConnectionFactory;
import org.springframework.integration.ip.tcp.connection.DefaultTcpSocketSupport;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.ip.tcp.connection.TcpConnectionInterceptorFactory;
import org.springframework.integration.ip.tcp.connection.TcpConnectionInterceptorFactoryChain;
import org.springframework.integration.ip.tcp.connection.TcpConnectionInterceptorSupport;
import org.springframework.integration.ip.tcp.connection.TcpConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpListener;
import org.springframework.integration.ip.tcp.connection.TcpMessageMapper;
import org.springframework.integration.ip.tcp.connection.TcpNioConnection;
import org.springframework.integration.ip.tcp.connection.TcpSender;
import org.springframework.integration.ip.tcp.connection.TcpSocketSupport;
import org.springframework.integration.ip.tcp.serializer.ByteArrayCrLfSerializer;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;

public abstract class AbstractConnectionFactory
extends IntegrationObjectSupport
implements ConnectionFactory,
SmartLifecycle,
ApplicationEventPublisherAware {
    protected static final int DEFAULT_REPLY_TIMEOUT = 10000;
    private volatile String host;
    private volatile int port;
    private volatile TcpListener listener;
    private volatile TcpSender sender;
    private volatile int soTimeout = -1;
    private volatile int soSendBufferSize;
    private volatile int soReceiveBufferSize;
    private volatile boolean soTcpNoDelay;
    private volatile int soLinger = -1;
    private volatile boolean soKeepAlive;
    private volatile int soTrafficClass = -1;
    private volatile Executor taskExecutor;
    private volatile boolean privateExecutor;
    private volatile Deserializer<?> deserializer = new ByteArrayCrLfSerializer();
    private volatile Serializer<?> serializer = new ByteArrayCrLfSerializer();
    private volatile TcpMessageMapper mapper = new TcpMessageMapper();
    private volatile boolean singleUse;
    private volatile boolean active;
    private volatile TcpConnectionInterceptorFactoryChain interceptorFactoryChain;
    private volatile boolean lookupHost = true;
    private volatile List<TcpConnectionSupport> connections = new LinkedList<TcpConnectionSupport>();
    private volatile TcpSocketSupport tcpSocketSupport = new DefaultTcpSocketSupport();
    protected final Object lifecycleMonitor = new Object();
    private volatile long nextCheckForClosedNioConnections;
    private volatile int nioHarvestInterval = 2000;
    private volatile ApplicationEventPublisher applicationEventPublisher;
    private static final int DEFAULT_NIO_HARVEST_INTERVAL = 2000;

    public AbstractConnectionFactory(int port) {
        this.port = port;
    }

    public AbstractConnectionFactory(String host, int port) {
        Assert.notNull((Object)host, (String)"host must not be null");
        this.host = host;
        this.port = port;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    protected ApplicationEventPublisher getApplicationEventPublisher() {
        return this.applicationEventPublisher;
    }

    protected void setSocketAttributes(Socket socket) throws SocketException {
        if (this.soTimeout >= 0) {
            socket.setSoTimeout(this.soTimeout);
        }
        if (this.soSendBufferSize > 0) {
            socket.setSendBufferSize(this.soSendBufferSize);
        }
        if (this.soReceiveBufferSize > 0) {
            socket.setReceiveBufferSize(this.soReceiveBufferSize);
        }
        socket.setTcpNoDelay(this.soTcpNoDelay);
        if (this.soLinger >= 0) {
            socket.setSoLinger(true, this.soLinger);
        }
        if (this.soTrafficClass >= 0) {
            socket.setTrafficClass(this.soTrafficClass);
        }
        socket.setKeepAlive(this.soKeepAlive);
        this.tcpSocketSupport.postProcessSocket(socket);
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public int getSoReceiveBufferSize() {
        return this.soReceiveBufferSize;
    }

    public void setSoReceiveBufferSize(int soReceiveBufferSize) {
        this.soReceiveBufferSize = soReceiveBufferSize;
    }

    public int getSoSendBufferSize() {
        return this.soSendBufferSize;
    }

    public void setSoSendBufferSize(int soSendBufferSize) {
        this.soSendBufferSize = soSendBufferSize;
    }

    public boolean isSoTcpNoDelay() {
        return this.soTcpNoDelay;
    }

    public void setSoTcpNoDelay(boolean soTcpNoDelay) {
        this.soTcpNoDelay = soTcpNoDelay;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public void setSoLinger(int soLinger) {
        this.soLinger = soLinger;
    }

    public boolean isSoKeepAlive() {
        return this.soKeepAlive;
    }

    public void setSoKeepAlive(boolean soKeepAlive) {
        this.soKeepAlive = soKeepAlive;
    }

    public int getSoTrafficClass() {
        return this.soTrafficClass;
    }

    public void setSoTrafficClass(int soTrafficClass) {
        this.soTrafficClass = soTrafficClass;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public TcpListener getListener() {
        return this.listener;
    }

    public TcpSender getSender() {
        return this.sender;
    }

    public Serializer<?> getSerializer() {
        return this.serializer;
    }

    public Deserializer<?> getDeserializer() {
        return this.deserializer;
    }

    public TcpMessageMapper getMapper() {
        return this.mapper;
    }

    public void registerListener(TcpListener listener) {
        Assert.isNull((Object)this.listener, (String)(this.getClass().getName() + " may only be used by one inbound adapter"));
        this.listener = listener;
    }

    public void registerSender(TcpSender sender) {
        Assert.isNull((Object)this.sender, (String)(this.getClass().getName() + " may only be used by one outbound adapter"));
        this.sender = sender;
    }

    public void setTaskExecutor(Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setDeserializer(Deserializer<?> deserializer) {
        this.deserializer = deserializer;
    }

    public void setSerializer(Serializer<?> serializer) {
        this.serializer = serializer;
    }

    public void setMapper(TcpMessageMapper mapper) {
        this.mapper = mapper;
    }

    public boolean isSingleUse() {
        return this.singleUse;
    }

    public void setSingleUse(boolean singleUse) {
        this.singleUse = singleUse;
    }

    public void setInterceptorFactoryChain(TcpConnectionInterceptorFactoryChain interceptorFactoryChain) {
        this.interceptorFactoryChain = interceptorFactoryChain;
    }

    public void setLookupHost(boolean lookupHost) {
        this.lookupHost = lookupHost;
    }

    public boolean isLookupHost() {
        return this.lookupHost;
    }

    public void setNioHarvestInterval(int nioHarvestInterval) {
        Assert.isTrue((nioHarvestInterval > 0 ? 1 : 0) != 0, (String)"NIO Harvest interval must be > 0");
        this.nioHarvestInterval = nioHarvestInterval;
    }

    @Deprecated
    public abstract void close();

    public void start() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("started " + this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Executor getTaskExecutor() {
        if (!this.active) {
            throw new MessagingException("Connection Factory not started");
        }
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.taskExecutor == null) {
                this.privateExecutor = true;
                this.taskExecutor = Executors.newCachedThreadPool();
            }
            return this.taskExecutor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.active = false;
        this.close();
        Object object = this.connections;
        synchronized (object) {
            Iterator<TcpConnectionSupport> iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                TcpConnection connection = iterator.next();
                connection.close();
                iterator.remove();
            }
        }
        object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.privateExecutor) {
                ExecutorService executorService = (ExecutorService)this.taskExecutor;
                executorService.shutdown();
                try {
                    if (!executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                        this.logger.debug((Object)"Forcing executor shutdown");
                        executorService.shutdownNow();
                        if (!executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                            this.logger.debug((Object)"Executor failed to shutdown");
                        }
                    }
                }
                catch (InterruptedException e) {
                    executorService.shutdownNow();
                    Thread.currentThread().interrupt();
                }
                finally {
                    this.taskExecutor = null;
                    this.privateExecutor = false;
                }
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("stopped " + this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TcpConnectionSupport wrapConnection(TcpConnectionSupport connection) throws Exception {
        try {
            if (this.interceptorFactoryChain == null) {
                TcpConnectionSupport tcpConnectionSupport = connection;
                return tcpConnectionSupport;
            }
            TcpConnectionInterceptorFactory[] interceptorFactories = this.interceptorFactoryChain.getInterceptorFactories();
            if (interceptorFactories == null) {
                TcpConnectionSupport tcpConnectionSupport = connection;
                return tcpConnectionSupport;
            }
            for (TcpConnectionInterceptorFactory factory : interceptorFactories) {
                TcpConnectionInterceptorSupport wrapper = factory.getInterceptor();
                wrapper.setTheConnection(connection);
                if (this.listener == null) {
                    connection.registerListener(wrapper);
                }
                if (this.sender == null) {
                    connection.registerSender(wrapper);
                }
                connection = wrapper;
            }
            TcpConnectionSupport tcpConnectionSupport = connection;
            return tcpConnectionSupport;
        }
        finally {
            this.addConnection(connection);
        }
    }

    protected void processNioSelections(int selectionCount, final Selector selector, ServerSocketChannel server, Map<SocketChannel, TcpNioConnection> connections) throws IOException {
        long now = System.currentTimeMillis();
        if (this.soTimeout > 0 || now >= this.nextCheckForClosedNioConnections || selectionCount == 0) {
            this.nextCheckForClosedNioConnections = now + (long)this.nioHarvestInterval;
            Iterator<Map.Entry<SocketChannel, TcpNioConnection>> it = connections.entrySet().iterator();
            while (it.hasNext()) {
                TcpNioConnection connection;
                SocketChannel channel = it.next().getKey();
                if (!channel.isOpen()) {
                    this.logger.debug((Object)"Removing closed channel");
                    it.remove();
                    continue;
                }
                if (this.soTimeout <= 0 || now - (connection = connections.get(channel)).getLastRead() < (long)this.soTimeout) continue;
                if (!connection.isServer() && now - connection.getLastSend() < (long)this.soTimeout && now - connection.getLastRead() < (long)(this.soTimeout * 2)) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Skipping a connection timeout because we have a recent send " + connection.getConnectionId()));
                    continue;
                }
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)("Timing out TcpNioConnection " + connection.getConnectionId()));
                }
                connection.publishConnectionExceptionEvent(new SocketTimeoutException("Timing out connection"));
                connection.timeout();
            }
        }
        this.harvestClosedConnections();
        if (this.logger.isTraceEnabled()) {
            if (this.host == null) {
                this.logger.trace((Object)("Port " + this.port + " SelectionCount: " + selectionCount));
            } else {
                this.logger.trace((Object)("Host " + this.host + " port " + this.port + " SelectionCount: " + selectionCount));
            }
        }
        if (selectionCount > 0) {
            Set<SelectionKey> keys = selector.selectedKeys();
            Iterator<SelectionKey> iterator = keys.iterator();
            while (iterator.hasNext()) {
                final SelectionKey key = iterator.next();
                iterator.remove();
                try {
                    if (!key.isValid()) {
                        this.logger.debug((Object)"Selection key no longer valid");
                        continue;
                    }
                    if (key.isReadable()) {
                        key.interestOps(key.interestOps() - key.readyOps());
                        final TcpNioConnection connection = (TcpNioConnection)key.attachment();
                        connection.setLastRead(System.currentTimeMillis());
                        this.taskExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    connection.readPacket();
                                }
                                catch (Exception e) {
                                    if (connection.isOpen()) {
                                        AbstractConnectionFactory.this.logger.error((Object)("Exception on read " + connection.getConnectionId() + " " + e.getMessage()));
                                        connection.close();
                                    }
                                    AbstractConnectionFactory.this.logger.debug((Object)"Connection closed");
                                }
                                if (key.channel().isOpen()) {
                                    key.interestOps(1);
                                    selector.wakeup();
                                } else {
                                    connection.sendExceptionToListener(new EOFException("Connection is closed"));
                                }
                            }
                        });
                        continue;
                    }
                    if (key.isAcceptable()) {
                        try {
                            this.doAccept(selector, server, now);
                        }
                        catch (Exception e) {
                            this.logger.error((Object)"Exception accepting new connection", (Throwable)e);
                        }
                        continue;
                    }
                    this.logger.error((Object)("Unexpected key: " + key));
                }
                catch (CancelledKeyException e) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Selection key " + key + " cancelled"));
                }
                catch (Exception e) {
                    this.logger.error((Object)("Exception on selection key " + key), (Throwable)e);
                }
            }
        }
    }

    protected void doAccept(Selector selector, ServerSocketChannel server, long now) throws IOException {
        throw new UnsupportedOperationException("Nio server factory must override this method");
    }

    public int getPhase() {
        return 0;
    }

    public boolean isAutoStartup() {
        return false;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addConnection(TcpConnectionSupport connection) {
        List<TcpConnectionSupport> list = this.connections;
        synchronized (list) {
            if (!this.active) {
                connection.close();
                return;
            }
            this.connections.add(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> removeClosedConnectionsAndReturnOpenConnectionIds() {
        List<TcpConnectionSupport> list = this.connections;
        synchronized (list) {
            ArrayList<String> openConnectionIds = new ArrayList<String>();
            Iterator<TcpConnectionSupport> iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                TcpConnection connection = iterator.next();
                if (!connection.isOpen()) {
                    iterator.remove();
                    continue;
                }
                openConnectionIds.add(connection.getConnectionId());
            }
            return openConnectionIds;
        }
    }

    protected void harvestClosedConnections() {
        this.removeClosedConnectionsAndReturnOpenConnectionIds();
    }

    public boolean isRunning() {
        return this.active;
    }

    protected boolean isActive() {
        return this.active;
    }

    protected void setActive(boolean active) {
        this.active = active;
    }

    protected void checkActive() throws IOException {
        if (!this.isActive()) {
            throw new IOException(this + " connection factory has not been started");
        }
    }

    protected TcpSocketSupport getTcpSocketSupport() {
        return this.tcpSocketSupport;
    }

    public void setTcpSocketSupport(TcpSocketSupport tcpSocketSupport) {
        Assert.notNull((Object)tcpSocketSupport, (String)"TcpSocketSupport must not be null");
        this.tcpSocketSupport = tcpSocketSupport;
    }

    public List<String> getOpenConnectionIds() {
        return Collections.unmodifiableList(this.removeClosedConnectionsAndReturnOpenConnectionIds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeConnection(String connectionId) {
        Assert.notNull((Object)connectionId, (String)"'connectionId' to close must not be null");
        List<TcpConnectionSupport> list = this.connections;
        synchronized (list) {
            boolean closed = false;
            for (TcpConnectionSupport connection : this.connections) {
                if (!connectionId.equals(connection.getConnectionId())) continue;
                try {
                    connection.close();
                    closed = true;
                    break;
                }
                catch (Exception e) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Failed to close connection " + connectionId), (Throwable)e);
                    }
                    connection.publishConnectionExceptionEvent(e);
                }
            }
            return closed;
        }
    }
}

