/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.integration.config.IntegrationConfigurationInitializer;
import org.springframework.integration.http.inbound.IntegrationRequestMappingHandlerMapping;
import org.springframework.integration.http.support.HttpContextUtils;

public class HttpIntegrationConfigurationInitializer
implements IntegrationConfigurationInitializer {
    private static final Log logger = LogFactory.getLog(HttpIntegrationConfigurationInitializer.class);

    public void initialize(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof BeanDefinitionRegistry) {
            this.registerRequestMappingHandlerMappingIfNecessary((BeanDefinitionRegistry)beanFactory);
        } else {
            logger.warn((Object)"'IntegrationRequestMappingHandlerMapping' isn't registered because 'beanFactory' isn't an instance of `BeanDefinitionRegistry`.");
        }
    }

    private void registerRequestMappingHandlerMappingIfNecessary(BeanDefinitionRegistry registry) {
        if (HttpContextUtils.SERVLET_PRESENT && !registry.containsBeanDefinition("integrationRequestMappingHandlerMapping")) {
            BeanDefinitionBuilder requestMappingBuilder = BeanDefinitionBuilder.genericBeanDefinition(IntegrationRequestMappingHandlerMapping.class);
            requestMappingBuilder.setRole(2);
            requestMappingBuilder.addPropertyValue("order", (Object)0);
            registry.registerBeanDefinition("integrationRequestMappingHandlerMapping", (BeanDefinition)requestMappingBuilder.getBeanDefinition());
        }
    }
}

