/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.integration.http.AbstractHttpRequestExecutor;
import org.springframework.integration.http.HttpRequest;
import org.springframework.integration.http.HttpResponse;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleHttpRequestExecutor
extends AbstractHttpRequestExecutor {
    @Override
    protected HttpResponse doExecuteRequest(HttpRequest request) throws Exception {
        HttpURLConnection connection = this.openConnection(request.getTargetUrl());
        this.prepareConnection(connection, request);
        this.writeRequestBody(connection, request.getBody());
        this.validateResponse(connection);
        InputStream responseBody = this.readResponseBody(connection);
        return new AbstractHttpRequestExecutor.DefaultHttpResponse(responseBody, this.getResponseHeaders(connection));
    }

    private HttpURLConnection openConnection(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        if (!(connection instanceof HttpURLConnection)) {
            throw new IOException("target URL [" + url + "] is not an HTTP URL");
        }
        return (HttpURLConnection)connection;
    }

    private void prepareConnection(HttpURLConnection connection, HttpRequest request) throws IOException {
        LocaleContext locale;
        Integer contentLength;
        connection.setDoInput(true);
        String requestMethod = request.getRequestMethod();
        if ("PUT".equals(requestMethod) || "POST".equals(requestMethod)) {
            connection.setDoOutput(true);
        } else {
            connection.setDoOutput(false);
        }
        connection.setRequestMethod(request.getRequestMethod());
        String contentType = request.getContentType();
        if (contentType != null) {
            connection.setRequestProperty("Content-Type", contentType);
        }
        if ((contentLength = request.getContentLength()) != null) {
            connection.setRequestProperty("Content-Length", contentLength.toString());
        }
        if ((locale = LocaleContextHolder.getLocaleContext()) != null) {
            connection.setRequestProperty("Accept-Language", StringUtils.toLanguageTag((Locale)locale.getLocale()));
        }
        if (this.isAcceptGzipEncoding()) {
            connection.setRequestProperty("Accept-Encoding", "gzip");
        }
    }

    private void writeRequestBody(HttpURLConnection connection, ByteArrayOutputStream body) throws IOException {
        byte[] bytes;
        if (body != null && (bytes = body.toByteArray()).length > 0) {
            FileCopyUtils.copy((byte[])bytes, (OutputStream)connection.getOutputStream());
        }
    }

    private void validateResponse(HttpURLConnection connection) throws IOException {
        if (connection.getResponseCode() >= 300) {
            throw new IOException("Did not receive successful HTTP response: status code = " + connection.getResponseCode() + ", status message = [" + connection.getResponseMessage() + "]");
        }
    }

    private InputStream readResponseBody(HttpURLConnection connection) throws IOException {
        if (this.isGzipResponse(connection)) {
            return new GZIPInputStream(connection.getInputStream());
        }
        return connection.getInputStream();
    }

    private Map<String, List<String>> getResponseHeaders(HttpURLConnection connection) {
        return connection.getHeaderFields();
    }

    private boolean isGzipResponse(HttpURLConnection connection) {
        String encodingHeader = connection.getHeaderField("Content-Encoding");
        return encodingHeader != null && encodingHeader.toLowerCase().indexOf("gzip") != -1;
    }
}

