/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.hazelcast.inbound;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.map.AbstractIMapEvent;
import com.hazelcast.map.MapEvent;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.hazelcast.CacheEventType;
import org.springframework.integration.hazelcast.CacheListeningPolicyType;
import org.springframework.integration.hazelcast.HazelcastIntegrationDefinitionValidator;
import org.springframework.integration.hazelcast.message.EntryEventMessagePayload;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public abstract class AbstractHazelcastMessageProducer
extends MessageProducerSupport {
    protected final DistributedObject distributedObject;
    private volatile CacheListeningPolicyType cacheListeningPolicy = CacheListeningPolicyType.SINGLE;
    private volatile UUID hazelcastRegisteredEventListenerId;
    private Set<String> cacheEvents = Collections.singleton(CacheEventType.ADDED.name());

    public AbstractHazelcastMessageProducer(DistributedObject distributedObject) {
        Assert.notNull((Object)distributedObject, (String)"'distributedObject' must not be null");
        this.distributedObject = distributedObject;
    }

    protected Set<String> getCacheEvents() {
        return this.cacheEvents;
    }

    public void setCacheEventTypes(String cacheEventTypes) {
        Set<String> events = HazelcastIntegrationDefinitionValidator.validateEnumType(CacheEventType.class, cacheEventTypes);
        Assert.notEmpty(events, (String)"'events' must have elements");
        HazelcastIntegrationDefinitionValidator.validateCacheEventsByDistributedObject(this.distributedObject, events);
        this.cacheEvents = events;
    }

    protected CacheListeningPolicyType getCacheListeningPolicy() {
        return this.cacheListeningPolicy;
    }

    public void setCacheListeningPolicy(CacheListeningPolicyType cacheListeningPolicy) {
        Assert.notNull((Object)((Object)cacheListeningPolicy), (String)"'cacheListeningPolicy' must not be null");
        this.cacheListeningPolicy = cacheListeningPolicy;
    }

    protected UUID getHazelcastRegisteredEventListenerId() {
        return this.hazelcastRegisteredEventListenerId;
    }

    protected void setHazelcastRegisteredEventListenerId(UUID hazelcastRegisteredEventListenerId) {
        this.hazelcastRegisteredEventListenerId = hazelcastRegisteredEventListenerId;
    }

    protected final class HazelcastEntryListener<K, V>
    extends AbstractHazelcastEventListener<AbstractIMapEvent>
    implements EntryListener<K, V> {
        protected HazelcastEntryListener() {
        }

        public void entryAdded(EntryEvent<K, V> event) {
            this.processEvent((AbstractIMapEvent)event);
        }

        public void entryRemoved(EntryEvent<K, V> event) {
            this.processEvent((AbstractIMapEvent)event);
        }

        public void entryUpdated(EntryEvent<K, V> event) {
            this.processEvent((AbstractIMapEvent)event);
        }

        public void entryEvicted(EntryEvent<K, V> event) {
            this.processEvent((AbstractIMapEvent)event);
        }

        public void entryExpired(EntryEvent<K, V> event) {
            this.processEvent((AbstractIMapEvent)event);
        }

        public void mapEvicted(MapEvent event) {
            this.processEvent((AbstractIMapEvent)event);
        }

        public void mapCleared(MapEvent event) {
            this.processEvent((AbstractIMapEvent)event);
        }

        @Override
        protected void processEvent(AbstractIMapEvent event) {
            if (AbstractHazelcastMessageProducer.this.getCacheEvents().contains(event.getEventType().toString())) {
                if (AbstractHazelcastMessageProducer.this.logger.isDebugEnabled()) {
                    AbstractHazelcastMessageProducer.this.logger.debug((CharSequence)("Received Event : " + String.valueOf(event)));
                }
                this.sendMessage(event, event.getMember().getSocketAddress(EndpointQualifier.MEMBER), AbstractHazelcastMessageProducer.this.getCacheListeningPolicy());
            }
        }

        @Override
        protected Message<?> toMessage(AbstractIMapEvent event) {
            HashMap<String, Object> headers = new HashMap<String, Object>();
            headers.put("hazelcast_eventType", event.getEventType().name());
            headers.put("hazelcast_member", event.getMember().getSocketAddress(EndpointQualifier.MEMBER));
            headers.put("hazelcast_cacheName", event.getName());
            if (event instanceof EntryEvent) {
                EntryEvent entryEvent = (EntryEvent)event;
                EntryEventMessagePayload<Object, Object> messagePayload = new EntryEventMessagePayload<Object, Object>(entryEvent.getKey(), entryEvent.getValue(), entryEvent.getOldValue());
                return AbstractHazelcastMessageProducer.this.getMessageBuilderFactory().withPayload(messagePayload).copyHeaders(headers).build();
            }
            if (event instanceof MapEvent) {
                MapEvent mapEvent = (MapEvent)event;
                return AbstractHazelcastMessageProducer.this.getMessageBuilderFactory().withPayload((Object)mapEvent.getNumberOfEntriesAffected()).copyHeaders(headers).build();
            }
            throw new IllegalStateException("Invalid event is received. Event : " + String.valueOf(event));
        }
    }

    protected abstract class AbstractHazelcastEventListener<E> {
        protected AbstractHazelcastEventListener() {
        }

        protected abstract void processEvent(E var1);

        protected abstract Message<?> toMessage(E var1);

        protected void sendMessage(E event, InetSocketAddress socketAddress, CacheListeningPolicyType cacheListeningPolicyType) {
            if (CacheListeningPolicyType.ALL == cacheListeningPolicyType || this.isEventLocal(socketAddress)) {
                AbstractHazelcastMessageProducer.this.sendMessage(this.toMessage(event));
            }
        }

        private boolean isEventLocal(InetSocketAddress socketAddress) {
            Set hazelcastInstanceSet = Hazelcast.getAllHazelcastInstances();
            for (HazelcastInstance hazelcastInstance : hazelcastInstanceSet) {
                if (!socketAddress.equals(hazelcastInstance.getLocalEndpoint().getSocketAddress())) continue;
                return true;
            }
            return false;
        }
    }
}

