/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.hazelcast.outbound;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.multimap.MultiMap;
import com.hazelcast.topic.ITopic;
import java.util.Collection;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class HazelcastCacheWritingMessageHandler
extends AbstractMessageHandler {
    private @Nullable DistributedObject distributedObject;
    private @Nullable Expression cacheExpression;
    private @Nullable Expression keyExpression;
    private boolean extractPayload = true;
    private EvaluationContext evaluationContext;

    public void setDistributedObject(DistributedObject distributedObject) {
        Assert.notNull((Object)distributedObject, (String)"'distributedObject' must not be null");
        this.distributedObject = distributedObject;
    }

    public void setCacheExpression(Expression cacheExpression) {
        Assert.notNull((Object)cacheExpression, (String)"'cacheExpression' must not be null");
        this.cacheExpression = cacheExpression;
    }

    public void setKeyExpression(Expression keyExpression) {
        Assert.notNull((Object)keyExpression, (String)"'keyExpression' must not be null");
        this.keyExpression = keyExpression;
    }

    public void setExtractPayload(boolean extractPayload) {
        this.extractPayload = extractPayload;
    }

    protected void onInit() {
        super.onInit();
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
    }

    protected void handleMessageInternal(Message<?> message) {
        DistributedObject object;
        Object objectToStore = message;
        if (this.extractPayload) {
            objectToStore = message.getPayload();
        }
        if ((object = this.getDistributedObject(message)) instanceof Map) {
            Map map = (Map)object;
            if (objectToStore instanceof Map) {
                map.putAll((Map)objectToStore);
            } else if (objectToStore instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)objectToStore;
                map.put(entry.getKey(), entry.getValue());
            } else {
                map.put(this.getKey(message), objectToStore);
            }
        } else if (object instanceof MultiMap) {
            MultiMap map = (MultiMap)object;
            if (objectToStore instanceof Map) {
                Map mapToStore = (Map)objectToStore;
                for (Map.Entry entry : mapToStore.entrySet()) {
                    map.put(entry.getKey(), entry.getValue());
                }
            } else if (objectToStore instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)objectToStore;
                map.put(entry.getKey(), entry.getValue());
            } else {
                Object key = this.getKey(message);
                if (key != null) {
                    map.put(key, objectToStore);
                }
            }
        } else if (object instanceof ITopic) {
            ((ITopic)object).publish(objectToStore);
        } else if (object instanceof Collection) {
            if (objectToStore instanceof Collection) {
                ((Collection)object).addAll((Collection)objectToStore);
            } else {
                ((Collection)object).add(objectToStore);
            }
        } else {
            throw new IllegalStateException("The 'object' for 'HazelcastCacheWritingMessageHandler' must be of 'IMap', 'MultiMap', 'ITopic', 'ISet' or 'IList' type, but gotten: [" + String.valueOf(object) + "].");
        }
    }

    private @Nullable DistributedObject getDistributedObject(Message<?> message) {
        String beanName;
        if (this.distributedObject != null) {
            return this.distributedObject;
        }
        if (this.cacheExpression != null) {
            return (DistributedObject)this.cacheExpression.getValue(this.evaluationContext, message, DistributedObject.class);
        }
        if (message.getHeaders().containsKey((Object)"hazelcast_cacheName") && StringUtils.hasText((String)(beanName = (String)message.getHeaders().get((Object)"hazelcast_cacheName", String.class)))) {
            return (DistributedObject)this.getBeanFactory().getBean(beanName, DistributedObject.class);
        }
        throw new IllegalStateException("One of 'cache', 'cache-expression' and hazelcast_cacheName must be set for cache object definition.");
    }

    private @Nullable Object getKey(Message<?> message) {
        if (this.keyExpression != null) {
            return this.keyExpression.getValue(this.evaluationContext, message);
        }
        throw new IllegalStateException("'key-expression' must be set to place the raw 'payload' to the IMap, MultiMap and ReplicatedMap");
    }
}

