/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.gemfire.util;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import java.util.concurrent.locks.Lock;
import org.springframework.integration.support.locks.LockRegistry;
import org.springframework.util.Assert;

public class GemfireLockRegistry
implements LockRegistry {
    public static final String LOCK_REGISTRY_REGION = "LockRegistry";
    private final Region<?, ?> region;

    public GemfireLockRegistry(Cache cache) {
        Assert.notNull((Object)cache, (String)"'cache' must not be null");
        this.region = cache.createRegionFactory().setScope(Scope.GLOBAL).create(LOCK_REGISTRY_REGION);
    }

    public GemfireLockRegistry(Region<?, ?> region) {
        Assert.notNull(region, (String)"'region' must not be null");
        this.region = region;
    }

    public Lock obtain(Object lockKey) {
        return this.region.getDistributedLock(lockKey);
    }
}

