/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ftp.dsl;

import java.util.Comparator;
import org.apache.commons.net.ftp.FTPFile;
import org.jspecify.annotations.Nullable;
import org.springframework.integration.file.dsl.RemoteFileStreamingInboundChannelAdapterSpec;
import org.springframework.integration.file.filters.CompositeFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.ftp.filters.FtpPersistentAcceptOnceFileListFilter;
import org.springframework.integration.ftp.filters.FtpRegexPatternFileListFilter;
import org.springframework.integration.ftp.filters.FtpSimplePatternFileListFilter;
import org.springframework.integration.ftp.inbound.FtpStreamingMessageSource;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.integration.metadata.SimpleMetadataStore;

public class FtpStreamingInboundChannelAdapterSpec
extends RemoteFileStreamingInboundChannelAdapterSpec<FTPFile, FtpStreamingInboundChannelAdapterSpec, FtpStreamingMessageSource> {
    protected FtpStreamingInboundChannelAdapterSpec(RemoteFileTemplate<FTPFile> remoteFileTemplate, @Nullable Comparator<FTPFile> comparator) {
        this.target = new FtpStreamingMessageSource(remoteFileTemplate, comparator);
    }

    public FtpStreamingInboundChannelAdapterSpec patternFilter(String pattern) {
        return (FtpStreamingInboundChannelAdapterSpec)this.filter((FileListFilter)this.composeFilters((FileListFilter<FTPFile>)new FtpSimplePatternFileListFilter(pattern)));
    }

    public FtpStreamingInboundChannelAdapterSpec regexFilter(String regex) {
        return (FtpStreamingInboundChannelAdapterSpec)this.filter((FileListFilter)this.composeFilters((FileListFilter<FTPFile>)new FtpRegexPatternFileListFilter(regex)));
    }

    private CompositeFileListFilter<FTPFile> composeFilters(FileListFilter<FTPFile> fileListFilter) {
        CompositeFileListFilter compositeFileListFilter = new CompositeFileListFilter();
        compositeFileListFilter.addFilters(new FileListFilter[]{fileListFilter, new FtpPersistentAcceptOnceFileListFilter((ConcurrentMetadataStore)new SimpleMetadataStore(), "ftpStreamingMessageSource")});
        return compositeFileListFilter;
    }
}

