/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ftp.outbound;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.file.remote.AbstractFileInfo;
import org.springframework.integration.file.remote.ClientCallback;
import org.springframework.integration.file.remote.ClientCallbackWithoutResult;
import org.springframework.integration.file.remote.MessageSessionCallback;
import org.springframework.integration.file.remote.RemoteFileOperations;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.gateway.AbstractRemoteFileOutboundGateway;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.ftp.session.FtpFileInfo;
import org.springframework.integration.ftp.session.FtpRemoteFileTemplate;
import org.springframework.messaging.Message;

public class FtpOutboundGateway
extends AbstractRemoteFileOutboundGateway<FTPFile> {
    private @Nullable Expression workingDirExpression;
    private StandardEvaluationContext evaluationContext;

    public FtpOutboundGateway(SessionFactory<FTPFile> sessionFactory, MessageSessionCallback<FTPFile, ?> messageSessionCallback) {
        this((RemoteFileTemplate<FTPFile>)new FtpRemoteFileTemplate(sessionFactory), messageSessionCallback);
        ((FtpRemoteFileTemplate)this.getRemoteFileTemplate()).setExistsMode(FtpRemoteFileTemplate.ExistsMode.NLST);
        this.remoteFileTemplateExplicitlySet(false);
    }

    public FtpOutboundGateway(RemoteFileTemplate<FTPFile> remoteFileTemplate, MessageSessionCallback<FTPFile, ?> messageSessionCallback) {
        super(remoteFileTemplate, messageSessionCallback);
    }

    public FtpOutboundGateway(SessionFactory<FTPFile> sessionFactory, String command, @Nullable String expression) {
        this(new FtpRemoteFileTemplate(sessionFactory), command, expression);
        ((FtpRemoteFileTemplate)this.getRemoteFileTemplate()).setExistsMode(FtpRemoteFileTemplate.ExistsMode.NLST);
        this.remoteFileTemplateExplicitlySet(false);
    }

    public FtpOutboundGateway(RemoteFileTemplate<FTPFile> remoteFileTemplate, String command, @Nullable String expression) {
        super(remoteFileTemplate, command, expression);
    }

    public FtpOutboundGateway(SessionFactory<FTPFile> sessionFactory, String command) {
        this(sessionFactory, command, null);
    }

    public FtpOutboundGateway(RemoteFileTemplate<FTPFile> remoteFileTemplate, String command) {
        this(remoteFileTemplate, command, null);
    }

    public void setWorkingDirExpression(Expression workingDirExpression) {
        this.workingDirExpression = workingDirExpression;
    }

    public void setWorkingDirExpressionString(String workingDirExpression) {
        this.setWorkingDirExpression(EXPRESSION_PARSER.parseExpression(workingDirExpression));
    }

    public String getComponentType() {
        return "ftp:outbound-gateway";
    }

    protected boolean isDirectory(FTPFile file) {
        return file.isDirectory();
    }

    protected boolean isLink(FTPFile file) {
        return file.isSymbolicLink();
    }

    protected String getFilename(FTPFile file) {
        return file.getName();
    }

    protected String getFilename(AbstractFileInfo<FTPFile> file) {
        return file.getFilename();
    }

    protected long getModified(FTPFile file) {
        return file.getTimestamp().getTimeInMillis();
    }

    protected List<AbstractFileInfo<FTPFile>> asFileInfoList(Collection<FTPFile> files) {
        ArrayList<AbstractFileInfo<FTPFile>> canonicalFiles = new ArrayList<AbstractFileInfo<FTPFile>>(files.size());
        for (FTPFile file : files) {
            canonicalFiles.add(new FtpFileInfo(file));
        }
        return canonicalFiles;
    }

    protected void doInit() {
        super.doInit();
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
    }

    protected FTPFile enhanceNameWithSubDirectory(FTPFile file, String directory) {
        file.setName(directory + file.getName());
        return file;
    }

    protected List<?> ls(Message<?> message, Session<FTPFile> session, @Nullable String dir) throws IOException {
        return this.doInWorkingDirectory(message, session, () -> super.ls(message, session, dir));
    }

    protected List<String> nlst(Message<?> message, Session<FTPFile> session, @Nullable String dir) throws IOException {
        return this.doInWorkingDirectory(message, session, () -> super.nlst(message, session, dir));
    }

    protected File get(Message<?> message, Session<FTPFile> session, @Nullable String remoteDir, String remoteFilePath, String remoteFilename, @Nullable FTPFile fileInfoParam) throws IOException {
        return this.doInWorkingDirectory(message, session, () -> super.get(message, session, remoteDir, remoteFilePath, remoteFilename, (Object)fileInfoParam));
    }

    protected List<File> mGet(Message<?> message, Session<FTPFile> session, String remoteDirectory, String remoteFilename) throws IOException {
        return this.doInWorkingDirectory(message, session, () -> super.mGet(message, session, remoteDirectory, remoteFilename));
    }

    protected boolean rm(Message<?> message, Session<FTPFile> session, String remoteFilePath) throws IOException {
        return this.doInWorkingDirectory(message, session, () -> super.rm(message, session, remoteFilePath));
    }

    protected boolean mv(Message<?> message, Session<FTPFile> session, String remoteFilePath, String remoteFileNewPath) throws IOException {
        return this.doInWorkingDirectory(message, session, () -> super.mv(message, session, remoteFilePath, remoteFileNewPath));
    }

    protected String put(Message<?> message, Session<FTPFile> session, @Nullable String subDirectory) {
        try {
            return this.doInWorkingDirectory(message, session, () -> super.put(message, session, subDirectory));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected List<String> mPut(Message<?> message, Session<FTPFile> session, File localDir) {
        try {
            return this.doInWorkingDirectory(message, session, () -> super.mPut(message, session, localDir));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private <V> V doInWorkingDirectory(Message<?> message, Session<FTPFile> session, Callable<V> task) throws IOException {
        Expression workDirExpression = this.workingDirExpression;
        FTPClient ftpClient = (FTPClient)session.getClientInstance();
        String currentWorkingDirectory = null;
        boolean restoreWorkingDirectory = false;
        try {
            Object newWorkingDirectory;
            if (workDirExpression != null && !Objects.equals(currentWorkingDirectory = ftpClient.printWorkingDirectory(), newWorkingDirectory = (String)workDirExpression.getValue((EvaluationContext)this.evaluationContext, message, String.class))) {
                ftpClient.changeWorkingDirectory(newWorkingDirectory);
                restoreWorkingDirectory = true;
            }
            newWorkingDirectory = task.call();
            return newWorkingDirectory;
        }
        catch (Exception ex) {
            throw this.rethrowAsIoExceptionIfAny(ex);
        }
        finally {
            if (restoreWorkingDirectory) {
                ftpClient.changeWorkingDirectory(currentWorkingDirectory);
            }
        }
    }

    private IOException rethrowAsIoExceptionIfAny(Exception ex) {
        if (ex instanceof IOException) {
            return (IOException)ex;
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        return new IOException("Uncategorized IO exception", ex);
    }

    public boolean isChmodCapable() {
        return true;
    }

    protected void doChmod(RemoteFileOperations<FTPFile> remoteFileOperations, String path, int chmod) {
        remoteFileOperations.executeWithClient((ClientCallback)((ClientCallbackWithoutResult)client -> {
            String chModCommand = "chmod " + Integer.toOctalString(chmod) + " " + path;
            try {
                client.sendSiteCommand(chModCommand);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to execute '" + chModCommand + "'", e);
            }
        }));
    }
}

