/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ftp.outbound;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.commons.net.ftp.FTPFile;
import org.springframework.integration.file.remote.ClientCallback;
import org.springframework.integration.file.remote.ClientCallbackWithoutResult;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.handler.FileTransferringMessageHandler;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.support.FileExistsMode;
import org.springframework.integration.ftp.session.FtpRemoteFileTemplate;

public class FtpMessageHandler
extends FileTransferringMessageHandler<FTPFile> {
    public FtpMessageHandler(SessionFactory<FTPFile> sessionFactory) {
        this(new FtpRemoteFileTemplate(sessionFactory));
        ((FtpRemoteFileTemplate)this.remoteFileTemplate).setExistsMode(FtpRemoteFileTemplate.ExistsMode.NLST);
    }

    public FtpMessageHandler(FtpRemoteFileTemplate remoteFileTemplate) {
        super((RemoteFileTemplate)remoteFileTemplate);
    }

    public FtpMessageHandler(FtpRemoteFileTemplate ftpRemoteFileTemplate, FileExistsMode mode) {
        super((RemoteFileTemplate)ftpRemoteFileTemplate, mode);
    }

    public boolean isChmodCapable() {
        return true;
    }

    protected void doChmod(RemoteFileTemplate<FTPFile> remoteFileTemplate, String path, int chmod) {
        remoteFileTemplate.executeWithClient((ClientCallback)((ClientCallbackWithoutResult)client -> {
            String chModCommand = "chmod " + Integer.toOctalString(chmod) + " " + path;
            try {
                client.sendSiteCommand(chModCommand);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to execute '" + chModCommand + "'", e);
            }
        }));
    }
}

