/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ftp.session;

import java.io.IOException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.springframework.integration.file.remote.ClientCallback;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.SessionCallback;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.messaging.MessagingException;

public class FtpRemoteFileTemplate
extends RemoteFileTemplate<FTPFile> {
    public FtpRemoteFileTemplate(SessionFactory<FTPFile> sessionFactory) {
        super(sessionFactory);
    }

    public <T, C> T executeWithClient(ClientCallback<C, T> callback) {
        return this.doExecuteWithClient(callback);
    }

    protected <T> T doExecuteWithClient(final ClientCallback<FTPClient, T> callback) {
        return (T)this.execute(new SessionCallback<FTPFile, T>(){

            public T doInSession(Session<FTPFile> session) throws IOException {
                return callback.doWithClient((Object)((FTPClient)session.getClientInstance()));
            }
        });
    }

    public boolean exists(final String path) {
        return this.executeWithClient(new ClientCallback<FTPClient, Boolean>(){

            public Boolean doWithClient(FTPClient client) {
                try {
                    return client.getStatus(path) != null;
                }
                catch (IOException e) {
                    throw new MessagingException("Failed to stat " + path, (Throwable)e);
                }
            }
        });
    }
}

