/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ftp.session;

import java.io.IOException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.apache.commons.net.ftp.FTPSClient;
import org.springframework.integration.ftp.session.AbstractFtpSessionFactory;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFtpsSessionFactory
extends AbstractFtpSessionFactory<FTPSClient> {
    private Boolean useClientMode;
    private Boolean sessionCreation;
    private String authValue;
    private TrustManager trustManager;
    private String[] cipherSuites;
    private String[] protocols;
    private KeyManager keyManager;
    private Boolean needClientAuth;
    private Boolean wantsClientAuth;
    private boolean implicit = false;
    private String prot = "P";
    private String protocol;

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setUseClientMode(Boolean useClientMode) {
        this.useClientMode = useClientMode;
    }

    public void setSessionCreation(Boolean sessionCreation) {
        this.sessionCreation = sessionCreation;
    }

    public void setAuthValue(String authValue) {
        this.authValue = authValue;
    }

    public void setTrustManager(TrustManager trustManager) {
        this.trustManager = trustManager;
    }

    public void setCipherSuites(String[] cipherSuites) {
        this.cipherSuites = cipherSuites;
    }

    public void setProtocols(String[] protocols) {
        this.protocols = protocols;
    }

    public void setKeyManager(KeyManager keyManager) {
        this.keyManager = keyManager;
    }

    public void setNeedClientAuth(Boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public void setWantsClientAuth(Boolean wantsClientAuth) {
        this.wantsClientAuth = wantsClientAuth;
    }

    public void setProt(String prot) {
        this.prot = prot;
    }

    public void setImplicit(boolean implicit) {
        this.implicit = implicit;
    }

    @Override
    protected FTPSClient createClientInstance() {
        try {
            if (StringUtils.hasText((String)this.protocol)) {
                return new FTPSClient(this.protocol, this.implicit);
            }
            return new FTPSClient(this.implicit);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Failed to create FTPS client.", e);
        }
    }

    @Override
    protected void postProcessClientAfterConnect(FTPSClient ftpsClient) throws IOException {
        ftpsClient.execPBSZ(0L);
        ftpsClient.execPROT(this.prot);
    }

    @Override
    protected void postProcessClientBeforeConnect(FTPSClient ftpsClient) throws IOException {
        if (StringUtils.hasText((String)this.authValue)) {
            ftpsClient.setAuthValue(this.authValue);
        }
        if (this.trustManager != null) {
            ftpsClient.setTrustManager(this.trustManager);
        }
        if (this.cipherSuites != null) {
            ftpsClient.setEnabledCipherSuites(this.cipherSuites);
        }
        if (this.protocols != null) {
            ftpsClient.setEnabledProtocols(this.protocols);
        }
        if (this.sessionCreation != null) {
            ftpsClient.setEnabledSessionCreation(this.sessionCreation.booleanValue());
        }
        if (this.useClientMode != null) {
            ftpsClient.setUseClientMode(this.useClientMode.booleanValue());
        }
        if (this.sessionCreation != null) {
            ftpsClient.setEnabledSessionCreation(this.sessionCreation.booleanValue());
        }
        if (this.keyManager != null) {
            ftpsClient.setKeyManager(this.keyManager);
        }
        if (this.needClientAuth != null) {
            ftpsClient.setNeedClientAuth(this.needClientAuth.booleanValue());
        }
        if (this.wantsClientAuth != null) {
            ftpsClient.setWantClientAuth(this.wantsClientAuth.booleanValue());
        }
    }
}

