/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.flow.handler;

import java.util.Collections;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.IntegrationMessageHeaderAccessor;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.support.ErrorMessage;

public class FlowMessageHandler
extends AbstractReplyProducingMessageHandler {
    private static Log log = LogFactory.getLog(FlowMessageHandler.class);
    private final MessageChannel flowInputChannel;
    private final SubscribableChannel flowOutputChannel;
    private volatile MessageChannel errorChannel;
    private final long timeout;

    public FlowMessageHandler(MessageChannel flowInputChannel, SubscribableChannel flowOutputChannel, long timeout) {
        this.flowInputChannel = flowInputChannel;
        this.flowOutputChannel = flowOutputChannel;
        this.timeout = timeout;
    }

    public void setErrorChannel(MessageChannel errorChannel) {
        this.errorChannel = errorChannel;
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        UUID conversationId = requestMessage.getHeaders().getId();
        Message message = MessageBuilder.fromMessage(requestMessage).pushSequenceDetails((Object)conversationId, 0, 0).build();
        try {
            ResponseMessageHandler responseMessageHandler = new ResponseMessageHandler(conversationId);
            this.flowOutputChannel.subscribe((MessageHandler)responseMessageHandler);
            this.flowInputChannel.send(message, this.timeout);
            this.flowOutputChannel.unsubscribe((MessageHandler)responseMessageHandler);
            return responseMessageHandler.getResponse();
        }
        catch (MessagingException me) {
            log.error((Object)me.getMessage(), (Throwable)me);
            if (conversationId.equals(new IntegrationMessageHeaderAccessor(me.getFailedMessage()).getCorrelationId())) {
                if (this.errorChannel != null) {
                    this.errorChannel.send((Message)new ErrorMessage((Throwable)me, Collections.singletonMap("flow.output.port", "flowhandler.exception")));
                }
            } else {
                throw me;
            }
            return null;
        }
    }

    private static class ResponseMessageHandler
    implements MessageHandler {
        private final UUID conversationId;
        private volatile Message<?> response;

        public ResponseMessageHandler(UUID conversationId) {
            this.conversationId = conversationId;
        }

        public void handleMessage(Message<?> message) throws MessagingException {
            MessagingException me;
            Object correlationId = new IntegrationMessageHeaderAccessor(message).getCorrelationId();
            if (log.isDebugEnabled()) {
                log.debug((Object)("handling flow response message with conversation Id " + correlationId + ". Target conversation Id = " + this.conversationId + " match = " + this.conversationId.equals(correlationId)));
            }
            if (this.conversationId.equals(correlationId)) {
                this.response = MessageBuilder.fromMessage(message).popSequenceDetails().build();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("set flow response message " + this.response));
                }
            } else if (message instanceof ErrorMessage && this.conversationId.equals(new IntegrationMessageHeaderAccessor((me = (MessagingException)message.getPayload()).getFailedMessage()).getCorrelationId())) {
                this.response = message;
            }
        }

        public Message<?> getResponse() {
            return this.response;
        }
    }
}

