/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.flow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.integration.flow.PortConfiguration;
import org.springframework.integration.flow.PortMetadata;

public class ChannelNamePortConfiguration
implements PortConfiguration {
    private PortMetadata inputPortMetadata;
    private List<PortMetadata> outputPortMetadataList;

    public ChannelNamePortConfiguration(PortMetadata inputPortMetadata, List<PortMetadata> outputPortMetadataList) {
        this.outputPortMetadataList = outputPortMetadataList;
        this.inputPortMetadata = inputPortMetadata;
    }

    public ChannelNamePortConfiguration(String inputChannelName, String outputChannelName) {
        this.inputPortMetadata = new PortMetadata("input", inputChannelName);
        if (outputChannelName != null) {
            PortMetadata outputPortMetadata = new PortMetadata("output", outputChannelName);
            this.outputPortMetadataList = Collections.singletonList(outputPortMetadata);
        }
    }

    @Override
    public String getInputPortName() {
        return this.inputPortMetadata.getPortName();
    }

    @Override
    public String getInputChannel() {
        return this.inputPortMetadata.getChannelName();
    }

    @Override
    public String getOutputChannel(String portName) {
        PortMetadata portMetadata = this.findOutputPort(portName);
        if (portMetadata != null) {
            return portMetadata.getChannelName();
        }
        return null;
    }

    public List<String> getOutputPortNames() {
        ArrayList<String> results = new ArrayList<String>();
        if (this.outputPortMetadataList != null) {
            for (PortMetadata portMetadata : this.outputPortMetadataList) {
                results.add(portMetadata.getPortName());
            }
        }
        return results;
    }

    private PortMetadata findOutputPort(String portName) {
        if (this.outputPortMetadataList != null) {
            for (PortMetadata portMetadata : this.outputPortMetadataList) {
                if (!portName.equals(portMetadata.getPortName())) continue;
                return portMetadata;
            }
        }
        return null;
    }
}

