/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.locking;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jspecify.annotations.Nullable;

final class FileChannelCache {
    private static final ConcurrentMap<File, FileChannel> CHANNEL_CACHE = new ConcurrentHashMap<File, FileChannel>();

    private FileChannelCache() {
    }

    public static @Nullable FileLock tryLockFor(File fileToLock) throws IOException {
        FileChannel channel = (FileChannel)CHANNEL_CACHE.get(fileToLock);
        if (channel == null && fileToLock.exists()) {
            FileChannel newChannel = new RandomAccessFile(fileToLock, "rw").getChannel();
            FileChannel original = CHANNEL_CACHE.putIfAbsent(fileToLock, newChannel);
            if (original != null) {
                channel = original;
                try {
                    newChannel.close();
                }
                catch (IOException iOException) {}
            } else {
                channel = newChannel;
            }
        }
        FileLock lock = null;
        if (channel != null) {
            try {
                lock = channel.tryLock();
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
                // empty catch block
            }
        }
        return lock;
    }

    public static void closeChannelFor(File fileToUnlock) {
        FileChannel fileChannel = (FileChannel)CHANNEL_CACHE.remove(fileToUnlock);
        if (fileChannel != null) {
            try {
                fileChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean isLocked(File file) {
        return CHANNEL_CACHE.containsKey(file);
    }
}

