/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.config;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.integration.file.DirectoryScanner;
import org.springframework.integration.file.config.FileListFilterFactoryBean;
import org.springframework.integration.file.filters.CompositeFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.inbound.FileReadingMessageSource;
import org.springframework.integration.file.locking.AbstractFileLockerFilter;
import org.springframework.util.Assert;

public class FileReadingMessageSourceFactoryBean
extends AbstractFactoryBean<FileReadingMessageSource>
implements BeanNameAware {
    private FileReadingMessageSource source;
    private @Nullable File directory;
    private @Nullable FileListFilter<File> filter;
    private @Nullable AbstractFileLockerFilter locker;
    private @Nullable Comparator<File> comparator;
    private @Nullable DirectoryScanner scanner;
    private boolean useWatchService;
    private FileReadingMessageSource.WatchEventType @Nullable [] watchEvents;
    private @Nullable Boolean scanEachPoll;
    private @Nullable Boolean autoCreateDirectory;
    private @Nullable Integer queueSize;
    private String name;

    public void setBeanName(String name) {
        this.name = name;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public void setComparator(Comparator<File> comparator) {
        this.comparator = comparator;
    }

    public void setScanner(DirectoryScanner scanner) {
        this.scanner = scanner;
    }

    public void setUseWatchService(boolean useWatchService) {
        this.useWatchService = useWatchService;
    }

    public void setWatchEvents(FileReadingMessageSource.WatchEventType ... watchEvents) {
        Assert.notEmpty((Object[])watchEvents, (String)"at least one watch event type is required");
        this.watchEvents = Arrays.copyOf(watchEvents, watchEvents.length);
    }

    public void setFilter(FileListFilter<File> filter) {
        if (filter instanceof AbstractFileLockerFilter && this.locker == null) {
            this.setLocker((AbstractFileLockerFilter)filter);
        }
        this.filter = filter;
    }

    public void setScanEachPoll(Boolean scanEachPoll) {
        this.scanEachPoll = scanEachPoll;
    }

    public void setAutoCreateDirectory(Boolean autoCreateDirectory) {
        this.autoCreateDirectory = autoCreateDirectory;
    }

    public void setQueueSize(Integer queueSize) {
        this.queueSize = queueSize;
    }

    public void setLocker(AbstractFileLockerFilter locker) {
        this.locker = locker;
    }

    public Class<?> getObjectType() {
        return FileReadingMessageSource.class;
    }

    protected FileReadingMessageSource createInstance() {
        if (this.source == null) {
            this.initSource();
        }
        return this.source;
    }

    private void initSource() {
        BeanFactory beanFactory;
        if (this.comparator != null) {
            if (this.queueSize != null) {
                this.logger.warn((Object)"'comparator' and 'queueSize' are mutually exclusive. Ignoring 'queueSize'");
            }
            this.source = new FileReadingMessageSource(this.comparator);
        } else {
            this.source = this.queueSize != null ? new FileReadingMessageSource(this.queueSize) : new FileReadingMessageSource();
        }
        Assert.notNull((Object)this.directory, (String)"The 'directory' must be provided.");
        this.source.setDirectory(this.directory);
        if (this.scanner != null) {
            this.source.setScanner(this.scanner);
        } else {
            this.source.setUseWatchService(this.useWatchService);
            if (this.watchEvents != null) {
                this.source.setWatchEvents(this.watchEvents);
            }
        }
        this.configureFilterAndLockerOnSourceIfAny();
        if (this.scanEachPoll != null) {
            this.source.setScanEachPoll(this.scanEachPoll);
        }
        if (this.autoCreateDirectory != null) {
            this.source.setAutoCreateDirectory(this.autoCreateDirectory);
        }
        if ((beanFactory = this.getBeanFactory()) != null) {
            this.source.setBeanFactory(beanFactory);
        }
        this.source.setBeanName(this.name);
        this.source.afterPropertiesSet();
    }

    private void configureFilterAndLockerOnSourceIfAny() {
        if (this.filter != null) {
            if (this.locker == null) {
                this.source.setFilter(this.filter);
            } else {
                CompositeFileListFilter<File> compositeFileListFilter = new CompositeFileListFilter<File>();
                compositeFileListFilter.addFilter(this.filter);
                compositeFileListFilter.addFilter(this.locker);
                this.source.setFilter(compositeFileListFilter);
                this.source.setLocker(this.locker);
            }
        } else if (this.locker != null) {
            CompositeFileListFilter<File> compositeFileListFilter = new CompositeFileListFilter<File>();
            compositeFileListFilter.addFilter((FileListFilter<File>)new FileListFilterFactoryBean().getObject());
            compositeFileListFilter.addFilter(this.locker);
            this.source.setFilter(compositeFileListFilter);
            this.source.setLocker(this.locker);
        }
    }
}

