/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.config;

import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractPollingInboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.file.config.FileListFilterFactoryBean;
import org.springframework.integration.file.config.FileReadingMessageSourceFactoryBean;
import org.springframework.integration.file.filters.ExpressionFileListFilter;
import org.springframework.integration.file.locking.NioFileLocker;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class FileInboundChannelAdapterParser
extends AbstractPollingInboundChannelAdapterParser {
    protected BeanMetadataElement parseSource(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(FileReadingMessageSourceFactoryBean.class);
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"comparator");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"scanner");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"use-watch-service");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"watch-events");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"directory");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"auto-create-directory");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"queue-size");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"scan-each-poll");
        String filterBeanName = this.registerFilter(element, parserContext);
        String lockerBeanName = this.registerLocker(element, parserContext);
        if (filterBeanName != null) {
            builder.addPropertyReference("filter", filterBeanName);
        }
        if (lockerBeanName != null) {
            builder.addPropertyReference("locker", lockerBeanName);
        }
        return builder.getBeanDefinition();
    }

    private @Nullable String registerLocker(Element element, ParserContext parserContext) {
        String lockerBeanName = null;
        Element nioLocker = DomUtils.getChildElementByTagName((Element)element, (String)"nio-locker");
        if (nioLocker != null) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(NioFileLocker.class);
            lockerBeanName = BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)builder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
        } else {
            Element locker = DomUtils.getChildElementByTagName((Element)element, (String)"locker");
            if (locker != null) {
                lockerBeanName = locker.getAttribute("ref");
            }
        }
        return lockerBeanName;
    }

    private @Nullable String registerFilter(Element element, ParserContext parserContext) {
        String filenamePattern = element.getAttribute("filename-pattern");
        String filenameRegex = element.getAttribute("filename-regex");
        String preventDuplicates = element.getAttribute("prevent-duplicates");
        String ignoreHidden = element.getAttribute("ignore-hidden");
        String filter = element.getAttribute("filter");
        String filterExpression = element.getAttribute("filter-expression");
        if (!(StringUtils.hasText((String)filter) || StringUtils.hasText((String)filenamePattern) || StringUtils.hasText((String)filenameRegex) || StringUtils.hasText((String)preventDuplicates) || StringUtils.hasText((String)ignoreHidden) || StringUtils.hasText((String)filterExpression))) {
            return null;
        }
        BeanDefinitionBuilder factoryBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(FileListFilterFactoryBean.class);
        factoryBeanBuilder.setRole(1);
        if (StringUtils.hasText((String)filter)) {
            factoryBeanBuilder.addPropertyReference("filter", filter);
        }
        if (StringUtils.hasText((String)filterExpression)) {
            if (StringUtils.hasText((String)filter)) {
                parserContext.getReaderContext().error("At most one of 'filter' or 'filter-expression' can be provided.", (Object)element);
            }
            AbstractBeanDefinition expressionFilterBeanDefinition = BeanDefinitionBuilder.genericBeanDefinition(ExpressionFileListFilter.class).addConstructorArgValue((Object)filterExpression).getBeanDefinition();
            factoryBeanBuilder.addPropertyValue("filter", (Object)expressionFilterBeanDefinition);
        }
        if (StringUtils.hasText((String)filenamePattern)) {
            if (StringUtils.hasText((String)filter)) {
                parserContext.getReaderContext().error("At most one of 'filter' and 'filename-pattern' may be provided.", (Object)element);
            }
            factoryBeanBuilder.addPropertyValue("filenamePattern", (Object)filenamePattern);
        }
        if (StringUtils.hasText((String)filenameRegex)) {
            if (StringUtils.hasText((String)filter)) {
                parserContext.getReaderContext().error("At most one of 'filter' and 'filename-regex' may be provided.", (Object)element);
            }
            factoryBeanBuilder.addPropertyValue("filenameRegex", (Object)filenameRegex);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)factoryBeanBuilder, (Element)element, (String)"prevent-duplicates");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)factoryBeanBuilder, (Element)element, (String)"ignore-hidden");
        return BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)factoryBeanBuilder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
    }
}

