/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.aggregator;

import java.util.function.BiFunction;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.integration.aggregator.CorrelationStrategy;
import org.springframework.integration.aggregator.GroupConditionProvider;
import org.springframework.integration.aggregator.HeaderAttributeCorrelationStrategy;
import org.springframework.integration.aggregator.MessageGroupProcessor;
import org.springframework.integration.aggregator.ReleaseStrategy;
import org.springframework.integration.file.aggregator.FileAggregatingMessageGroupProcessor;
import org.springframework.integration.file.aggregator.FileMarkerReleaseStrategy;
import org.springframework.integration.store.MessageGroup;
import org.springframework.messaging.Message;

public class FileAggregator
implements CorrelationStrategy,
ReleaseStrategy,
GroupConditionProvider,
MessageGroupProcessor,
BeanFactoryAware {
    private final CorrelationStrategy correlationStrategy = new HeaderAttributeCorrelationStrategy("file_name");
    private final FileMarkerReleaseStrategy releaseStrategy = new FileMarkerReleaseStrategy();
    private final FileAggregatingMessageGroupProcessor groupProcessor = new FileAggregatingMessageGroupProcessor();

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.groupProcessor.setBeanFactory(beanFactory);
    }

    public @Nullable Object getCorrelationKey(Message<?> message) {
        return this.correlationStrategy.getCorrelationKey(message);
    }

    public boolean canRelease(MessageGroup group) {
        return this.releaseStrategy.canRelease(group);
    }

    public BiFunction<Message<?>, String, String> getGroupConditionSupplier() {
        return this.releaseStrategy.getGroupConditionSupplier();
    }

    public Object processMessageGroup(MessageGroup group) {
        return this.groupProcessor.processMessageGroup(group);
    }
}

