/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.remote.session;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jspecify.annotations.Nullable;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.remote.session.SessionFactoryLocator;

public class DefaultSessionFactoryLocator<F>
implements SessionFactoryLocator<F> {
    private final Map<Object, SessionFactory<F>> factories = new ConcurrentHashMap<Object, SessionFactory<F>>();
    private final @Nullable SessionFactory<F> defaultFactory;

    public DefaultSessionFactoryLocator(Map<Object, SessionFactory<F>> factories) {
        this(factories, null);
    }

    public DefaultSessionFactoryLocator(Map<Object, SessionFactory<F>> factories, @Nullable SessionFactory<F> defaultFactory) {
        this.factories.putAll(factories);
        this.defaultFactory = defaultFactory;
    }

    public void addSessionFactory(Object key, SessionFactory<F> factory) {
        this.factories.put(key, factory);
    }

    public @Nullable SessionFactory<F> removeSessionFactory(Object key) {
        return this.factories.remove(key);
    }

    @Override
    public @Nullable SessionFactory<F> getSessionFactory(@Nullable Object key) {
        if (key == null) {
            return this.defaultFactory;
        }
        SessionFactory<F> sessionFactoryToReturn = this.factories.get(key);
        return sessionFactoryToReturn == null ? this.defaultFactory : sessionFactoryToReturn;
    }
}

