/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.dsl;

import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.expression.Expression;
import org.springframework.integration.dsl.ComponentsRegistration;
import org.springframework.integration.dsl.MessageSourceSpec;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.expression.SupplierExpression;
import org.springframework.integration.file.DirectoryScanner;
import org.springframework.integration.file.FileLocker;
import org.springframework.integration.file.RecursiveDirectoryScanner;
import org.springframework.integration.file.config.FileListFilterFactoryBean;
import org.springframework.integration.file.filters.ExpressionFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.inbound.FileReadingMessageSource;
import org.springframework.integration.file.locking.NioFileLocker;
import org.springframework.util.Assert;

public class FileInboundChannelAdapterSpec
extends MessageSourceSpec<FileInboundChannelAdapterSpec, FileReadingMessageSource>
implements ComponentsRegistration {
    protected final FileListFilterFactoryBean fileListFilterFactoryBean = new FileListFilterFactoryBean();
    private @Nullable FileLocker locker;
    private @Nullable ExpressionFileListFilter<File> expressionFileListFilter;
    private @Nullable DirectoryScanner scanner;
    private boolean filtersSet;

    protected FileInboundChannelAdapterSpec() {
        this.target = new FileReadingMessageSource();
    }

    protected FileInboundChannelAdapterSpec(@Nullable Comparator<File> receptionOrderComparator) {
        this.target = new FileReadingMessageSource(receptionOrderComparator);
    }

    FileInboundChannelAdapterSpec directory(Supplier<File> directorySupplier) {
        ((FileReadingMessageSource)((Object)this.target)).setDirectoryExpression((Expression)new SupplierExpression(directorySupplier));
        return (FileInboundChannelAdapterSpec)this._this();
    }

    public FileInboundChannelAdapterSpec recursive(boolean recursive) {
        if (recursive) {
            new DirectFieldAccessor(this.target).setPropertyValue("scanner", (Object)new RecursiveDirectoryScanner());
        }
        return (FileInboundChannelAdapterSpec)this._this();
    }

    public FileInboundChannelAdapterSpec scanner(DirectoryScanner scanner) {
        this.scanner = scanner;
        ((FileReadingMessageSource)((Object)this.target)).setScanner(scanner);
        return (FileInboundChannelAdapterSpec)this._this();
    }

    public FileInboundChannelAdapterSpec autoCreateDirectory(boolean autoCreateDirectory) {
        ((FileReadingMessageSource)((Object)this.target)).setAutoCreateDirectory(autoCreateDirectory);
        return (FileInboundChannelAdapterSpec)this._this();
    }

    public FileInboundChannelAdapterSpec filter(FileListFilter<File> filter) {
        this.fileListFilterFactoryBean.setFilter(filter);
        this.filtersSet = true;
        return (FileInboundChannelAdapterSpec)this._this();
    }

    public FileInboundChannelAdapterSpec filterExpression(String expression) {
        this.expressionFileListFilter = new ExpressionFileListFilter(expression);
        return this.filter(this.expressionFileListFilter);
    }

    public FileInboundChannelAdapterSpec filterFunction(Function<File, Boolean> filterFunction) {
        this.expressionFileListFilter = new ExpressionFileListFilter((Expression)new FunctionExpression(filterFunction));
        return this.filter(this.expressionFileListFilter);
    }

    public FileInboundChannelAdapterSpec preventDuplicates(boolean preventDuplicates) {
        this.fileListFilterFactoryBean.setPreventDuplicates(preventDuplicates);
        this.filtersSet = true;
        return (FileInboundChannelAdapterSpec)this._this();
    }

    public FileInboundChannelAdapterSpec ignoreHidden(boolean ignoreHidden) {
        this.fileListFilterFactoryBean.setIgnoreHidden(ignoreHidden);
        this.filtersSet = true;
        return (FileInboundChannelAdapterSpec)this._this();
    }

    public FileInboundChannelAdapterSpec patternFilter(String pattern) {
        this.fileListFilterFactoryBean.setFilenamePattern(pattern);
        this.filtersSet = true;
        return (FileInboundChannelAdapterSpec)this._this();
    }

    public FileInboundChannelAdapterSpec regexFilter(String regex) {
        this.fileListFilterFactoryBean.setFilenameRegex(regex);
        this.filtersSet = true;
        return (FileInboundChannelAdapterSpec)this._this();
    }

    public FileInboundChannelAdapterSpec locker(FileLocker locker) {
        Assert.isNull((Object)this.locker, () -> "The 'locker' (" + String.valueOf(this.locker) + ") is already configured for the FileReadingMessageSource");
        this.locker = locker;
        ((FileReadingMessageSource)((Object)this.target)).setLocker(locker);
        this.filtersSet = true;
        return (FileInboundChannelAdapterSpec)this._this();
    }

    public FileInboundChannelAdapterSpec nioLocker() {
        return this.locker(new NioFileLocker());
    }

    public FileInboundChannelAdapterSpec scanEachPoll(boolean scanEachPoll) {
        ((FileReadingMessageSource)((Object)this.target)).setScanEachPoll(scanEachPoll);
        return (FileInboundChannelAdapterSpec)this._this();
    }

    public FileInboundChannelAdapterSpec useWatchService(boolean useWatchService) {
        ((FileReadingMessageSource)((Object)this.target)).setUseWatchService(useWatchService);
        return this;
    }

    public FileInboundChannelAdapterSpec watchEvents(FileReadingMessageSource.WatchEventType ... watchEvents) {
        ((FileReadingMessageSource)((Object)this.target)).setWatchEvents(watchEvents);
        return this;
    }

    public FileInboundChannelAdapterSpec watchMaxDepth(int watchMaxDepth) {
        ((FileReadingMessageSource)((Object)this.target)).setWatchMaxDepth(watchMaxDepth);
        return this;
    }

    public FileInboundChannelAdapterSpec watchDirPredicate(Predicate<Path> watchDirPredicate) {
        ((FileReadingMessageSource)((Object)this.target)).setWatchDirPredicate(watchDirPredicate);
        return this;
    }

    public Map<Object, @Nullable String> getComponentsToRegister() {
        if (this.scanner == null || this.filtersSet) {
            ((FileReadingMessageSource)((Object)this.target)).setFilter((FileListFilter<File>)this.fileListFilterFactoryBean.getObject());
        }
        if (this.expressionFileListFilter != null) {
            return Collections.singletonMap(this.expressionFileListFilter, null);
        }
        return Collections.emptyMap();
    }
}

