/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.remote.session;

import java.util.Map;
import org.springframework.integration.file.remote.session.DefaultSessionFactoryLocator;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.remote.session.SessionFactoryLocator;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class DelegatingSessionFactory<F>
implements SessionFactory<F> {
    private final SessionFactoryLocator<F> factoryLocator;
    private final ThreadLocal<Object> threadKey = new ThreadLocal();

    public DelegatingSessionFactory(Map<Object, SessionFactory<F>> factories, SessionFactory<F> defaultFactory) {
        this(new DefaultSessionFactoryLocator<F>(factories, defaultFactory));
    }

    public DelegatingSessionFactory(SessionFactoryLocator<F> factoryLocator) {
        Assert.notNull(factoryLocator, (String)"'factoryLocator' cannot be null");
        this.factoryLocator = factoryLocator;
    }

    public SessionFactoryLocator<F> getFactoryLocator() {
        return this.factoryLocator;
    }

    public void setThreadKey(Object key) {
        this.threadKey.set(key);
    }

    public void clearThreadKey() {
        this.threadKey.remove();
    }

    public Message<?> setThreadKey(Message<?> message, Object key) {
        this.threadKey.set(key);
        return message;
    }

    public Message<?> clearThreadKey(Message<?> message) {
        this.threadKey.remove();
        return message;
    }

    @Override
    public Session<F> getSession() {
        return this.getSession(this.threadKey.get());
    }

    public Session<F> getSession(Object key) {
        SessionFactory<F> sessionFactory = this.factoryLocator.getSessionFactory(key);
        Assert.notNull(sessionFactory, (String)"No default SessionFactory configured");
        return sessionFactory.getSession();
    }
}

