/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.locks.Lock;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.IntegrationPatternType;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.file.DefaultFileNameGenerator;
import org.springframework.integration.file.FileNameGenerator;
import org.springframework.integration.file.support.FileExistsMode;
import org.springframework.integration.file.support.FileUtils;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.handler.MessageTriggerAction;
import org.springframework.integration.support.locks.DefaultLockRegistry;
import org.springframework.integration.support.locks.LockRegistry;
import org.springframework.integration.support.locks.PassThruLockRegistry;
import org.springframework.integration.support.management.ManageableLifecycle;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.integration.util.WhileLockedProcessor;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class FileWritingMessageHandler
extends AbstractReplyProducingMessageHandler
implements ManageableLifecycle,
MessageTriggerAction {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final long DEFAULT_FLUSH_INTERVAL = 30000L;
    private static final PosixFilePermission[] POSIX_FILE_PERMISSIONS = new PosixFilePermission[]{PosixFilePermission.OTHERS_EXECUTE, PosixFilePermission.OTHERS_WRITE, PosixFilePermission.OTHERS_READ, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.GROUP_WRITE, PosixFilePermission.GROUP_READ, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_READ};
    private final Map<String, FileState> fileStates = new HashMap<String, FileState>();
    private final Expression destinationDirectoryExpression;
    private String temporaryFileSuffix = ".writing";
    private boolean temporaryFileSuffixSet = false;
    private FileExistsMode fileExistsMode = FileExistsMode.REPLACE;
    private FileNameGenerator fileNameGenerator = new DefaultFileNameGenerator();
    private boolean fileNameGeneratorSet;
    private StandardEvaluationContext evaluationContext;
    private boolean autoCreateDirectory = true;
    private boolean deleteSourceFiles;
    private Charset charset = Charset.defaultCharset();
    private boolean expectReply = true;
    private boolean appendNewLine = false;
    private LockRegistry lockRegistry = new PassThruLockRegistry();
    private int bufferSize = 8192;
    private long flushInterval = 30000L;
    private boolean flushWhenIdle = true;
    private MessageFlushPredicate flushPredicate = new DefaultFlushPredicate();
    private boolean preserveTimestamp;
    private Set<PosixFilePermission> permissions;
    private BiConsumer<File, Message<?>> newFileCallback;
    private volatile ScheduledFuture<?> flushTask;

    public FileWritingMessageHandler(File destinationDirectory) {
        Assert.notNull((Object)destinationDirectory, (String)"Destination directory must not be null.");
        this.destinationDirectoryExpression = new LiteralExpression(destinationDirectory.getPath());
    }

    public FileWritingMessageHandler(Expression destinationDirectoryExpression) {
        Assert.notNull((Object)destinationDirectoryExpression, (String)"Destination directory expression must not be null.");
        this.destinationDirectoryExpression = destinationDirectoryExpression;
    }

    public void setAutoCreateDirectory(boolean autoCreateDirectory) {
        this.autoCreateDirectory = autoCreateDirectory;
    }

    public void setTemporaryFileSuffix(String temporaryFileSuffix) {
        Assert.notNull((Object)temporaryFileSuffix, (String)"'temporaryFileSuffix' must not be null");
        this.temporaryFileSuffix = temporaryFileSuffix;
        this.temporaryFileSuffixSet = true;
    }

    public void setFileExistsMode(FileExistsMode fileExistsMode) {
        Assert.notNull((Object)((Object)fileExistsMode), (String)"'fileExistsMode' must not be null.");
        this.fileExistsMode = fileExistsMode;
        if (FileExistsMode.APPEND.equals((Object)fileExistsMode) || FileExistsMode.APPEND_NO_FLUSH.equals((Object)this.fileExistsMode)) {
            this.lockRegistry = this.lockRegistry instanceof PassThruLockRegistry ? new DefaultLockRegistry() : this.lockRegistry;
        }
    }

    public void setExpectReply(boolean expectReply) {
        this.expectReply = expectReply;
    }

    public void setAppendNewLine(boolean appendNewLine) {
        this.appendNewLine = appendNewLine;
    }

    protected String getTemporaryFileSuffix() {
        return this.temporaryFileSuffix;
    }

    public void setFileNameGenerator(FileNameGenerator fileNameGenerator) {
        Assert.notNull((Object)fileNameGenerator, (String)"FileNameGenerator must not be null");
        this.fileNameGenerator = fileNameGenerator;
        this.fileNameGeneratorSet = true;
    }

    public void setDeleteSourceFiles(boolean deleteSourceFiles) {
        this.deleteSourceFiles = deleteSourceFiles;
    }

    public void setCharset(String charset) {
        Assert.notNull((Object)charset, (String)"charset must not be null");
        Assert.isTrue((boolean)Charset.isSupported(charset), () -> "Charset '" + charset + "' is not supported.");
        this.charset = Charset.forName(charset);
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setFlushInterval(long flushInterval) {
        this.flushInterval = flushInterval;
    }

    public void setFlushWhenIdle(boolean flushWhenIdle) {
        this.flushWhenIdle = flushWhenIdle;
    }

    public void setFlushPredicate(MessageFlushPredicate flushPredicate) {
        Assert.notNull((Object)flushPredicate, (String)"'flushPredicate' cannot be null");
        this.flushPredicate = flushPredicate;
    }

    public void setPreserveTimestamp(boolean preserveTimestamp) {
        this.preserveTimestamp = preserveTimestamp;
    }

    public void setChmodOctal(String chmod) {
        Assert.notNull((Object)chmod, (String)"'chmod' cannot be null");
        this.setChmod(Integer.parseInt(chmod, 8));
    }

    public void setChmod(int chmod) {
        Assert.isTrue((chmod >= 0 && chmod <= 511 ? 1 : 0) != 0, (String)"'chmod' must be between 0 and 0777 (octal)");
        if (!FileUtils.IS_POSIX) {
            this.logger.error((CharSequence)"'chmod' setting ignored - the file system does not support Posix attributes");
            return;
        }
        BitSet bits = BitSet.valueOf(new byte[]{(byte)chmod, (byte)(chmod >> 8)});
        this.permissions = bits.stream().boxed().map(b -> POSIX_FILE_PERMISSIONS[b]).collect(Collectors.toSet());
    }

    public void setNewFileCallback(BiConsumer<File, Message<?>> newFileCallback) {
        this.newFileCallback = newFileCallback;
    }

    public String getComponentType() {
        return this.expectReply ? "file:outbound-gateway" : "file:outbound-channel-adapter";
    }

    public IntegrationPatternType getIntegrationPatternType() {
        return this.expectReply ? super.getIntegrationPatternType() : IntegrationPatternType.outbound_channel_adapter;
    }

    protected void doInit() {
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        if (this.destinationDirectoryExpression instanceof LiteralExpression) {
            File directory = ExpressionUtils.expressionToFile((Expression)this.destinationDirectoryExpression, (EvaluationContext)this.evaluationContext, null, (String)"destinationDirectoryExpression");
            this.validateDestinationDirectory(directory, this.autoCreateDirectory);
        }
        Assert.state((!this.temporaryFileSuffixSet || !FileExistsMode.APPEND.equals((Object)this.fileExistsMode) && !FileExistsMode.APPEND_NO_FLUSH.equals((Object)this.fileExistsMode) ? 1 : 0) != 0, (String)"'temporaryFileSuffix' can not be set when appending to an existing file");
        if (!this.fileNameGeneratorSet && this.fileNameGenerator instanceof BeanFactoryAware) {
            ((BeanFactoryAware)this.fileNameGenerator).setBeanFactory(this.getBeanFactory());
        }
    }

    public void start() {
        if (this.flushTask == null && FileExistsMode.APPEND_NO_FLUSH.equals((Object)this.fileExistsMode)) {
            TaskScheduler taskScheduler = this.getTaskScheduler();
            Assert.state((taskScheduler != null ? 1 : 0) != 0, (String)"'taskScheduler' is required for FileExistsMode.APPEND_NO_FLUSH");
            this.flushTask = taskScheduler.scheduleAtFixedRate((Runnable)new Flusher(), this.flushInterval / 3L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        FileWritingMessageHandler fileWritingMessageHandler = this;
        synchronized (fileWritingMessageHandler) {
            if (this.flushTask != null) {
                this.flushTask.cancel(true);
                this.flushTask = null;
            }
        }
        Flusher flusher = new Flusher();
        flusher.run();
        boolean needInterrupt = this.fileStates.size() > 0;
        int n = 0;
        while (n++ < 10 && this.fileStates.size() > 0) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            flusher.run();
        }
        if (this.fileStates.size() > 0) {
            this.logger.error((CharSequence)("Failed to flush after multiple attempts, while stopping: " + this.fileStates.keySet()));
        }
        if (needInterrupt) {
            Thread.currentThread().interrupt();
        }
    }

    public boolean isRunning() {
        return this.flushTask != null;
    }

    private void validateDestinationDirectory(File destinationDirectory, boolean autoCreateDirectory) {
        if (!destinationDirectory.exists() && autoCreateDirectory) {
            Assert.isTrue((boolean)destinationDirectory.mkdirs(), () -> "Destination directory [" + destinationDirectory + "] could not be created.");
        }
        Assert.isTrue((boolean)destinationDirectory.exists(), () -> "Destination directory [" + destinationDirectory + "] does not exist.");
        Assert.isTrue((boolean)destinationDirectory.isDirectory(), () -> "Destination path [" + destinationDirectory + "] does not point to a directory.");
        Assert.isTrue((boolean)Files.isWritable(destinationDirectory.toPath()), () -> "Destination directory [" + destinationDirectory + "] is not writable.");
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        boolean ignore;
        Object payload = requestMessage.getPayload();
        String generatedFileName = this.fileNameGenerator.generateFileName(requestMessage);
        File originalFileFromHeader = this.retrieveOriginalFileFromHeader(requestMessage);
        File destinationDirectoryToUse = this.evaluateDestinationDirectoryExpression(requestMessage);
        File tempFile = new File(destinationDirectoryToUse, generatedFileName + this.temporaryFileSuffix);
        File resultFile = new File(destinationDirectoryToUse, generatedFileName);
        boolean exists = resultFile.exists();
        if (exists && FileExistsMode.FAIL.equals((Object)this.fileExistsMode)) {
            throw new MessageHandlingException(requestMessage, "Failed to process message in the [" + (Object)((Object)this) + "]. The destination file already exists at '" + resultFile.getAbsolutePath() + "'.");
        }
        Object timestamp = requestMessage.getHeaders().get((Object)"file_setModified");
        if (payload instanceof File) {
            timestamp = ((File)payload).lastModified();
        }
        boolean bl = ignore = FileExistsMode.IGNORE.equals((Object)this.fileExistsMode) && (exists || StringUtils.hasText((String)this.temporaryFileSuffix) && tempFile.exists()) || exists && FileExistsMode.REPLACE_IF_MODIFIED.equals((Object)this.fileExistsMode) && timestamp instanceof Number && ((Number)timestamp).longValue() == resultFile.lastModified();
        if (!ignore) {
            try {
                if (!exists && generatedFileName.replaceAll("/", Matcher.quoteReplacement(File.separator)).contains(File.separator)) {
                    resultFile.getParentFile().mkdirs();
                }
                resultFile = this.writeMessageToFile(requestMessage, originalFileFromHeader, tempFile, resultFile, timestamp);
            }
            catch (Exception e) {
                throw IntegrationUtils.wrapInHandlingExceptionIfNecessary(requestMessage, () -> "failed to write Message payload to file in the [" + (Object)((Object)this) + ']', (Throwable)e);
            }
        }
        if (!this.expectReply) {
            return null;
        }
        if (resultFile != null && originalFileFromHeader == null && payload instanceof File) {
            return this.getMessageBuilderFactory().withPayload((Object)resultFile).setHeader("file_originalFile", payload);
        }
        return resultFile;
    }

    private File writeMessageToFile(Message<?> requestMessage, File originalFileFromHeader, File tempFile, File resultFile, Object timestamp) throws IOException {
        File fileToReturn;
        Object payload = requestMessage.getPayload();
        if (payload instanceof File) {
            fileToReturn = this.handleFileMessage((File)payload, tempFile, resultFile, requestMessage);
        } else if (payload instanceof InputStream) {
            fileToReturn = this.handleInputStreamMessage((InputStream)payload, originalFileFromHeader, tempFile, resultFile, requestMessage);
        } else if (payload instanceof byte[]) {
            fileToReturn = this.handleByteArrayMessage((byte[])payload, originalFileFromHeader, tempFile, resultFile, requestMessage);
        } else if (payload instanceof String) {
            fileToReturn = this.handleStringMessage((String)payload, originalFileFromHeader, tempFile, resultFile, requestMessage);
        } else {
            throw new IllegalArgumentException("Unsupported Message payload type [" + payload.getClass().getName() + "]");
        }
        if (this.preserveTimestamp) {
            if (timestamp instanceof Number) {
                if (!fileToReturn.setLastModified(((Number)timestamp).longValue())) {
                    throw new IllegalStateException("Could not set last modified '" + timestamp + "' timestamp on file: " + fileToReturn);
                }
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn((CharSequence)("Could not set lastModified, header file_setModified must be a Number, not " + (timestamp == null ? "null" : timestamp.getClass())));
            }
        }
        return fileToReturn;
    }

    private File retrieveOriginalFileFromHeader(Message<?> message) {
        Object value = message.getHeaders().get((Object)"file_originalFile");
        if (value instanceof File) {
            return (File)value;
        }
        if (value instanceof String) {
            return new File((String)value);
        }
        return null;
    }

    private File handleFileMessage(File sourceFile, File tempFile, File resultFile, Message<?> requestMessage) throws IOException {
        if (!FileExistsMode.APPEND.equals((Object)this.fileExistsMode) && this.deleteSourceFiles) {
            FileWritingMessageHandler.rename(sourceFile, resultFile);
            return resultFile;
        }
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(sourceFile));
        return this.handleInputStreamMessage(bis, sourceFile, tempFile, resultFile, requestMessage);
    }

    private File handleInputStreamMessage(final InputStream sourceFileInputStream, File originalFile, File tempFile, File resultFile, final Message<?> requestMessage) throws IOException {
        boolean append;
        boolean bl = append = FileExistsMode.APPEND.equals((Object)this.fileExistsMode) || FileExistsMode.APPEND_NO_FLUSH.equals((Object)this.fileExistsMode);
        if (append) {
            final File fileToWriteTo = this.determineFileToWrite(resultFile, tempFile);
            WhileLockedProcessor whileLockedProcessor = new WhileLockedProcessor(this.lockRegistry, fileToWriteTo.getAbsolutePath()){

                protected void whileLocked() throws IOException {
                    if (FileWritingMessageHandler.this.newFileCallback != null && !fileToWriteTo.exists()) {
                        FileWritingMessageHandler.this.newFileCallback.accept(fileToWriteTo, requestMessage);
                    }
                    FileWritingMessageHandler.this.appendStreamToFile(fileToWriteTo, sourceFileInputStream);
                }
            };
            whileLockedProcessor.doWhileLocked();
            this.cleanUpAfterCopy(fileToWriteTo, resultFile, originalFile);
            return resultFile;
        }
        try (InputStream inputStream = sourceFileInputStream;
             BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(tempFile), this.bufferSize);){
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                ((OutputStream)outputStream).write(buffer, 0, bytesRead);
            }
            if (this.appendNewLine) {
                ((OutputStream)outputStream).write(System.lineSeparator().getBytes());
            }
            ((OutputStream)outputStream).flush();
        }
        this.cleanUpAfterCopy(tempFile, resultFile, originalFile);
        return resultFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendStreamToFile(File fileToWriteTo, InputStream sourceFileInputStream) throws IOException {
        FileState state = this.getFileState(fileToWriteTo, false);
        FilterOutputStream bos = null;
        try (InputStream inputStream = sourceFileInputStream;){
            bos = state != null ? state.stream : this.createOutputStream(fileToWriteTo, true);
            byte[] buffer = new byte[4096];
            int bytesRead = -1;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                ((BufferedOutputStream)bos).write(buffer, 0, bytesRead);
            }
            if (this.appendNewLine) {
                bos.write(System.lineSeparator().getBytes());
            }
        }
        finally {
            try {
                if (state == null || this.flushTask == null) {
                    if (bos != null) {
                        bos.close();
                    }
                    this.clearState(fileToWriteTo, state);
                } else {
                    state.lastWrite = System.currentTimeMillis();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private File handleByteArrayMessage(final byte[] bytes, File originalFile, File tempFile, File resultFile, final Message<?> requestMessage) throws IOException {
        final File fileToWriteTo = this.determineFileToWrite(resultFile, tempFile);
        final boolean append = FileExistsMode.APPEND.equals((Object)this.fileExistsMode) || FileExistsMode.APPEND_NO_FLUSH.equals((Object)this.fileExistsMode);
        WhileLockedProcessor whileLockedProcessor = new WhileLockedProcessor(this.lockRegistry, fileToWriteTo.getAbsolutePath()){

            protected void whileLocked() throws IOException {
                if (append && FileWritingMessageHandler.this.newFileCallback != null && !fileToWriteTo.exists()) {
                    FileWritingMessageHandler.this.newFileCallback.accept(fileToWriteTo, requestMessage);
                }
                FileWritingMessageHandler.this.writeBytesToFile(fileToWriteTo, append, bytes);
            }
        };
        whileLockedProcessor.doWhileLocked();
        this.cleanUpAfterCopy(fileToWriteTo, resultFile, originalFile);
        return resultFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBytesToFile(File fileToWriteTo, boolean append, byte[] bytes) throws IOException {
        FileState state = this.getFileState(fileToWriteTo, false);
        BufferedOutputStream bos = null;
        try {
            bos = state != null ? state.stream : this.createOutputStream(fileToWriteTo, append);
            bos.write(bytes);
            if (this.appendNewLine) {
                bos.write(System.lineSeparator().getBytes());
            }
        }
        finally {
            try {
                if (state == null || this.flushTask == null) {
                    if (bos != null) {
                        bos.close();
                    }
                    this.clearState(fileToWriteTo, state);
                } else {
                    state.lastWrite = System.currentTimeMillis();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private File handleStringMessage(final String content, File originalFile, File tempFile, File resultFile, final Message<?> requestMessage) throws IOException {
        final File fileToWriteTo = this.determineFileToWrite(resultFile, tempFile);
        final boolean append = FileExistsMode.APPEND.equals((Object)this.fileExistsMode) || FileExistsMode.APPEND_NO_FLUSH.equals((Object)this.fileExistsMode);
        WhileLockedProcessor whileLockedProcessor = new WhileLockedProcessor(this.lockRegistry, fileToWriteTo.getAbsolutePath()){

            protected void whileLocked() throws IOException {
                if (append && FileWritingMessageHandler.this.newFileCallback != null && !fileToWriteTo.exists()) {
                    FileWritingMessageHandler.this.newFileCallback.accept(fileToWriteTo, requestMessage);
                }
                FileWritingMessageHandler.this.writeStringToFile(fileToWriteTo, append, content);
            }
        };
        whileLockedProcessor.doWhileLocked();
        this.cleanUpAfterCopy(fileToWriteTo, resultFile, originalFile);
        return resultFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStringToFile(File fileToWriteTo, boolean append, String content) throws IOException {
        FileState state = this.getFileState(fileToWriteTo, true);
        BufferedWriter writer = null;
        try {
            writer = state != null ? state.writer : this.createWriter(fileToWriteTo, append);
            writer.write(content);
            if (this.appendNewLine) {
                writer.newLine();
            }
        }
        finally {
            try {
                if (state == null || this.flushTask == null) {
                    if (writer != null) {
                        writer.close();
                    }
                    this.clearState(fileToWriteTo, state);
                } else {
                    state.lastWrite = System.currentTimeMillis();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private File determineFileToWrite(File resultFile, File tempFile) {
        File fileToWriteTo;
        switch (this.fileExistsMode) {
            case APPEND: 
            case APPEND_NO_FLUSH: {
                fileToWriteTo = resultFile;
                break;
            }
            case FAIL: 
            case IGNORE: 
            case REPLACE: 
            case REPLACE_IF_MODIFIED: {
                fileToWriteTo = tempFile;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported FileExistsMode: " + (Object)((Object)this.fileExistsMode));
            }
        }
        return fileToWriteTo;
    }

    private void cleanUpAfterCopy(File fileToWriteTo, File resultFile, File originalFile) throws IOException {
        if (!FileExistsMode.APPEND.equals((Object)this.fileExistsMode) && !FileExistsMode.APPEND_NO_FLUSH.equals((Object)this.fileExistsMode) && StringUtils.hasText((String)this.temporaryFileSuffix)) {
            this.renameTo(fileToWriteTo, resultFile);
        }
        if (this.deleteSourceFiles && originalFile != null && !originalFile.delete()) {
            throw new IllegalStateException("Could not delete original file: " + originalFile);
        }
        this.setPermissions(resultFile);
    }

    protected void setPermissions(File resultFile) throws IOException {
        if (this.permissions != null) {
            Files.setPosixFilePermissions(resultFile.toPath(), this.permissions);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void renameTo(File tempFile, File resultFile) throws IOException {
        Assert.notNull((Object)resultFile, (String)"'resultFile' must not be null");
        Assert.notNull((Object)tempFile, (String)"'tempFile' must not be null");
        if (resultFile.exists()) {
            if (!resultFile.setWritable(true, false) || !resultFile.delete()) throw new IOException("Failed to rename file '" + tempFile.getAbsolutePath() + "' to '" + resultFile.getAbsolutePath() + "' since '" + resultFile.getName() + "' is not writable or can not be deleted");
            FileWritingMessageHandler.rename(tempFile, resultFile);
            return;
        } else {
            FileWritingMessageHandler.rename(tempFile, resultFile);
        }
    }

    private File evaluateDestinationDirectoryExpression(Message<?> message) {
        File destinationDirectory = ExpressionUtils.expressionToFile((Expression)this.destinationDirectoryExpression, (EvaluationContext)this.evaluationContext, message, (String)"Destination Directory");
        this.validateDestinationDirectory(destinationDirectory, this.autoCreateDirectory);
        return destinationDirectory;
    }

    private synchronized FileState getFileState(File fileToWriteTo, boolean isString) throws FileNotFoundException {
        FileState state;
        boolean appendNoFlush = FileExistsMode.APPEND_NO_FLUSH.equals((Object)this.fileExistsMode);
        if (appendNoFlush) {
            String absolutePath = fileToWriteTo.getAbsolutePath();
            state = this.fileStates.get(absolutePath);
            if (state != null && (isString && state.stream != null || !isString && state.writer != null)) {
                state.close();
                state = null;
                this.fileStates.remove(absolutePath);
            }
            if (state == null) {
                state = isString ? new FileState(this.createWriter(fileToWriteTo, true), this.lockRegistry.obtain((Object)fileToWriteTo.getAbsolutePath())) : new FileState(this.createOutputStream(fileToWriteTo, true), this.lockRegistry.obtain((Object)fileToWriteTo.getAbsolutePath()));
                this.fileStates.put(absolutePath, state);
            }
            state.lastWrite = Long.MAX_VALUE;
        } else {
            state = null;
        }
        return state;
    }

    protected BufferedWriter createWriter(File fileToWriteTo, boolean append) throws FileNotFoundException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileToWriteTo, append), this.charset), this.bufferSize);
    }

    protected BufferedOutputStream createOutputStream(File fileToWriteTo, boolean append) throws FileNotFoundException {
        return new BufferedOutputStream(new FileOutputStream(fileToWriteTo, append), this.bufferSize);
    }

    public void trigger(Message<?> message) {
        this.flushIfNeeded(this.flushPredicate, message);
    }

    public void flushIfNeeded(FlushPredicate flushPredicate) {
        this.flushIfNeeded((fileAbsolutePath, firstWrite, lastWrite, filterMessage) -> flushPredicate.shouldFlush(fileAbsolutePath, firstWrite, lastWrite), null);
    }

    public void flushIfNeeded(MessageFlushPredicate flushPredicate, Message<?> filterMessage) {
        this.doFlush(this.findFilesToFlush(flushPredicate, filterMessage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, FileState> findFilesToFlush(MessageFlushPredicate flushPredicate, Message<?> filterMessage) {
        HashMap<String, FileState> toRemove = new HashMap<String, FileState>();
        FileWritingMessageHandler fileWritingMessageHandler = this;
        synchronized (fileWritingMessageHandler) {
            Iterator<Map.Entry<String, FileState>> iterator = this.fileStates.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, FileState> entry = iterator.next();
                FileState state = entry.getValue();
                if (!flushPredicate.shouldFlush(entry.getKey(), state.firstWrite, state.lastWrite, filterMessage)) continue;
                iterator.remove();
                toRemove.put(entry.getKey(), state);
            }
        }
        return toRemove;
    }

    private synchronized void clearState(File fileToWriteTo, FileState state) {
        if (state != null) {
            this.fileStates.remove(fileToWriteTo.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFlush(Map<String, FileState> toRemove) {
        HashMap<String, FileState> toRestore = new HashMap<String, FileState>();
        boolean interrupted = false;
        for (Map.Entry<String, FileState> entry : toRemove.entrySet()) {
            if (!interrupted && entry.getValue().close()) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((CharSequence)("Flushed: " + entry.getKey()));
                continue;
            }
            interrupted = true;
            toRestore.put(entry.getKey(), entry.getValue());
        }
        if (interrupted) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((CharSequence)("Interrupted during flush; not flushed: " + toRestore.keySet()));
            }
            Object object = this;
            synchronized (object) {
                for (Map.Entry entry : toRestore.entrySet()) {
                    this.fileStates.putIfAbsent((String)entry.getKey(), (FileState)entry.getValue());
                }
            }
        }
    }

    private static void rename(File source, File target) throws IOException {
        Files.move(source.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private static final class DefaultFlushPredicate
    implements MessageFlushPredicate {
        DefaultFlushPredicate() {
        }

        @Override
        public boolean shouldFlush(String fileAbsolutePath, long firstWrite, long lastWrite, Message<?> triggerMessage) {
            Pattern pattern;
            if (triggerMessage.getPayload() instanceof String) {
                pattern = Pattern.compile((String)triggerMessage.getPayload());
            } else if (triggerMessage.getPayload() instanceof Pattern) {
                pattern = (Pattern)triggerMessage.getPayload();
            } else {
                throw new IllegalArgumentException("Invalid payload type, must be a String or Pattern");
            }
            return pattern.matcher(fileAbsolutePath).matches();
        }
    }

    @FunctionalInterface
    public static interface MessageFlushPredicate {
        public boolean shouldFlush(String var1, long var2, long var4, Message<?> var6);
    }

    @FunctionalInterface
    public static interface FlushPredicate {
        public boolean shouldFlush(String var1, long var2, long var4);
    }

    private final class Flusher
    implements Runnable {
        Flusher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashMap toRemove = new HashMap();
            FileWritingMessageHandler fileWritingMessageHandler = FileWritingMessageHandler.this;
            synchronized (fileWritingMessageHandler) {
                long expired = FileWritingMessageHandler.this.flushTask == null ? Long.MAX_VALUE : System.currentTimeMillis() - FileWritingMessageHandler.this.flushInterval;
                Iterator iterator = FileWritingMessageHandler.this.fileStates.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    FileState state = (FileState)entry.getValue();
                    if (state.lastWrite >= expired && (FileWritingMessageHandler.this.flushWhenIdle || state.firstWrite >= expired)) continue;
                    toRemove.put(entry.getKey(), state);
                    iterator.remove();
                }
            }
            FileWritingMessageHandler.this.doFlush(toRemove);
        }
    }

    private static final class FileState {
        private final BufferedWriter writer;
        private final BufferedOutputStream stream;
        private final Lock lock;
        private final long firstWrite = System.currentTimeMillis();
        private volatile long lastWrite;

        FileState(BufferedWriter writer, Lock lock) {
            this.writer = writer;
            this.stream = null;
            this.lock = lock;
        }

        FileState(BufferedOutputStream stream, Lock lock) {
            this.writer = null;
            this.stream = stream;
            this.lock = lock;
        }

        private boolean close() {
            try {
                this.lock.lockInterruptibly();
                try {
                    if (this.writer != null) {
                        this.writer.close();
                    } else {
                        this.stream.close();
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    this.lock.unlock();
                }
                return true;
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
    }
}

